/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServiceUser;
import org.chorem.pollen.business.converters.DataUserConverter;
import org.chorem.pollen.business.dto.UserDTO;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceUserImpl
implements ServiceUser {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private UserAccountDAO userDAO = null;
    private DataUserConverter converter = new DataUserConverter();
    private static final Log log = LogFactory.getLog(ServiceUserImpl.class);

    @Override
    public String createUser(UserDTO user, String password) {
        String topiaId = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            Object userEntity = this.userDAO.findByLogin(user.getLogin());
            if (userEntity == null) {
                userEntity = (UserAccount)this.userDAO.create(new Object[0]);
                this.converter.populateUserEntity(user, (UserAccount)userEntity, password);
                topiaId = userEntity.getTopiaId();
                this.transaction.commitTransaction();
                this.transaction.closeContext();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Entity created: " + topiaId));
                }
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean deleteUser(String login) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            Object userEntity = this.userDAO.findByLogin(login);
            this.userDAO.delete(userEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + userEntity.getTopiaId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deleteUser(UserDTO user) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(user.getId());
            this.userDAO.delete(userEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + userEntity.getTopiaId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public UserDTO findUserById(String userId) {
        UserDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(userId);
            if (userEntity != null) {
                this.converter.setTransaction(this.transaction);
                result = this.converter.createUserDTO(userEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<UserDTO> selectUsers(Map<String, Object> properties) {
        List<UserDTO> results = null;
        List userEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            if (properties == null) {
                userEntities = this.userDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les utilisateurs ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                userEntities = this.userDAO.findAllByProperties(properties);
            }
            results = this.converter.createUserDTOs(userEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean updateUser(UserDTO user) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(user.getId());
            this.converter.setTransaction(this.transaction);
            this.converter.populateUserEntity(user, userEntity);
            this.userDAO.update(userEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + user.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean addPollAccountToUser(String login, String pollAccountId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            Object userEntity = this.userDAO.findByLogin(login);
            PollAccountDAO pollAccountDAO = PollenModelDAOHelper.getPollAccountDAO(this.transaction);
            PollAccount pollAccountEntity = (PollAccount)pollAccountDAO.findByTopiaId(pollAccountId);
            userEntity.addPollAccount(pollAccountEntity);
            userEntity.update();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + userEntity.getTopiaId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean updatePasswordUser(UserDTO user, String newPassword) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.userDAO = PollenModelDAOHelper.getUserAccountDAO(this.transaction);
            UserAccount userEntity = (UserAccount)this.userDAO.findByTopiaId(user.getId());
            userEntity.setPassword(newPassword);
            userEntity.update();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + user.getId()));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

