/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.ServiceChoice;
import org.chorem.pollen.business.converters.DataChoiceConverter;
import org.chorem.pollen.business.dto.ChoiceDTO;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.PollenModelDAOHelper;
import org.chorem.pollen.business.utils.ContextUtil;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ServiceChoiceImpl
implements ServiceChoice {
    private TopiaContext rootContext = ContextUtil.getInstance().getContext();
    private TopiaContext transaction = null;
    private ChoiceDAO choiceDAO = null;
    private DataChoiceConverter converter = new DataChoiceConverter();
    private static final Log log = LogFactory.getLog(ServiceChoiceImpl.class);

    @Override
    public String createChoice(ChoiceDTO choice) {
        String topiaId = "";
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.create(new Object[0]);
            this.converter.setTransaction(this.transaction);
            this.converter.populateChoiceEntity(choice, choiceEntity);
            topiaId = choiceEntity.getTopiaId();
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity created: " + topiaId));
            }
            return topiaId;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return "";
        }
    }

    @Override
    public List<Choice> createChoices(List<ChoiceDTO> choices, String pollId, TopiaContext trans) {
        if (choices.isEmpty() || pollId.length() == 0) {
            return null;
        }
        ArrayList<Choice> result = null;
        try {
            this.transaction = trans;
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(trans);
            this.converter.setTransaction(trans);
            result = new ArrayList<Choice>();
            for (ChoiceDTO choice : choices) {
                Choice choiceEntity = (Choice)this.choiceDAO.create(new Object[0]);
                choice.setId(choiceEntity.getTopiaId());
                choice.setPollId(pollId);
                this.converter.populateChoiceEntity(choice, choiceEntity);
                result.add(choiceEntity);
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public boolean updateChoice(ChoiceDTO choiceDTO) {
        boolean resu = false;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.findByTopiaId(choiceDTO.getId());
            if (choiceEntity != null) {
                this.converter.setTransaction(this.transaction);
                this.converter.populateChoiceEntity(choiceDTO, choiceEntity);
                this.choiceDAO.update(choiceEntity);
                this.transaction.commitTransaction();
                resu = true;
            }
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity updated: " + choiceDTO.getId()));
            }
            return resu;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public boolean deleteChoice(String choiceId) {
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.findByTopiaId(choiceId);
            this.choiceDAO.delete(choiceEntity);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity deleted: " + choiceId));
            }
            return true;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return false;
        }
    }

    @Override
    public ChoiceDTO findChoiceById(String choiceId) {
        ChoiceDTO result = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            Choice choiceEntity = (Choice)this.choiceDAO.findByTopiaId(choiceId);
            if (choiceEntity != null) {
                this.converter.setTransaction(this.transaction);
                result = this.converter.createChoiceDTO(choiceEntity);
            }
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entity found: " + (result == null ? "null" : result.getId())));
            }
            return result;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<ChoiceDTO> findChoicesByName(String choiceName, String pollId) {
        List<ChoiceDTO> results = null;
        List choiceEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("pollId", pollId);
            properties.put("name", choiceName);
            choiceEntities = this.choiceDAO.findAllByProperties(properties);
            this.converter.setTransaction(this.transaction);
            results = this.converter.createChoiceDTOs(choiceEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    @Override
    public List<ChoiceDTO> selectChoices(Map<String, Object> properties) {
        List<ChoiceDTO> results = null;
        List choiceEntities = null;
        try {
            this.transaction = this.rootContext.beginTransaction();
            this.choiceDAO = PollenModelDAOHelper.getChoiceDAO(this.transaction);
            if (properties == null) {
                choiceEntities = this.choiceDAO.findAll();
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Attention : tous les choix ont \u00e9t\u00e9 s\u00e9lectionn\u00e9s !");
                }
            } else {
                choiceEntities = this.choiceDAO.findAllByProperties(properties);
            }
            this.converter.setTransaction(this.transaction);
            results = this.converter.createChoiceDTOs(choiceEntities);
            this.transaction.commitTransaction();
            this.transaction.closeContext();
            if (log.isInfoEnabled()) {
                log.info((Object)("Entities found: " + (results == null ? "null" : Integer.valueOf(results.size()))));
            }
            return results;
        }
        catch (TopiaException e) {
            this.doCatch(e);
            return null;
        }
    }

    private void doCatch(TopiaException e) {
        try {
            if (this.transaction != null) {
                this.transaction.rollbackTransaction();
                this.transaction.closeContext();
            }
        }
        catch (TopiaException ex) {
            ex.printStackTrace();
        }
        e.printStackTrace();
    }
}

