/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Vote}.
 */
public abstract class VoteAbstract extends TopiaEntityAbstract implements Vote {

    public double weight;

    public String comment;

    public List<VoteToChoice> choiceVoteToChoice;

    public Poll poll;

    public PollAccount pollAccount;

    public VotingList votingList;

    /**
     * Constructeur de VoteAbstract par défaut.
     */
    public VoteAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Vote.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Vote.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "weight", double.class, weight);
        visitor.visit(this, "comment", String.class, comment);
        visitor.visit(this, "choiceVoteToChoice", java.util.List.class, VoteToChoice.class, choiceVoteToChoice);
        visitor.visit(this, "poll", Poll.class, poll);
        visitor.visit(this, "pollAccount", PollAccount.class, pollAccount);
        visitor.visit(this, "votingList", VotingList.class, votingList);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        tmp.addAll(((TopiaContextImplementor)getTopiaContext())
            .getDAO(VoteToChoice.class)
            .findAllByProperties("vote", this));

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Vote#setWeight(double)
     */
    @Override
    public void setWeight(double value) {
        double _oldValue = this.weight;
        fireOnPreWrite("weight", _oldValue, value);
        this.weight = value;
        fireOnPostWrite("weight", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Vote#getWeight()
     */
    @Override
    public double getWeight() {
        fireOnPreRead("weight", weight);
        double result = this.weight;
        fireOnPostRead("weight", weight);
        return result;
    }

    /* (non-Javadoc)
     * @see Vote#setComment(String)
     */
    @Override
    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite("comment", _oldValue, value);
        this.comment = value;
        fireOnPostWrite("comment", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Vote#getComment()
     */
    @Override
    public String getComment() {
        fireOnPreRead("comment", comment);
        String result = this.comment;
        fireOnPostRead("comment", comment);
        return result;
    }

    /* (non-Javadoc)
     * @see Vote#addChoiceVoteToChoice(VoteToChoice)
     */
    @Override
    public void addChoiceVoteToChoice(VoteToChoice value) {
        fireOnPreWrite("choiceVoteToChoice", null, value);
        if (this.choiceVoteToChoice == null) {
            this.choiceVoteToChoice = new ArrayList<VoteToChoice>();
        }
        value.setVote(this);
        this.choiceVoteToChoice.add(value);
        fireOnPostWrite("choiceVoteToChoice", this.choiceVoteToChoice.size(), null, value);
    }

    /* (non-Javadoc)
     * @see Vote#getChoiceByTopiaId(String)
     */
    @Override
    public VoteToChoice getChoiceVoteToChoiceByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(choiceVoteToChoice, topiaId);
    }

    /* (non-Javadoc)
     * @see Vote#addAllChoiceVoteToChoice(List<VoteToChoice>()
     */
    @Override
    public void addAllChoiceVoteToChoice(List<VoteToChoice> values) {
        if (values == null) {
            return;
        }
        for (VoteToChoice item : values) {
            addChoiceVoteToChoice(item);
        }
    }

    /* (non-Javadoc)
     * @see Vote#setChoiceVoteToChoice(List<VoteToChoice>()
     */
    @Override
    public void setChoiceVoteToChoice(List<VoteToChoice> values) {
//        clearChoiceVoteToChoice();
//        addAllChoiceVoteToChoice(values);
// FIXME
        List<VoteToChoice> _oldValue = choiceVoteToChoice;
        fireOnPreWrite("choiceVoteToChoice", _oldValue, values);
        choiceVoteToChoice = values;
        fireOnPostWrite("choiceVoteToChoice", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see Vote#removeChoiceVoteToChoice(VoteToChoice)
     */
    @Override
    public void removeChoiceVoteToChoice(VoteToChoice value) {
        fireOnPreWrite("choiceVoteToChoice", value, null);
        if ((this.choiceVoteToChoice == null) || (!this.choiceVoteToChoice.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setVote(null);
        fireOnPostWrite("choiceVoteToChoice", this.choiceVoteToChoice.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see Vote#clearChoiceVoteToChoice()
     */
    @Override
    public void clearChoiceVoteToChoice() {
        if (this.choiceVoteToChoice == null) {
            return;
        }
        for (VoteToChoice item : this.choiceVoteToChoice) {
            item.setVote(null);
        }
        List<VoteToChoice> _oldValue = new ArrayList<VoteToChoice>(this.choiceVoteToChoice);
        fireOnPreWrite("choiceVoteToChoice", _oldValue, null);
        this.choiceVoteToChoice.clear();
        fireOnPostWrite("choiceVoteToChoice", _oldValue, null);
    }

    /* (non-Javadoc)
     * @see Vote#getChoiceVoteToChoice()
     */
    @Override
    public List<VoteToChoice> getChoiceVoteToChoice() {
        return choiceVoteToChoice;
    }

    /* (non-Javadoc)
     * @see Vote#getChoiceVoteToChoice(Choice)
     */
    @Override
    public VoteToChoice getChoiceVoteToChoice(Choice value) {
        if (value == null || choiceVoteToChoice == null) {
            return null;
        }
        for (VoteToChoice item : choiceVoteToChoice) {
            if (value.equals(item.getChoice())) {
                return item;
            }
        }
        return null;
    }

    /* (non-Javadoc)
     * @see Vote#sizeChoiceVoteToChoice()
     */
    @Override
    public int sizeChoiceVoteToChoice() {
        if (choiceVoteToChoice == null) {
            return 0;
        }
        return choiceVoteToChoice.size();
    }

    /* (non-Javadoc)
     * @see Vote#isChoiceVoteToChoiceEmpty()
     */
    @Override
    public boolean isChoiceVoteToChoiceEmpty() {
        int size = sizeChoiceVoteToChoice();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see Vote#setPoll(Poll)
     */
    @Override
    public void setPoll(Poll value) {
        Poll _oldValue = this.poll;
        fireOnPreWrite("poll", _oldValue, value);
        this.poll = value;
        fireOnPostWrite("poll", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Vote#getPoll()
     */
    @Override
    public Poll getPoll() {
        fireOnPreRead("poll", poll);
        Poll result = this.poll;
        fireOnPostRead("poll", poll);
        return result;
    }

    /* (non-Javadoc)
     * @see Vote#setPollAccount(PollAccount)
     */
    @Override
    public void setPollAccount(PollAccount value) {
        PollAccount _oldValue = this.pollAccount;
        fireOnPreWrite("pollAccount", _oldValue, value);
        this.pollAccount = value;
        fireOnPostWrite("pollAccount", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Vote#getPollAccount()
     */
    @Override
    public PollAccount getPollAccount() {
        fireOnPreRead("pollAccount", pollAccount);
        PollAccount result = this.pollAccount;
        fireOnPostRead("pollAccount", pollAccount);
        return result;
    }

    /* (non-Javadoc)
     * @see Vote#setVotingList(VotingList)
     */
    @Override
    public void setVotingList(VotingList value) {
        VotingList _oldValue = this.votingList;
        fireOnPreWrite("votingList", _oldValue, value);
        this.votingList = value;
        fireOnPostWrite("votingList", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Vote#getVotingList()
     */
    @Override
    public VotingList getVotingList() {
        fireOnPreRead("votingList", votingList);
        VotingList result = this.votingList;
        fireOnPostRead("votingList", votingList);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("weight", this.weight).
            append("comment", this.comment).
         toString();
        return result;
    }
        
} //VoteAbstract
