/*
 * #%L
 * JMexico :: Swing Editor
 * 
 * $Id: MexicoDecoratorProvider.java 84 2012-10-07 11:38:35Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.10/jmexico-editor/src/main/java/fr/reseaumexico/editor/MexicoDecoratorProvider.java $
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.editor;

import fr.reseaumexico.model.Factor;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.util.decorator.DecoratorProvider;

/**
 * @author sletellier <letellier@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class MexicoDecoratorProvider extends DecoratorProvider {

    @Override
    protected void loadDecorators() {
        registerDecorator(new Decorator<Factor>(Factor.class) {
            private static final long serialVersionUID = 1L;

            @Override
            public String toString(Object bean) {
                String result = null;
                if (bean != null) {
                    Factor f = (Factor) bean;
                    if (StringUtils.isNotEmpty(f.getName())) {

                        // use name
                        result = f.getName();
                    } else {

                        // fallback on id
                        result = f.getId();
                    }
                }
                return result;
            }
        });
    }
}
