/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor;

import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.MexicoUtil;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ValueType;
import fr.reseaumexico.model.event.InputDesignScenarioEvent;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.i18n.I18n;

public class InputDesignTableModel
extends AbstractTableModel
implements InputDesignScenarioListener {
    private static final long serialVersionUID = 1L;
    protected TableModel delegate = new DefaultTableModel();
    protected InputDesign inputDesign;
    protected List<Factor> factors;

    public void setInputDesign(InputDesign inputDesign) {
        this.inputDesign = inputDesign;
        inputDesign.addInputDesignScenarioListener((InputDesignScenarioListener)this);
        this.factors = new LinkedList<Factor>(inputDesign.getExperimentDesign().getFactor());
        Collections.sort(this.factors, new Comparator<Factor>(){

            @Override
            public int compare(Factor o1, Factor o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
        this.fireTableStructureChanged();
    }

    public void scenarioAdded(InputDesignScenarioEvent event) {
        this.fireTableStructureChanged();
    }

    public void scenarioRemoved(InputDesignScenarioEvent event) {
        this.fireTableStructureChanged();
    }

    public InputDesign getInputDesign() {
        return this.inputDesign;
    }

    public Collection<Scenario> getScenarios() {
        return this.inputDesign.getScenario();
    }

    public Scenario getScenario(int i) {
        return this.inputDesign.getScenario(i);
    }

    public Factor getFactor(int i) {
        return this.factors.get(i);
    }

    @Override
    public int getRowCount() {
        if (this.inputDesign == null) {
            return this.delegate.getRowCount();
        }
        return this.factors == null ? 0 : this.factors.size();
    }

    @Override
    public int getColumnCount() {
        if (this.inputDesign == null) {
            return this.delegate.getColumnCount();
        }
        Collection<Scenario> scenarios = this.getScenarios();
        if (scenarios == null) {
            return 1;
        }
        return scenarios.size() + 1;
    }

    @Override
    public String getColumnName(int rowIndex) {
        if (this.inputDesign == null) {
            return this.delegate.getColumnName(rowIndex);
        }
        if (rowIndex == 0) {
            return I18n._((String)"jmexico.factor.name", (Object[])new Object[0]);
        }
        Scenario scenario = this.getScenario(rowIndex - 1);
        return scenario == null ? "" : scenario.getName();
    }

    @Override
    public Class<?> getColumnClass(int rowIndex) {
        if (this.inputDesign == null) {
            return this.delegate.getColumnClass(rowIndex);
        }
        if (rowIndex == 0) {
            return Factor.class;
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.inputDesign == null) {
            return this.delegate.isCellEditable(rowIndex, columnIndex);
        }
        return columnIndex > 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Scenario scenario;
        if (this.inputDesign == null) {
            return this.delegate.getValueAt(rowIndex, columnIndex);
        }
        Factor factor = this.getFactor(rowIndex);
        if (columnIndex == 0) {
            return factor;
        }
        if ((scenario = this.getScenario(--columnIndex)) == null) {
            return null;
        }
        Map factorValues = scenario.getFactorValues();
        Object result = factorValues.get(factor);
        return result;
    }

    @Override
    public void setValueAt(Object o, int rowIndex, int columnIndex) {
        if (this.inputDesign == null) {
            this.delegate.setValueAt(o, rowIndex, columnIndex);
            return;
        }
        if (columnIndex == 0) {
            return;
        }
        int scenarioIndex = columnIndex - 1;
        Scenario scenario = this.getScenario(scenarioIndex);
        Factor factor = this.getFactor(rowIndex);
        ValueType valueType = factor.getDomain().getValueType();
        String value = ObjectUtils.toString((Object)o);
        scenario.setFactorValue(factor, MexicoUtil.getTypedValue((ValueType)valueType, (String)value));
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }
}

