/*
 * #%L
 * JMexico :: Swing Editor Demo
 * 
 * $Id: MexicoEditorDemoUIModel.java 40 2012-01-26 16:36:49Z sletellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/jmexico/tags/jmexico-0.2/jmexico-editor-demo/src/main/java/fr/reseaumexico/editor/demo/MexicoEditorDemoUIModel.java $
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.editor.demo;

import fr.reseaumexico.model.InputDesign;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;

/** @author sletellier <letellier@codelutin.com> */
public class MexicoEditorDemoUIModel {

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static final String PROPERTY_OPTION_CHANGED = "optionChanged";
    public static final String PROPERTY_INPUT_DESIGN = "inputDesign";
    public static final String PROPERTY_INPUT_DESIGN_FILE = "inputDesignFile";

    protected InputDesign inputDesign;
    protected File inputDesignFile;
    protected boolean optionChanged;

    public File getInputDesignFile() {
        return inputDesignFile;
    }

    public void setInputDesignFile(File inputDesignFile) {
        File oldInputDesignFile = getInputDesignFile();
        this.inputDesignFile = inputDesignFile;
        firePropertyChange(PROPERTY_INPUT_DESIGN_FILE, oldInputDesignFile, inputDesignFile);
    }

    public InputDesign getInputDesign() {
        return inputDesign;
    }

    public void setInputDesign(InputDesign inputDesign) {
        InputDesign oldInputDesign = getInputDesign();
        this.inputDesign = inputDesign;
        setOptionChanged(true);
        firePropertyChange(PROPERTY_INPUT_DESIGN, oldInputDesign, inputDesign);
    }

    public boolean isOptionChanged() {
        return optionChanged;
    }

    public void setOptionChanged(boolean optionChanged) {
        boolean oldValue = isOptionChanged();
        this.optionChanged = optionChanged;
        firePropertyChange(PROPERTY_OPTION_CHANGED, oldValue, optionChanged);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }
}
