/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.t3.web.actions.admin;

import com.google.common.collect.Maps;
import fr.ird.t3.actions.T3ActionConfiguration;
import fr.ird.t3.actions.T3ActionContext;
import fr.ird.t3.actions.admin.DeleteTripConfiguration;
import fr.ird.t3.entities.data.Trip;
import fr.ird.t3.entities.data.TripDAO;
import fr.ird.t3.services.ioc.InjectDAO;
import fr.ird.t3.web.actions.T3ActionSupport;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.decorator.Decorator;

public class ConfirmTripDeleteAction
extends T3ActionSupport {
    protected static final Log log = LogFactory.getLog(ConfirmTripDeleteAction.class);
    private static final long serialVersionUID = 1L;
    @InjectDAO(entityType=Trip.class)
    protected transient TripDAO tripDAO;
    protected List<String> tripIds;
    protected Map<String, String> tripsToDelete;

    public Map<String, String> getTripsToDelete() {
        return this.tripsToDelete;
    }

    public void setTripIds(List<String> tripIds) {
        this.tripIds = tripIds;
    }

    public String input() throws Exception {
        this.injectOnly(new Class[]{InjectDAO.class});
        this.tripsToDelete = Maps.newTreeMap();
        if (CollectionUtils.isNotEmpty((Collection)this.tripIds)) {
            Decorator decorator = this.getDecorator(Trip.class);
            for (String tripId : this.tripIds) {
                Trip aTrip = (Trip)this.tripDAO.findByTopiaId(tripId);
                String s = decorator.toString((Object)aTrip);
                this.tripsToDelete.put(tripId, s);
            }
        }
        return "input";
    }

    public String doDelete() throws Exception {
        return this.startDeleteData(true);
    }

    public String doDeleteComputedData() throws Exception {
        return this.startDeleteData(false);
    }

    protected String startDeleteData(boolean deleteTrips) {
        List ids = this.tripIds;
        DeleteTripConfiguration conf = new DeleteTripConfiguration();
        conf.setTripIds((Collection)ids);
        conf.setDeleteTrip(deleteTrips);
        T3ActionContext context = this.getServiceFactory().newT3ActionContext((T3ActionConfiguration)conf, this.getServiceContext());
        this.getT3Session().setActionContext(context);
        return "success";
    }
}

