/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table.impl.longline;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveTechnicalException;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.longline.GearUseFeaturesLongline;
import fr.ird.observe.entities.longline.GearUseFeaturesMeasurementLongline;
import fr.ird.observe.entities.longline.GearUseFeaturesMeasurementLonglineDAO;
import fr.ird.observe.entities.longline.TripLongline;
import fr.ird.observe.entities.referentiel.Gear;
import fr.ird.observe.entities.referentiel.GearCaracteristic;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIInitializer;
import fr.ird.observe.ui.content.table.ContentTableUIHandler;
import fr.ird.observe.ui.content.table.impl.longline.GearUseFeaturesLonglineTableModel;
import fr.ird.observe.ui.content.table.impl.longline.GearUseFeaturesLonglineUI;
import fr.ird.observe.ui.content.table.impl.longline.GearUseFeaturesLonglineUIModel;
import fr.ird.observe.ui.content.table.impl.longline.GearUseFeaturesMeasurementLonglinesTableModel;
import fr.ird.observe.ui.content.table.impl.seine.GearUseFeatureMeasurementCellEditor;
import fr.ird.observe.ui.content.table.impl.seine.GearUseFeatureMeasurementCellRenderer;
import fr.ird.observe.ui.util.table.AutotSelectRowAndShowPopupActionSupport;
import fr.ird.observe.ui.util.table.EditableTableModelSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public class GearUseFeaturesLonglineUIHandler
extends ContentTableUIHandler<TripLongline, GearUseFeaturesLongline> {
    private static Log log = LogFactory.getLog(GearUseFeaturesLonglineUIHandler.class);
    protected final TableModelListener computeTabValidStateListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            SwingValidatorMessageTableModel source = (SwingValidatorMessageTableModel)e.getSource();
            GearUseFeaturesLonglineUIHandler.this.computeTabValidState(source);
        }
    };
    private final PropertyChangeListener measurementsTableModelModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GearUseFeaturesLonglineUIHandler.this.onMeasurementsTableModelModified((Boolean)evt.getNewValue());
        }
    };

    public GearUseFeaturesLonglineUIHandler(GearUseFeaturesLonglineUI ui) {
        super(ui, DataContextType.TripLongline);
    }

    @Override
    public GearUseFeaturesLonglineUI getUi() {
        return (GearUseFeaturesLonglineUI)super.getUi();
    }

    @Override
    public GearUseFeaturesLonglineUIModel getModel() {
        return (GearUseFeaturesLonglineUIModel)super.getModel();
    }

    @Override
    protected void onSelectedRowChanged(int editingRow, GearUseFeaturesLongline bean, boolean create) {
        BeanComboBox<Gear> requestFocus;
        List measurements;
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected row changed: " + editingRow + ", create? " + create));
        }
        GearUseFeaturesLonglineUI ui = this.getUi();
        UIHelper.stopEditing(ui.getMeasurementsTable());
        GearUseFeaturesLonglineTableModel tableModel = this.getTableModel();
        GearUseFeaturesLonglineUIModel model = this.getModel();
        boolean emptySelection = editingRow == -1;
        GearUseFeaturesMeasurementLonglinesTableModel measurementsTableModel = model.getMeasurementsTableModel();
        List list = measurements = emptySelection ? Collections.emptyList() : measurementsTableModel.getCacheForRow(editingRow);
        if (measurements == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("init measurements for row " + editingRow));
            }
            if (tableModel.isCreate()) {
                measurements = Collections.emptyList();
                if (log.isInfoEnabled()) {
                    log.info((Object)"create mode, use an empty list");
                }
            } else {
                try {
                    measurements = this.getDataService().getGearUseFeaturesMeasurementLongline(this.getDataSource(), bean, measurementsTableModel.getLoader());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Loaded measurements (" + bean.getTopiaId() + "): " + measurements.size()));
                    }
                }
                catch (DataSourceException e) {
                    throw new ObserveTechnicalException("Could not load measurements", (Throwable)e);
                }
            }
            measurementsTableModel.initCacheForRow(editingRow, measurements);
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Using existing measurements for row " + editingRow + " : " + measurements.size()));
        }
        measurementsTableModel.setData(measurements);
        measurementsTableModel.setModified(false);
        measurementsTableModel.setEditable(tableModel.isEditable());
        if (!tableModel.isEditable()) {
            return;
        }
        if (tableModel.isCreate()) {
            ui.getGearUseFeaturesTabPane().setSelectedIndex(0);
            requestFocus = ui.getGear();
        } else {
            requestFocus = ui.getGear();
        }
        requestFocus.requestFocus();
    }

    @Override
    protected void initTableUI(DefaultTableCellRenderer renderer) {
        List list;
        JTable table = this.getUi().getTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.gearUseFeaturesLongline.table.gear", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.gear.tip", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.number", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.number.tip", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.usedInTrip", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.usedInTrip.tip", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.comment", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.comment.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, Gear.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)UIHelper.newEmptyNumberTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)2, (TableCellRenderer)UIHelper.newBooleanTableCellRenderer((TableCellRenderer)renderer));
        UIHelper.setTableColumnRenderer((JTable)table, (int)3, (TableCellRenderer)UIHelper.newStringTableCellRenderer((DefaultTableCellRenderer)renderer, (int)10, (boolean)true));
        table = this.getUi().getMeasurementsTable();
        UIHelper.setI18nTableHeaderRenderer((JTable)table, (String[])new String[]{I18n.n((String)"observe.gearUseFeaturesLongline.table.gearCaracteristic", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.gearCaracteristic.tip", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.value", (Object[])new Object[0]), I18n.n((String)"observe.gearUseFeaturesLongline.table.value.tip", (Object[])new Object[0])});
        UIHelper.setTableColumnRenderer((JTable)table, (int)0, (TableCellRenderer)UIHelper.newDecorateTableCellRenderer(renderer, GearCaracteristic.class));
        UIHelper.setTableColumnRenderer((JTable)table, (int)1, (TableCellRenderer)new GearUseFeatureMeasurementCellRenderer(0, renderer));
        table.getTableHeader().setReorderingAllowed(false);
        Decorator decorator = ObserveContext.get().getDecorator(GearCaracteristic.class);
        try {
            list = this.getDataService().getList(this.getDataSource(), GearCaracteristic.class);
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Could not get gear caracteristics", (Throwable)e);
        }
        UIHelper.setTableColumnEditor((JTable)table, (int)0, (TableCellEditor)ContentUIInitializer.newDataColumnEditor(list, decorator));
        UIHelper.setTableColumnEditor((JTable)table, (int)1, (TableCellEditor)new GearUseFeatureMeasurementCellEditor(0));
        GearUseFeaturesMeasurementLonglinesTableModel tableModel = this.getModel().getMeasurementsTableModel();
        tableModel.installTableKeyListener(this.getUi().getMeasurementsTable());
        tableModel.addPropertyChangeListener("modified", this.measurementsTableModelModified);
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.setSelectionMode(0);
        tableModel.installSelectionListener(table);
        new SectionTemplatesAutotSelectRowAndShowPopupAction(this.getUi(), this.getUi().getMeasurementsScrollPane(), table, this.getUi().getMeasurementsTablePopup());
        this.getUi().getShowForm().remove(1);
        this.getUi().getShowForm().add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.getUi().getEditor()), (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.3, 10, 1, new Insets(0, 0, 0, 0), 0, 0), 1);
        this.getUi().getEditor().remove(0);
        this.getUi().getEditor().add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.getUi().getEditorPanel()), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0), 0);
    }

    @Override
    protected String getEditBeanIdToLoad(DataContext dataContext, DataService dataService, DataSource dataSource) {
        return dataContext.getSelectedTripLonglineId();
    }

    @Override
    public void initUI() throws Exception {
        super.initUI();
        this.getModel().addPropertyChangeListener("editable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newValue = (Boolean)evt.getNewValue();
                GearUseFeaturesLonglineUIHandler.this.setTableModelEditable(newValue);
            }
        });
        this.setTableModelEditable(this.getModel().isEditable());
        this.getTableModel().setGearUseFeaturesLonglineUIHandler(this);
    }

    @Override
    protected TripLongline loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        TripLongline tripLongline = (TripLongline)super.loadEditBean(mode, dataContext, dataService, dataSource);
        this.getModel().getMeasurementsTableModel().clear();
        return tripLongline;
    }

    @Override
    public void openUI() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)("OpenUI: " + (Object)((Object)this.getModel())));
        }
        super.openUI();
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
        this.getUi().getErrorTableModel().addTableModelListener(this.computeTabValidStateListener);
        SwingValidatorMessageTableModel errorTableModel = this.getUi().getErrorTableModel();
        this.computeTabValidState(errorTableModel);
    }

    @Override
    protected void closeSafeUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("CloseUI: " + (Object)((Object)this.getModel())));
        }
        super.closeSafeUI();
        this.getUi().getErrorTableModel().removeTableModelListener(this.computeTabValidStateListener);
    }

    @Override
    public void startEditUI(String ... binding) {
        this.getModel().getMeasurementsTableModel().setEditable(true);
        super.startEditUI(binding);
    }

    public void deleteSelectedMeasurement() {
        GearUseFeaturesMeasurementLonglinesTableModel tableModel = this.getUi().getMeasurementsTableModel();
        boolean selectionEmpty = tableModel.isSelectionEmpty();
        if (!selectionEmpty) {
            GearUseFeaturesMeasurementLongline data = (GearUseFeaturesMeasurementLongline)tableModel.getSelectedRow();
            if (log.isInfoEnabled()) {
                log.info((Object)("Delete: " + data));
            }
            ObserveMainUI mainUI = ObserveContext.get().getObserveMainUI();
            int response = UIHelper.askUser(mainUI, I18n.t((String)"observe.title.delete", (Object[])new Object[0]), I18n.t((String)"observe.measurement.delete.message", (Object[])new Object[0]), 2, new Object[]{I18n.t((String)"observe.choice.confirm.delete", (Object[])new Object[0]), I18n.t((String)"observe.choice.cancel", (Object[])new Object[0])}, 1);
            if (response != 0) {
                return;
            }
            tableModel.removeSelectedRow();
        }
    }

    @Override
    protected TripLongline onCreate(TopiaContext tx, Object parentBean, TripLongline editBean) throws TopiaException {
        return super.onCreate(tx, parentBean, editBean);
    }

    @Override
    protected void onUpdateFinalize(TopiaContext tx, TripLongline bean, Collection<GearUseFeaturesLongline> oldChilds) throws TopiaException {
        List gearUseFeatures = bean.getGearUseFeaturesLongline();
        GearUseFeaturesLonglineUIModel model = this.getModel();
        GearUseFeaturesMeasurementLonglineDAO measureDao = ObserveDAOHelper.getGearUseFeaturesMeasurementLonglineDAO((TopiaContext)tx);
        GearUseFeaturesMeasurementLonglinesTableModel measurementsTableModel = model.getMeasurementsTableModel();
        Set<Integer> rowsChanged = measurementsTableModel.getCacheRowsChanged();
        TopiaEntityBinder loader = measurementsTableModel.getLoader();
        for (Integer row : rowsChanged) {
            GearUseFeaturesLongline gearUseFeaturesLongline = (GearUseFeaturesLongline)gearUseFeatures.get(row);
            List measurements = measurementsTableModel.getCacheForRow(row);
            ArrayList<GearUseFeaturesMeasurementLongline> measurementsToSave = new ArrayList<GearUseFeaturesMeasurementLongline>(measurements.size());
            for (GearUseFeaturesMeasurementLongline measure : measurements) {
                GearUseFeaturesMeasurementLongline measureToSave;
                if (!measurementsTableModel.isRowNotEmpty(measure)) continue;
                if (measure.getTopiaId() == null) {
                    measureToSave = (GearUseFeaturesMeasurementLongline)measureDao.create((TopiaEntity)measure);
                    loader.load((TopiaEntity)measureToSave, (TopiaEntity)measure, true, new String[0]);
                } else {
                    measureToSave = gearUseFeaturesLongline.getGearUseFeaturesMeasurementByTopiaId(measure.getTopiaId());
                    loader.load((TopiaEntity)measure, (TopiaEntity)measureToSave, true, new String[0]);
                }
                measurementsToSave.add(measureToSave);
            }
            gearUseFeaturesLongline.clearGearUseFeaturesMeasurement();
            gearUseFeaturesLongline.addAllGearUseFeaturesMeasurement(measurementsToSave);
        }
    }

    @Override
    protected void resetEditBean() {
        UIHelper.stopEditing(this.getUi().getMeasurementsTable());
        super.resetEditBean();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        this.getModel().setShowData(true);
        String selectedTripId = dataContext.getSelectedTripId();
        if (selectedTripId.equals(dataContext.getOpenTripId())) {
            return ContentMode.UPDATE;
        }
        if (dataContext.isSelectedTripLongline()) {
            this.addInfoMessage(I18n.t((String)"observe.tripLongline.message.not.open", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.t((String)"observe.tripLongline.message.not.open", (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    protected GearUseFeaturesLonglineTableModel getTableModel() {
        return (GearUseFeaturesLonglineTableModel)super.getTableModel();
    }

    protected void setTableModelEditable(Boolean newValue) {
        this.getModel().getMeasurementsTableModel().setEditable(newValue);
    }

    protected void onMeasurementsTableModelModified(Boolean newValue) {
        if (newValue.booleanValue()) {
            this.getUi().getValidatorTable().setChanged(true);
        }
        this.getModel().getMeasurementsTableModel().validate();
    }

    protected void computeTabValidState(SwingValidatorMessageTableModel errorTableModel) {
        HashSet<String> errorProperties = new HashSet<String>();
        int rowCount = errorTableModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            SwingValidatorMessage row = errorTableModel.getRow(i);
            if (!NuitonValidatorScope.ERROR.equals((Object)row.getScope())) continue;
            errorProperties.add(row.getField());
        }
        boolean generalTabValid = !errorProperties.removeAll(GearUseFeaturesLonglineUIModel.GENERAL_TAB_PROPERTIES);
        GearUseFeaturesLonglineUIModel model = this.getModel();
        model.setGeneralTabValid(generalTabValid);
    }

    public List<GearUseFeaturesMeasurementLongline> getDefaultGearUseFeaturesMeasurementLongline(String gearId) {
        try {
            List measurements = this.getDataService().getDefaultGearUseFeaturesMeasurementLongline(this.getDataSource(), gearId);
            if (log.isInfoEnabled()) {
                log.info((Object)("Create mode, use default measurements: " + measurements.size()));
            }
            return measurements;
        }
        catch (DataSourceException e) {
            throw new ObserveTechnicalException("Could not create default measurements", (Throwable)e);
        }
    }

    static class SectionTemplatesAutotSelectRowAndShowPopupAction
    extends AutotSelectRowAndShowPopupActionSupport {
        private final GearUseFeaturesLonglineUI ui;

        public SectionTemplatesAutotSelectRowAndShowPopupAction(GearUseFeaturesLonglineUI ui, JScrollPane pane, JTable table, JPopupMenu popup) {
            super(pane, table, popup);
            this.ui = ui;
        }

        @Override
        protected void beforeOpenPopup(int modelRowIndex, int modelColumnIndex) {
            boolean canDelete;
            EditableTableModelSupport model = (EditableTableModelSupport)this.getTable().getModel();
            boolean bl = canDelete = !model.isSelectionEmpty();
            if (canDelete) {
                Object selectedData = model.getSelectedRow();
                canDelete = model.isRowNotEmpty(selectedData);
            }
            this.ui.getDeleteSelectedMeasurement().setEnabled(canDelete);
        }
    }
}

