/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ui.ObserveMainUI;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.tools.Server;
import org.nuiton.i18n.I18n;

public class StartH2WebServerAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(StartH2WebServerAction.class);
    private final ObserveMainUI ui;

    public StartH2WebServerAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.start.h2.web.server", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"db-start-server"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.start.h2.web.server.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 83);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.ui.isH2WebServer().booleanValue()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can not start h2 web server... (web server already found)");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will start h2 web server ...");
            }
            try {
                Server server = Server.createWebServer((String[])new String[]{"-webAllowOthers"});
                server.start();
                Server.openBrowser((String)server.getURL());
                this.ui.setContextValue(server, "webServer");
                this.ui.setH2WebServer(true);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Could not start h2 web server ", (Throwable)e);
                }
                ErrorDialogUI.showError((Exception)e);
            }
        }
    }
}

