/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.table;

import fr.ird.observe.DataService;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.ObserveContentUI;
import fr.ird.observe.ui.content.table.ContentTableModel;
import fr.ird.observe.ui.content.table.ContentTableUIInitializer;
import fr.ird.observe.ui.content.table.ContentTableUIModel;
import fr.ird.observe.ui.content.table.ObserveContentTableUI;
import fr.ird.observe.ui.tree.ObserveNode;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityListUpdator;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.validator.NuitonValidatorScope;

public abstract class ContentTableUIHandler<E extends TopiaEntity, D extends TopiaEntity>
extends ContentUIHandler<E> {
    private static Log log = LogFactory.getLog(ContentTableUIHandler.class);

    protected ContentTableUIHandler(ObserveContentTableUI<E, D> ui, DataContextType dataContextType) {
        super(ui, dataContextType, null);
    }

    protected abstract void onSelectedRowChanged(int var1, D var2, boolean var3);

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        ((ContentTableUIModel)this.getModel()).setShowData(true);
        String activityId = dataContext.getSelectedActivityId();
        if (activityId.equals(dataContext.getOpenActivityId())) {
            return ContentMode.UPDATE;
        }
        this.addInfoMessage(I18n.t((String)"observe.message.activity.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    public ContentTableUIModel<E, D> getModel() {
        return (ContentTableUIModel)super.getModel();
    }

    public ObserveContentTableUI<E, D> getUi() {
        return (ObserveContentTableUI)super.getUi();
    }

    public final D getTableEditBean() {
        return ((ContentTableUIModel)this.getModel()).getTableEditBean();
    }

    public final void updateEditor(ListSelectionEvent event) {
        ObserveContentUI ui = this.getUi();
        if (ui.getValidatorTable() == null) {
            log.debug((Object)"skip validator is null!");
            return;
        }
        if (this.getBean() == null) {
            log.debug((Object)"skip bean is null!");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        if (this.getTableModel().isEmpty()) {
            log.debug((Object)"empty model, do nothing");
            return;
        }
        ListSelectionModel sModel = (ListSelectionModel)event.getSource();
        int newIndex = sModel.getAnchorSelectionIndex();
        if (newIndex == -1 || sModel.isSelectionEmpty()) {
            log.debug((Object)"skip with row == -1, or empty selection, do nothing");
            return;
        }
        SwingUtilities.invokeLater(new Runnable((ObserveContentTableUI)ui){
            final /* synthetic */ ObserveContentTableUI val$ui;
            {
                this.val$ui = observeContentTableUI;
            }

            @Override
            public void run() {
                if (!this.val$ui.getSelectionModel().isSelectionEmpty()) {
                    Rectangle rect = this.val$ui.getTable().getCellRect(this.val$ui.getSelectionModel().getAnchorSelectionIndex(), 0, false);
                    this.val$ui.getTable().scrollRectToVisible(rect);
                }
            }
        });
        int selectedRow = this.getTableModel().getSelectedRow();
        if (newIndex == selectedRow) {
            log.debug((Object)("new index already set in model " + newIndex + ", do nothing"));
            return;
        }
        this.getTableModel().changeSelectedRow(newIndex);
    }

    protected abstract void initTableUI(DefaultTableCellRenderer var1);

    protected abstract String getEditBeanIdToLoad(DataContext var1, DataService var2, DataSource var3) throws DataSourceException;

    protected E loadEditBean(ContentMode mode, DataContext dataContext, DataService dataService, DataSource dataSource) throws DataSourceException {
        String id = this.getEditBeanIdToLoad(dataContext, dataService, dataSource);
        if (id == null) {
            throw new IllegalStateException("Could not find id form " + this);
        }
        Object editBean = this.getBean();
        dataService.loadEditEntity(dataSource, id, this.getLoadExecutor());
        this.getModel().setMode(mode);
        this.getUi().getTableModel().attachModel();
        return editBean;
    }

    @Override
    protected final void onLoad(TopiaContext tx, E bean) throws TopiaException {
        super.onLoad(tx, bean);
        Object editBean = this.getBean();
        Collection<D> data = this.loadChilds(tx, editBean);
        ((ContentTableUIModel)this.getModel()).getChildsUpdator().setChilds(editBean, data);
    }

    protected Collection<D> loadChilds(TopiaContext tx, E bean) throws TopiaException {
        Collection childs = ((ContentTableUIModel)this.getModel()).getChildsUpdator().getChilds(bean);
        ArrayList data = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)childs)) {
            TopiaEntityBinder loader = ((ContentTableUIModel)this.getModel()).getChildLoador();
            TopiaDAO dao = this.getDataSource().getDAO(tx, this.getTableEditBean());
            for (TopiaEntity c : childs) {
                try {
                    TopiaEntity cUp = dao.findByTopiaId(c.getTopiaId());
                    Object c2 = ((ContentTableUIModel)this.getModel()).newTableEditBean();
                    loader.load((Object)cUp, c2, true, new String[0]);
                    data.add(c2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return data;
    }

    @Override
    public void initUI() throws Exception {
        ContentTableUIInitializer uiInitializer = new ContentTableUIInitializer(this.getUi());
        uiInitializer.initUI(this.getDataSource());
    }

    @Override
    public void openUI() throws Exception {
        boolean canEdit;
        super.openUI();
        ContentMode mode = this.computeContentMode();
        ObserveContentUI ui = this.getUi();
        int oldIndex = ui.getTableModel().getSelectedRow();
        ui.getTableModel().dettachModel();
        this.loadEditBean(mode, this.getDataContext(), this.getDataService(), this.getDataSource());
        boolean bl = canEdit = mode == ContentMode.UPDATE;
        if (canEdit) {
            ui.startEdit(null);
        }
        if (!ui.getTableModel().isEmpty()) {
            if (ui.getTableModel().getRowCount() <= oldIndex) {
                oldIndex = 0;
            }
            if (oldIndex == -1) {
                oldIndex = 0;
            }
            ui.getTableModel().changeSelectedRow(oldIndex);
        }
        if (canEdit) {
            this.getModel().setModified(false);
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        String message = I18n.n((String)"observe.message.updating.entity", (Object[])new Object[0]);
        ObserveNode node = (ObserveNode)ContentTableUIHandler.getTreeHelper((JAXXContext)this.getUi()).getSelectedNode();
        String entityLabel = this.getEntityLabel(((ObserveNode)node.getParent()).getInternalClass());
        message = I18n.t((String)message, (Object[])new Object[]{I18n.t((String)entityLabel, (Object[])new Object[0])});
        ContentTableUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, entityLabel, message);
        super.startEditUI(binding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedRow(int selectedRow) {
        try {
            this.getTableModel().doRemoveRow(selectedRow, false);
        }
        finally {
            ObserveContext.get().getObserveMainUI().setBusy(false);
        }
    }

    @Override
    protected boolean doSave(E bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<E> binder) throws Exception {
        boolean canContinue;
        ObserveContentUI ui = this.getUi();
        List objets = ui.getTableModel().getData();
        try {
            canContinue = this.prepareSave(bean, objets);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)e);
            }
            ErrorDialogUI.showError((Exception)e);
            canContinue = false;
        }
        if (!canContinue) {
            return false;
        }
        dataService.update(dataSource, null, bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected E onUpdate(TopiaContext tx, Object parentBean, E beanToSave) throws TopiaException {
        List childs = this.getUi().getTableModel().getData();
        Object editBean = this.getBean();
        TopiaEntityBinder binder = this.getLoadBinder();
        TopiaEntityBinder childBinder = ((ContentTableUIModel)this.getModel()).getChildLoador();
        EntityListUpdator childUpdator = ((ContentTableUIModel)this.getModel()).getChildsUpdator();
        binder.copyExcluding(editBean, beanToSave, new String[]{childUpdator.getPropertyName()});
        ArrayList oldChilds = new ArrayList(childUpdator.getChilds(beanToSave));
        childUpdator.removeAll(beanToSave);
        TopiaDAO dao = ObserveDAOHelper.getDAO((TopiaContext)tx, ((ContentTableUIModel)this.getModel()).getChildType());
        for (TopiaEntity child : childs) {
            TopiaEntity childToSave;
            if (child.getTopiaId() == null) {
                Map map = childBinder.obtainProperties((Object)child, new String[0]);
                childToSave = dao.create(map);
            } else {
                childToSave = dao.findByTopiaId(child.getTopiaId());
                childBinder.load((Object)child, (Object)childToSave, false, new String[0]);
            }
            childUpdator.addToList(beanToSave, childToSave);
        }
        this.onUpdateFinalize(tx, beanToSave, oldChilds);
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        this.resetEditUI();
    }

    protected boolean prepareSave(E editBean, List<D> objets) throws Exception {
        return true;
    }

    protected void onUpdateFinalize(TopiaContext tx, E bean, Collection<D> oldChilds) {
    }

    protected ContentTableModel<E, D> getTableModel() {
        return this.getUi().getTableModel();
    }
}

