/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.actions.AbstractUIAction;
import fr.ird.observe.ui.content.ContentUI;
import fr.ird.observe.ui.content.list.ContentListUI;
import fr.ird.observe.ui.content.open.ContentOpenableUI;
import fr.ird.observe.ui.tree.ObserveNode;
import fr.ird.observe.ui.tree.ObserveTreeHelper;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import jaxx.runtime.swing.nav.NavNode;
import org.nuiton.i18n.I18n;

public class ReOpenUIAction
extends AbstractUIAction {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_NAME = "reopen";

    public ReOpenUIAction(ObserveMainUI mainUI) {
        super(mainUI, ACTION_NAME, I18n.n((String)"observe.action.reopen", (Object[])new Object[0]), I18n.n((String)"observe.action.reopen.tip", (Object[])new Object[0]), ACTION_NAME);
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContentOpenableUI openUI;
                JComponent c = (JComponent)e.getSource();
                ContentUI ui = (ContentUI)((Object)c.getClientProperty("ui"));
                if (ui == null) {
                    throw new IllegalStateException("could not find client property ui on component" + c);
                }
                if (ui instanceof ContentOpenableUI) {
                    openUI = (ContentOpenableUI)ui;
                } else if (ui instanceof ContentListUI) {
                    Object selectedData = ((ContentListUI)ui).getSelectedData();
                    String id = selectedData.getTopiaId();
                    ObserveTreeHelper treeHelper = ui.getTreeHelper();
                    ObserveNode selectedNode = (ObserveNode)treeHelper.getSelectedNode();
                    ObserveNode node = (ObserveNode)treeHelper.findNode((NavNode)selectedNode, new String[]{id});
                    treeHelper.selectNode((NavNode)node);
                    openUI = (ContentOpenableUI)ObserveContext.get().getSelectedContentUI();
                } else {
                    throw new IllegalStateException("The action reopen can not be executed from ui " + (Object)((Object)ui));
                }
                if (openUI != null) {
                    openUI.openData();
                }
            }
        });
    }
}

