/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.actions;

import fr.ird.observe.ObserveContext;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CloseStorageAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CloseStorageAction.class);
    private final ObserveMainUI ui;

    public CloseStorageAction(ObserveMainUI ui) {
        super(I18n.t((String)"observe.action.close.storage", (Object[])new Object[0]), SwingUtil.getUIManagerActionIcon((String)"db-none"));
        this.ui = ui;
        this.putValue("ShortDescription", I18n.t((String)"observe.action.close.storage.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", 70);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean canContinue = ObserveContext.get().closeSelectedContentUI(this.ui);
        if (canContinue) {
            this.ui.setBusy(true);
            try {
                DataSource storage = ObserveMainUIHandler.getStorage();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(">>> close main storage " + storage));
                }
                storage.doClose(false);
            }
            catch (DataSourceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
                if (log.isErrorEnabled()) {
                    log.error((Object)ex);
                }
            }
            finally {
                this.ui.setBusy(false);
            }
        }
    }
}

