/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.list.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Route;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.list.ContentListUIHandler;
import fr.ird.observe.ui.content.list.impl.ActivitesUI;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

public class ActivitesUIHandler
extends ContentListUIHandler<Route, Activite> {
    private static Log log = LogFactory.getLog(ActivitesUIHandler.class);

    public ActivitesUIHandler(ActivitesUI ui) {
        super(ui, DataContextType.Route, DataContextType.Activite);
    }

    @Override
    protected TopiaEntityBinder<Route> createOpeningBinder(BinderService binderService) {
        String binderName = this.getClass().getName() + "-open";
        TopiaEntityBinder r = binderService.getTopiaBinder(Route.class, binderName);
        if (r == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(Route.class, new String[]{"open", "activite"});
            builder.addCollectionStrategy(Binder.CollectionStrategy.duplicate, new String[]{"activite"});
            BinderModelBuilder builder2 = binderService.newBinderBuilder(Activite.class, new String[]{"activiteBateau", "heureObservation", "open"});
            TopiaEntityBinder binder = binderService.registerTopiaBinder(Activite.class, builder2, binderName);
            builder.addBinder("activite", (Binder)binder);
            r = binderService.registerTopiaBinder(Route.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        String openRouteId = dataContext.getOpenRouteId();
        if (openRouteId == null) {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.route.found", (Object[])new Object[0]));
            return ContentMode.READ;
        }
        boolean openActivite = dataContext.isOpenActivite();
        if (dataContext.isSelectedOpen(Route.class)) {
            if (openActivite) {
                this.addInfoMessage(I18n.n_((String)"observe.message.active.activite.found", (Object[])new Object[0]));
                return ContentMode.UPDATE;
            }
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.activite.found", (Object[])new Object[0]));
            return ContentMode.CREATE;
        }
        if (openActivite) {
            this.addInfoMessage(I18n.n_((String)"observe.message.active.activite.found.for.other.route", (Object[])new Object[0]));
        } else {
            this.addInfoMessage(I18n.n_((String)"observe.message.no.active.activite.found.for.other.route", (Object[])new Object[0]));
        }
        return ContentMode.READ;
    }

    @Override
    protected List<Activite> getChilds(Route bean) {
        List list = bean.getActivite();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will use " + (list == null ? 0 : list.size()) + " activites."));
        }
        return list;
    }
}

