/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.impl;

import fr.ird.observe.BinderService;
import fr.ird.observe.DecoratorService;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.db.DataContext;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.constants.DataContextType;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.BaliseLue;
import fr.ird.observe.entities.BaliseLueDAO;
import fr.ird.observe.entities.BaliseLueImpl;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.constants.AppartenanceEnum;
import fr.ird.observe.entities.constants.TypeOperationBaliseEnum;
import fr.ird.observe.entities.referentiel.OperationBalise;
import fr.ird.observe.entities.referentiel.TypeBalise;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ContentMode;
import fr.ird.observe.ui.content.ContentUIHandler;
import fr.ird.observe.ui.content.impl.OperationBaliseUI;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.util.beans.BinderModelBuilder;
import org.nuiton.util.decorator.Decorator;
import org.nuiton.validator.NuitonValidatorScope;

public class OperationBaliseUIHandler
extends ContentUIHandler<ObjetFlottant> {
    private static Log log = LogFactory.getLog(OperationBaliseUIHandler.class);
    protected TopiaEntityBinder<BaliseLue> childLoador;

    public OperationBaliseUIHandler(OperationBaliseUI ui) {
        super(ui, DataContextType.ObjetFlottant, null);
    }

    public OperationBaliseUI getUi() {
        return (OperationBaliseUI)super.getUi();
    }

    @Override
    protected boolean computeCanWrite(DataSource source) {
        return source.canWriteData();
    }

    @Override
    protected TopiaEntityBinder<ObjetFlottant> createOpeningBinder(BinderService binderService) {
        TopiaEntityBinder r;
        String binderName = this.getClass().getName() + "-open";
        this.childLoador = binderService.getTopiaBinder(BaliseLue.class, binderName);
        if (this.childLoador == null) {
            BinderModelBuilder builder2 = binderService.newBinderBuilder(BaliseLue.class, new String[]{"code", "appartenance", "typeBalise", "operationBalise", "marque"});
            this.childLoador = binderService.registerTopiaBinder(BaliseLue.class, builder2, binderName);
            this.childLoador.setEmpty((TopiaEntity)new BaliseLueImpl());
        }
        if ((r = binderService.getTopiaBinder(ObjetFlottant.class, binderName)) == null) {
            BinderModelBuilder builder = binderService.newBinderBuilder(ObjetFlottant.class, new String[]{"commentaire", "operation"});
            r = binderService.registerTopiaBinder(ObjetFlottant.class, builder, binderName);
        }
        return r;
    }

    @Override
    protected ContentMode getContentMode(DataContext dataContext) {
        if (dataContext.isSelectedOpen(Activite.class)) {
            return ContentMode.UPDATE;
        }
        OperationBaliseUIHandler.addMessage(this.getUi(), NuitonValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open", (Object[])new Object[0]));
        return ContentMode.READ;
    }

    @Override
    public void openUI() throws Exception {
        super.openUI();
        ContentMode mode = this.computeContentMode();
        String dcpId = this.getSelectedParentId();
        if (log.isInfoEnabled()) {
            log.info((Object)("dcpId = " + dcpId));
        }
        ObjetFlottant bean = (ObjetFlottant)this.getBean();
        bean.clearBaliseLue();
        this.getModel().setEditing(false);
        this.getDataService().loadEditEntity(this.getDataSource(), dcpId, this.getLoadExecutor());
        this.getUi().processDataBinding("typeOperation.selectedIndex");
        TypeOperationBaliseEnum typeOperation = (TypeOperationBaliseEnum)this.getUi().getTypeOperation().getSelectedItem();
        this.changeTypeOperation(typeOperation, false);
        this.getModel().setMode(mode);
        if (mode == ContentMode.UPDATE) {
            this.getUi().startEdit(null);
        }
    }

    @Override
    protected void onLoad(TopiaContext tx, ObjetFlottant bean) throws TopiaException {
        ObjetFlottant editBean = (ObjetFlottant)this.getBean();
        this.getLoadBinder().load((TopiaEntity)bean, (TopiaEntity)editBean, true, new String[0]);
        editBean.clearBaliseLue();
        List objets = bean.getBaliseLue();
        if (objets != null) {
            DecoratorService decoratorService = this.getDecoratorService();
            Decorator dB = decoratorService.getDecoratorByType(BaliseLue.class);
            Decorator dB2 = decoratorService.getDecoratorByType(OperationBalise.class);
            Decorator dB3 = decoratorService.getDecoratorByType(TypeBalise.class);
            for (BaliseLue baliseLue : objets) {
                TypeBalise typeBalise;
                OperationBalise operationBalise;
                String s = dB.toString((Object)baliseLue);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("use balise lue : " + s));
                }
                if ((operationBalise = baliseLue.getOperationBalise()) != null) {
                    s = dB2.toString((Object)operationBalise);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("use operation balise : " + s));
                    }
                }
                if ((typeBalise = baliseLue.getTypeBalise()) != null) {
                    s = dB3.toString((Object)typeBalise);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("use type balise : " + s));
                    }
                }
                editBean.addBaliseLue(baliseLue);
            }
        }
    }

    @Override
    public void startEditUI(String ... binding) {
        super.startEditUI("operationBalise1.selectedItem", "operationBalise2.selectedItem", "code1.text", "code2.text", "appartenance1.selectedIndex", "appartenance2.selectedIndex", "typeBalise1.selectedItem", "typeBalise2.selectedItem", "marque1.text", "marque2.text", "typeOperation.selectedIndex");
        OperationBaliseUI ui = this.getUi();
        this.addInfoMessage(I18n._((String)"observe.message.updating.objetFlottant", (Object[])new Object[0]));
        List balises = ((ObjetFlottant)this.getBean()).getBaliseLue();
        if (balises != null && !balises.isEmpty()) {
            BaliseLue baliseLue1 = ui.getBaliseLue1();
            ui.getValidatorBalise1().setBean((Object)baliseLue1);
            if (balises.size() == 2) {
                BaliseLue baliseLue2 = ui.getBaliseLue2();
                ui.getValidatorBalise2().setBean((Object)baliseLue2);
            }
        }
        UIHelper.processDataBinding((JAXXObject)ui, (String[])new String[]{"operationBalise1.selectedItem", "operationBalise2.selectedItem", "code1.text", "code2.text", "appartenance1.selectedIndex", "appartenance2.selectedIndex", "marque1.text", "marque2.text", "typeBalise1.selectedItem", "typeBalise2.selectedItem"});
        this.getModel().setModified(false);
    }

    public boolean isBalisePose(OperationBalise operation) {
        return operation != null && 3 == operation.getCode();
    }

    @Override
    protected boolean doSave(ObjetFlottant bean, DataService dataService, DataSource dataSource, TopiaEntityBinder<ObjetFlottant> binder) throws Exception {
        dataService.update(dataSource, null, (TopiaEntity)bean, this.getUpdateExecutor());
        return true;
    }

    @Override
    protected ObjetFlottant onUpdate(TopiaContext tx, Object parentBean, ObjetFlottant beanToSave) throws TopiaException {
        ObjetFlottant editBean = (ObjetFlottant)this.getBean();
        List objets = editBean.getBaliseLue();
        beanToSave.setCommentaire(editBean.getCommentaire());
        beanToSave.clearBaliseLue();
        BaliseLueDAO baliseLueDAO = ObserveDAOHelper.getBaliseLueDAO((TopiaContext)tx);
        for (BaliseLue baliseLue : objets) {
            BaliseLue newBalise;
            if (baliseLue.getTopiaId() == null) {
                Map map = this.childLoador.obtainProperties((Object)baliseLue, new String[0]);
                newBalise = (BaliseLue)baliseLueDAO.create(map);
            } else {
                newBalise = (BaliseLue)baliseLueDAO.findByTopiaId(baliseLue.getTopiaId());
                this.childLoador.load((TopiaEntity)baliseLue, (TopiaEntity)newBalise, false, new String[0]);
            }
            beanToSave.addBaliseLue(newBalise);
        }
        return beanToSave;
    }

    @Override
    protected void afterSave(boolean refresh) {
        this.resetEditUI();
    }

    protected void changeTypeOperation(TypeOperationBaliseEnum typeOperation, boolean reset) {
        OperationBaliseUI ui = this.getUi();
        if (log.isInfoEnabled()) {
            log.info((Object)(typeOperation + " doReset ? " + reset));
        }
        int nbBalises = typeOperation.getNbBalises();
        ObjetFlottant bean = (ObjetFlottant)this.getBean();
        boolean hasBalise = !bean.isBaliseLueEmpty();
        ArrayList objets = new ArrayList();
        if (!reset && hasBalise) {
            objets.addAll(bean.getBaliseLue());
        }
        if (hasBalise) {
            bean.getBaliseLue().clear();
        }
        JPanel editorPanel = ui.getBaliseLues();
        editorPanel.removeAll();
        int[] codeOperations = typeOperation.getCodeOperation();
        List operations = ui.getOperationBalise1().getData();
        switch (nbBalises) {
            case 0: {
                editorPanel.setLayout(new GridLayout());
                editorPanel.add(ui.getNoBaliseEditor());
                if (!this.getModel().isEditing()) break;
                ui.getValidatorBalise1().setBean(null);
                ui.getValidatorBalise2().setBean(null);
                break;
            }
            case 1: {
                BaliseLue baliseLue = reset ? null : (BaliseLue)objets.get(0);
                OperationBalise operation = reset ? this.getOperation(operations, codeOperations[0]) : null;
                this.bindEditBalise(ui.getBaliseLue1(), operation, baliseLue);
                editorPanel.setLayout(new GridLayout(1, 0));
                editorPanel.add((Component)ui.getBaliseLue1Editor());
                if (!this.getModel().isEditing()) break;
                ui.getValidatorBalise1().setBean((Object)ui.getBaliseLue1());
                ui.getValidatorBalise2().setBean(null);
                break;
            }
            case 2: {
                BaliseLue baliseLue = reset ? null : (BaliseLue)objets.get(0);
                OperationBalise operation = reset ? this.getOperation(operations, codeOperations[0]) : null;
                this.bindEditBalise(ui.getBaliseLue1(), operation, baliseLue);
                baliseLue = reset ? null : (BaliseLue)objets.get(1);
                operation = reset ? this.getOperation(operations, codeOperations[1]) : null;
                this.bindEditBalise(ui.getBaliseLue2(), operation, baliseLue);
                editorPanel.setLayout(new GridLayout(2, 0));
                editorPanel.add((Component)ui.getBaliseLue1Editor());
                editorPanel.add((Component)ui.getBaliseLue2Editor());
                if (!this.getModel().isEditing()) break;
                ui.getValidatorBalise1().setBean((Object)ui.getBaliseLue1());
                ui.getValidatorBalise2().setBean((Object)ui.getBaliseLue2());
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OperationBaliseUIHandler.this.getUi().revalidate();
            }
        });
    }

    protected void bindEditBalise(BaliseLue editBean, OperationBalise operation, BaliseLue baliseLue) {
        ObjetFlottant bean;
        this.childLoador.load((TopiaEntity)baliseLue, (TopiaEntity)editBean, false, new String[0]);
        if (baliseLue == null) {
            editBean.setOperationBalise(operation);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reuse an empty balise lue for operation " + operation.getLibelle1()));
            }
            if (this.isBalisePose(operation)) {
                editBean.setAppartenance(AppartenanceEnum.ceBateau.ordinal());
            }
        }
        if ((bean = (ObjetFlottant)this.getBean()).getBaliseLue() == null) {
            bean.setBaliseLue(new ArrayList());
        }
        bean.getBaliseLue().add(editBean);
    }

    protected OperationBalise getOperation(List<OperationBalise> operations, int codeOperation) {
        OperationBalise operation = null;
        for (OperationBalise op : operations) {
            if (codeOperation != op.getCode()) continue;
            operation = op;
            break;
        }
        if (operation == null) {
            throw new IllegalArgumentException("could not find a " + OperationBalise.class + " with code " + codeOperation);
        }
        return operation;
    }
}

