/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.ref;

import fr.ird.observe.DBHelper;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.referentiel.ReferentielEntity;
import fr.ird.observe.ui.content.ref.ContentReferentielUI;
import fr.ird.observe.ui.content.ref.ContentReferentielUIHandler;
import java.util.EnumMap;
import java.util.EnumSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentReferentielUIHandlerFactory {
    private static final Log log = LogFactory.getLog(ContentReferentielUIHandlerFactory.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static EnumMap<ObserveDAOHelper.ObserveEntityEnum, HandlerDefinition<?>> mapping;

    public static <E extends ReferentielEntity> ContentReferentielUIHandler<E> newHandler(ContentReferentielUI<E> ui) {
        ObserveDAOHelper.ObserveEntityEnum constant;
        HandlerDefinition<E> definition;
        Class type = ui.getModel().getBeanType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("recherche handler pour " + type));
        }
        if ((definition = ContentReferentielUIHandlerFactory.getDefinition(constant = ObserveDAOHelper.ObserveEntityEnum.valueOf(type))) == null) {
            throw new IllegalStateException("Aucune d\u00e9finition pour l'objet " + constant);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("create handler for " + type));
        }
        ContentReferentielUIHandler<E> result = definition.toHandler(ui);
        return result;
    }

    protected static <E extends ReferentielEntity> HandlerDefinition<E> getDefinition(ObserveDAOHelper.ObserveEntityEnum constant) {
        HandlerDefinition<?> definition = ContentReferentielUIHandlerFactory.getMapping().get(constant);
        return definition;
    }

    protected static void loadMapping() {
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.ActiviteBateau);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.ActiviteEnvironnante);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.CauseCoupNul);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.CauseNonCoupSenne);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.DevenirFaune);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.DevenirObjet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.GroupeEspeceFaune);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.ModeDetection);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.Ocean);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.OperationBalise);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.OperationObjet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.RaisonRejet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.StatutEspece);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.SystemeObserve);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.TypeBalise);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.TypeBateau);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.TypeObjet);
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.Bateau, new String[]{"pecherie", "jauge", "pavillon", "codeQuille", "codeFlotte", "anneeService", "longueurHorsToute", "capaciteTransport", "puissanceGroupePrincipal", "vitesseMaximaleProcespection", "dateChargement"}, "pecherie.selectedItem", "jauge.selectedItem", "pavillon.selectedItem", "codeQuille.model", "codeFlotte.model", "anneeService.model", "longueurHorsToute.model", "capaciteTransport.model", "puissanceGroupePrincipal.model", "vitesseMaximaleProcespection.model", "dateChargement.date");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.CategorieBateau, new String[]{"libelleJauge", "libelleCapacite"}, "libelleCapacite.text", "libelleJauge.text");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.CategoriePoids, new String[]{"espece"}, new String[]{"code", "espece"}, new String[]{"espece.selectedItem"});
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.EspeceFaune, new String[]{"code3L", "codeFAO", "wormsId", "libelleScientifique", "groupe"}, "code3L.text", "codeFAO.text", "wormsId.text", "libelleScientifique.text", "groupe.selectedItem");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.EspeceThon, new String[]{"wormsId", "code3L", "codeFAO", "libelleScientifique"}, "code3L.text", "codeFAO.text", "wormsId.text", "libelleScientifique.text");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.Observateur, new String[]{"identifiant", "nom", "prenom"}, new String[]{"identifiant"}, new String[]{"identifiant.text", "nom.text", "prenom.text"});
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.Organisme, new String[]{"pays", "description"}, "pays.selectedItem", "description.text");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.ParametrageTaillePoidsFaune, new String[]{"debutValidite", "finValidite", "sexe", "ocean", "espece", "coefficients", "relation"}, new String[]{"sexe", "ocean", "espece"}, new String[]{"debutValidite.date", "finValidite.date", "espece.selectedItem", "sexe.selectedIndex", "ocean.selectedItem", "coefficients.text", "relation.text"});
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.Pays, new String[]{"codeIso2", "codeIso3"}, "codeIso2.text", "codeIso3.text");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.Programme, new String[]{"organisme", "dateDebutProgramme", "dateFinProgramme", "observationActivitesDetaillees", "observationFauneAssociee", "observationGleure", "observationMammiferes", "observationMensurations", "observationObjetFlottant", "observationOiseaux", "observationRejetsThons"}, "organisme.selectedItem", "dateDebutProgramme.date", "dateFinProgramme.date", "observationActivitesDetaillees.selectedIndex", "observationFauneAssociee.selectedIndex", "observationGleure.selectedIndex", "observationMammiferes.selectedIndex", "observationMensurations.selectedIndex", "observationObjetFlottant.selectedIndex", "observationOiseaux.selectedIndex", "observationRejetsThons.selectedIndex");
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.Senne, new String[]{"identifiant", "longueur", "chute", "poidsLest"}, new String[]{"identifiant"}, new String[]{"identifiant.text", "longueur.model", "chute.model", "poidsLest.model"});
        ContentReferentielUIHandlerFactory.registerMapping(ObserveDAOHelper.ObserveEntityEnum.VentBeaufort, new String[]{"libelleDescriptifVent", "libelleVitesseVent", "libelleDescriptifMer", "libelleHauteurMoyenneVagues"}, "libelleDescriptifVent.text", "libelleVitesseVent.text", "libelleDescriptifMer.text", "libelleHauteurMoyenneVagues.text");
        if (log.isInfoEnabled()) {
            log.info((Object)(mapping.size() + " d\u00e9finitions de r\u00e9f\u00e9rentiel enregistr\u00e9es."));
        }
        if (mapping.size() != DBHelper.REFERENTIEL_ENTITIES_LIST.size()) {
            EnumSet missing = EnumSet.copyOf(DBHelper.REFERENTIEL_ENTITIES_LIST);
            missing.removeAll(mapping.keySet());
            throw new IllegalStateException("Un des \u00e9crans du r\u00e9f\u00e9rentiel n'est pas d\u00e9fini : " + missing);
        }
    }

    protected static EnumMap<ObserveDAOHelper.ObserveEntityEnum, HandlerDefinition<?>> getMapping() {
        if (mapping == null) {
            mapping = new EnumMap(ObserveDAOHelper.ObserveEntityEnum.class);
            ContentReferentielUIHandlerFactory.loadMapping();
        }
        return mapping;
    }

    protected static void registerMapping(ObserveDAOHelper.ObserveEntityEnum entityClass) {
        ContentReferentielUIHandlerFactory.registerMapping(entityClass, null, new String[0]);
    }

    protected static void registerMapping(ObserveDAOHelper.ObserveEntityEnum entityClass, String[] extraProperties, String ... extraDataBindings) {
        ContentReferentielUIHandlerFactory.registerMapping(entityClass, extraProperties, null, extraDataBindings);
    }

    protected static void registerMapping(ObserveDAOHelper.ObserveEntityEnum entityClass, String[] extraProperties, String[] naturalIds, String ... extraDataBindings) {
        HandlerDefinition ref = new HandlerDefinition(entityClass.getContract(), naturalIds, extraProperties, extraDataBindings);
        mapping.put(entityClass, ref);
    }

    protected static class HandlerDefinition<E extends ReferentielEntity> {
        protected Class<E> entityClass;
        protected String[] extraProperties;
        protected String[] naturalIds;
        protected String[] extraDataBindings;

        public HandlerDefinition(Class<E> entityClass, String[] naturalIds, String[] extraProperties, String[] extraDataBindings) {
            this.entityClass = entityClass;
            this.naturalIds = naturalIds;
            this.extraProperties = extraProperties == null ? EMPTY_STRING_ARRAY : extraProperties;
            this.extraDataBindings = extraDataBindings == null ? EMPTY_STRING_ARRAY : extraDataBindings;
        }

        public Class<E> getEntityClass() {
            return this.entityClass;
        }

        public String[] getExtraProperties() {
            return this.extraProperties;
        }

        public String[] getNaturalIds() {
            return this.naturalIds;
        }

        public String[] getExtraDataBindings() {
            return this.extraDataBindings;
        }

        public ContentReferentielUIHandler<E> toHandler(ContentReferentielUI<E> ui) {
            ContentReferentielUIHandler<E> result = new ContentReferentielUIHandler<E>(ui, this.getExtraProperties(), this.getNaturalIds(), this.getExtraDataBindings());
            return result;
        }
    }
}

