/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.admin;

import fr.ird.observe.IObserveConfig;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.ObserveResourceManager;
import fr.ird.observe.ObserveServiceHelper;
import fr.ird.observe.db.DataService;
import fr.ird.observe.db.DataSource;
import fr.ird.observe.db.DataSourceException;
import fr.ird.observe.db.constants.DbMode;
import fr.ird.observe.db.model.DataSelectionModel;
import fr.ird.observe.ui.admin.AdminActionModel;
import fr.ird.observe.ui.admin.AdminStep;
import fr.ird.observe.ui.admin.AdminUI;
import fr.ird.observe.ui.admin.export.ExportModel;
import fr.ird.observe.ui.admin.gps.ImportGPSModel;
import fr.ird.observe.ui.admin.report.ReportModel;
import fr.ird.observe.ui.admin.report.model.Report;
import fr.ird.observe.ui.admin.save.SaveLocalModel;
import fr.ird.observe.ui.admin.synchronize.SynchronizeModel;
import fr.ird.observe.ui.admin.validate.ValidateModel;
import fr.ird.observe.ui.storage.StorageUIHandler;
import fr.ird.observe.ui.storage.StorageUIModel;
import fr.ird.observe.validation.ValidationModelMode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.wizard.WizardStep;
import jaxx.runtime.swing.wizard.ext.WizardExtModel;
import jaxx.runtime.swing.wizard.ext.WizardExtStep;
import jaxx.runtime.swing.wizard.ext.WizardState;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.ValidatorsMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;

public class AdminUIModel
extends WizardExtModel<AdminStep> {
    private static final Log log = LogFactory.getLog(AdminUIModel.class);
    public static final String SHOW_RESUME_PROPERTY_NAME = "showResume";
    public static final String NEED_LOCAL_SOURCE_PROPERTY_NAME = "needLocalSource";
    public static final String SELECTION_MODEL_CHANGED_PROPERTY_NAME = "selectionModelChanged";
    protected DataSource previousSource;
    protected DataSource localSource;
    protected DataSource centralSource;
    protected DataSource tmpSource;
    protected StorageUIModel localSourceModel;
    protected StorageUIModel centralSourceModel;
    protected boolean needLocalSource;
    protected StorageUIHandler storageHandler;
    protected DataService dataService;
    protected ObserveConfig config;
    PropertyChangeListener listenStepChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int newIndex;
            int oldIndex;
            if (AdminUIModel.this.isWasStarted()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Stop propagation, was started... " + evt.getPropertyName()));
                }
                return;
            }
            AdminStep oldStep = (AdminStep)((Object)evt.getOldValue());
            AdminStep newStep = (AdminStep)((Object)evt.getNewValue());
            if (newStep == AdminStep.REPORT && oldStep != null && oldStep.ordinal() < newStep.ordinal() && (oldIndex = AdminUIModel.this.getStepIndex((WizardStep)oldStep)) < (newIndex = AdminUIModel.this.getStepIndex((WizardStep)newStep))) {
                AdminUIModel.this.getReportModel().setSelectedReport(null);
            }
            if (newStep == AdminStep.CONFIG) {
                return;
            }
            if (oldStep != null && oldStep != AdminStep.CONFIG) {
                return;
            }
            DataSelectionModel selectModel = null;
            AdminActionModel model = null;
            switch (newStep) {
                case SELECT_VALIDATE_DATA: {
                    model = AdminUIModel.this.getValidateModel();
                    selectModel = AdminUIModel.this.getValidateModel().getSelectValidateDataModel();
                    break;
                }
                case SELECT_EXPORT_DATA: {
                    model = AdminUIModel.this.getExportModel();
                    selectModel = AdminUIModel.this.getExportModel().getSelectExportModel();
                    AdminUIModel.this.computeExistingMaress(AdminUIModel.this.getSafeCentralSource(true));
                    break;
                }
                case SELECT_REPORT_DATA: {
                    model = AdminUIModel.this.getReportModel();
                    selectModel = AdminUIModel.this.getReportModel().getSelectReportDataModel();
                }
            }
            if (selectModel != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will refill selectionModel [" + (Object)((Object)newStep) + "] : " + selectModel));
                }
                DataSource dataSource = AdminUIModel.this.getSafeLocalSource(true);
                model.populateSelectionModel(selectModel, AdminUIModel.this.dataService, dataSource);
            }
        }
    };
    PropertyChangeListener listenValidationModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ValidateModel source = (ValidateModel)((Object)evt.getSource());
            if (log.isDebugEnabled()) {
                log.debug((Object)("validation model [" + (Object)((Object)source) + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("nb validators = " + source.getValidators().size()));
            }
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenReportModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ReportModel source = (ReportModel)((Object)evt.getSource());
            if (log.isDebugEnabled()) {
                log.debug((Object)("report model [" + (Object)((Object)source) + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenSelectExportModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataSelectionModel source = (DataSelectionModel)evt.getSource();
            if (log.isDebugEnabled()) {
                log.debug((Object)("selection export data model [" + source + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("nb selected export datas = " + source.getSelectedData().size()));
            }
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenSelectReportModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataSelectionModel source = (DataSelectionModel)evt.getSource();
            if (log.isDebugEnabled()) {
                log.debug((Object)("selection report data model [" + source + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("nb selected report datas = " + source.getSelectedData().size()));
            }
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenSelectValidateModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DataSelectionModel source = (DataSelectionModel)evt.getSource();
            if (log.isDebugEnabled()) {
                log.debug((Object)("selection model [" + source + "] changed on " + evt.getPropertyName() + ", new value = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("nb selected datas = " + source.getSelectedData().size() + ", nb selected referentiel = " + source.getSelectedReferentiel().size()));
            }
            AdminUIModel.this.firePropertyChange("validStep", AdminUIModel.this.validStep);
        }
    };
    PropertyChangeListener listenGPSModified = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("gps import model has changed [" + evt.getPropertyName() + "] = " + evt.getNewValue()));
            }
            AdminUIModel.this.validate();
        }
    };
    PropertyChangeListener listenSaveLocalChanged = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("backupFile".equals(propertyName)) {
                AdminUIModel.this.validate();
                return;
            }
            if ("backupFile".equals(propertyName)) {
                AdminUIModel.this.validate();
                return;
            }
            if ("localSourceNeedSave".equals(propertyName)) {
                boolean localSourceNeedSave = (Boolean)evt.getNewValue();
                if (localSourceNeedSave) {
                    AdminUIModel.this.setStepState(AdminStep.SAVE_LOCAL, WizardState.PENDING);
                }
                AdminUIModel.this.validate();
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skip property " + propertyName));
            }
        }
    };

    public AdminUIModel() {
        super(AdminStep.class, (WizardExtStep[])new AdminStep[0]);
        this.localSourceModel = new StorageUIModel(){

            @Override
            public String getLabel() {
                return AdminUIModel.this.getLocalStorageLabel(this);
            }

            @Override
            public void validate() {
                super.validate();
                AdminUIModel.this.firePropertyChange("valid", this.isValid());
            }
        };
        this.centralSourceModel = new StorageUIModel(){

            @Override
            public String getLabel() {
                return AdminUIModel.this.getReferentielStorageLabel(this);
            }

            @Override
            public void validate() {
                super.validate();
                AdminUIModel.this.firePropertyChange("valid", this.isValid());
            }
        };
        if (log.isDebugEnabled()) {
            log.debug((Object)("model [" + (Object)((Object)this) + "] is instanciate."));
        }
    }

    public AdminActionModel getStepModel(AdminStep operation) {
        return (AdminActionModel)super.getStepModel((WizardExtStep)operation);
    }

    public StorageUIHandler getStorageHandler() {
        return this.storageHandler;
    }

    public DataService getDataService() {
        return this.dataService;
    }

    public ObserveConfig getConfig() {
        return this.config;
    }

    public void start(AdminUI ui) {
        File reportFile;
        this.storageHandler = ui.getContextValue(StorageUIHandler.class);
        this.dataService = ui.getContextValue(DataService.class);
        this.config = ui.getContextValue(ObserveConfig.class);
        this.start();
        ui.blockOperations();
        if (log.isInfoEnabled()) {
            log.info((Object)("enables steps = " + this.steps));
            log.info((Object)("enables operations = " + this.operations));
            log.info((Object)("NeedLocalService = " + this.needLocalSource));
        }
        DataSource previousSource = ui.getContextValue(DataSource.class);
        this.setPreviousSource(previousSource);
        this.localSourceModel.init((JAXXContext)ui, previousSource);
        if (previousSource != null && previousSource.isOpen()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Close previous source " + previousSource.getShortLabel()));
            }
            this.doCloseSource(previousSource, false);
        }
        boolean needLocalSource = false;
        if (previousSource == null) {
            needLocalSource = true;
        }
        this.setNeedLocalSource(needLocalSource);
        boolean canUseRemoteSource = true;
        if (this.containsOperation(AdminStep.SYNCHRONIZE)) {
            canUseRemoteSource = false;
        }
        if (!canUseRemoteSource) {
            this.localSourceModel.setDbMode(DbMode.USE_LOCAL);
            this.localSourceModel.setCreationMode(null);
        }
        this.localSourceModel.setCanCreateLocalService(false);
        this.localSourceModel.setCanUseRemoteService(canUseRemoteSource);
        this.localSourceModel.start();
        if (log.isDebugEnabled()) {
            this.localSourceModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(evt.getSource() + " - Property [" + name + "] has changed from  " + oldValue + " to " + newValue));
                    }
                }
            });
        }
        this.centralSourceModel.init((JAXXContext)ui, null);
        this.centralSourceModel.setCanCreateLocalService(false);
        this.centralSourceModel.setCanUseLocalService(false);
        this.centralSourceModel.setCanUseRemoteService(true);
        this.centralSourceModel.setDbMode(DbMode.USE_REMOTE);
        this.centralSourceModel.start();
        if (log.isDebugEnabled()) {
            this.centralSourceModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    Object oldValue = evt.getOldValue();
                    Object newValue = evt.getNewValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(evt.getSource() + " - Property [" + name + "] has changed from  " + oldValue + " to " + newValue));
                    }
                }
            });
        }
        this.centralSourceModel.testRemote();
        if (this.containsStep((WizardStep)AdminStep.SELECT_EXPORT_DATA)) {
            DataSelectionModel selectExportModel = this.getExportModel().getSelectExportModel();
            selectExportModel.setUseData(true);
            selectExportModel.setUseOpenData(false);
            selectExportModel.setUseReferentiel(false);
            selectExportModel.addPropertyChangeListener(this.listenSelectExportModified);
        }
        if (this.containsStep((WizardStep)AdminStep.SELECT_REPORT_DATA)) {
            DataSelectionModel selectReportDataModel = this.getReportModel().getSelectReportDataModel();
            selectReportDataModel.setUseData(true);
            selectReportDataModel.setUseOpenData(true);
            selectReportDataModel.setUseReferentiel(false);
            selectReportDataModel.addPropertyChangeListener(this.listenSelectReportModified);
        }
        if (this.containsStep((WizardStep)AdminStep.SELECT_VALIDATE_DATA)) {
            DataSelectionModel selectValidateDataModel = this.getValidateModel().getSelectValidateDataModel();
            selectValidateDataModel.setUseOpenData(true);
            selectValidateDataModel.addPropertyChangeListener(this.listenSelectValidateModified);
        }
        if (this.containsOperation(AdminStep.SAVE_LOCAL)) {
            File backupfile = new File(this.config.getBackupDirectory(), this.storageHandler.getDefaultBackupFilename());
            this.getSaveLocalModel().setBackupFile(backupfile);
            this.getSaveLocalModel().setDoBackup(true);
            this.getSaveLocalModel().addPropertyChangeListener(this.listenSaveLocalChanged);
        }
        if (this.containsOperation(AdminStep.IMPORT_GPS)) {
            this.getImportGPSModel().setImportGPSMaxDelay(this.config.getDefaultGpsMaxDelay());
            this.getImportGPSModel().setImportGPSMaxSpeed(Float.valueOf(this.config.getDefaultGpsMaxSpeed()));
            this.getImportGPSModel().addPropertyChangeListener(this.listenGPSModified);
        }
        if (this.containsOperation(AdminStep.VALIDATE)) {
            this.getValidateModel().addPropertyChangeListener(this.listenValidationModified);
            this.getValidateModel().addScope(BeanValidatorScope.ERROR);
            this.getValidateModel().setModelMode(ValidationModelMode.DATA);
            this.getValidateModel().setAllContextNames(new String[]{"n1-update", "n1-create"});
            this.getValidateModel().setContextName("n1-update");
            reportFile = new File(this.config.getReportDirectory(), this.getValidateModel().getDefaultReportFilename());
            this.getValidateModel().setReportFile(reportFile);
        }
        if (this.containsOperation(AdminStep.REPORT)) {
            reportFile = ObserveResourceManager.Resource.report.getFile(this.config.getReportDirectory());
            log.info((Object)("Will use report file : " + reportFile));
            this.getReportModel().setReportFile(reportFile);
            List<Report> reports = this.getReportModel().getReports();
            this.getReportModel().addPropertyChangeListener(this.listenReportModified);
            log.info((Object)("Detects " + reports.size() + " report(s)."));
        }
        this.addPropertyChangeListener("step", this.listenStepChanged);
        this.validate();
    }

    public void destroy() {
        this.localSourceModel.destroy();
        this.centralSourceModel.destroy();
        super.destroy();
    }

    public DataSource getPreviousSource() {
        return this.previousSource;
    }

    public DataSource getLocalSource() {
        return this.localSource;
    }

    public DataSource getCentralSource() {
        return this.centralSource;
    }

    public DataSource getTmpSource() {
        return this.tmpSource;
    }

    public DataSource getSafeLocalSource(boolean open) {
        if (this.localSource == null || open && this.localSource.wasClosed()) {
            this.localSource = this.createService(this.getLocalSourceModel());
        }
        if (open) {
            this.doOpenSource(this.localSource);
        }
        return this.localSource;
    }

    public DataSource getSafeCentralSource(boolean open) {
        if (this.centralSource == null || open && this.centralSource.wasClosed()) {
            this.centralSource = this.createService(this.getCentralSourceModel());
        }
        if (open) {
            this.doOpenSource(this.centralSource);
        }
        return this.centralSource;
    }

    public DataSource getSafeTmpSource(boolean open) {
        if (this.tmpSource == null) {
            try {
                this.tmpSource = ObserveServiceHelper.newEmptyTempStorage((IObserveConfig)this.config, (String)I18n.n_((String)"observe.storage.label.synchro"), (String)"synchrodb");
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create temporary database", e);
            }
            if (open) {
                this.doOpenSource(this.tmpSource);
            }
        }
        return this.tmpSource;
    }

    public StorageUIModel getLocalSourceModel() {
        return this.localSourceModel;
    }

    public StorageUIModel getCentralSourceModel() {
        return this.centralSourceModel;
    }

    public ValidateModel getValidateModel() {
        return (ValidateModel)this.getStepModel(AdminStep.VALIDATE);
    }

    public ImportGPSModel getImportGPSModel() {
        return (ImportGPSModel)this.getStepModel(AdminStep.IMPORT_GPS);
    }

    public SynchronizeModel getSynchronizeReferentielModel() {
        return (SynchronizeModel)this.getStepModel(AdminStep.SYNCHRONIZE);
    }

    public ExportModel getExportModel() {
        return (ExportModel)this.getStepModel(AdminStep.EXPORT_DATA);
    }

    public ReportModel getReportModel() {
        return (ReportModel)this.getStepModel(AdminStep.REPORT);
    }

    public SaveLocalModel getSaveLocalModel() {
        return (SaveLocalModel)this.getStepModel(AdminStep.SAVE_LOCAL);
    }

    public boolean isNeedLocalSource() {
        return this.needLocalSource;
    }

    public void cancel() {
        super.cancel();
        this.gotoStep((WizardStep)this.getSteps().get(this.getSteps().size() - 1));
    }

    public AdminUIModel addOperation(AdminStep operation) {
        if (operation == AdminStep.EXPORT_DATA) {
            this.getOperations().add(AdminStep.SYNCHRONIZE);
        }
        return (AdminUIModel)super.addOperation((WizardExtStep)operation);
    }

    public void removeOperation(AdminStep operation) {
        if (operation == AdminStep.SYNCHRONIZE) {
            this.getOperations().remove((Object)AdminStep.EXPORT_DATA);
        }
        super.removeOperation((WizardExtStep)operation);
    }

    public void setNeedLocalSource(boolean needLocalSource) {
        boolean oldValue = this.needLocalSource;
        this.needLocalSource = needLocalSource;
        this.firePropertyChange(NEED_LOCAL_SOURCE_PROPERTY_NAME, oldValue, needLocalSource);
    }

    public void setPreviousSource(DataSource previousSource) {
        this.previousSource = previousSource;
    }

    public boolean validate(AdminStep s) {
        boolean validate;
        boolean bl = validate = super.validate((WizardStep)s) && !this.getOperations().isEmpty();
        if (!validate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"not valid from generic states...");
            }
            return false;
        }
        switch (s) {
            case CONFIG: {
                if (!(validate &= this.localSourceModel.isValid()) && log.isDebugEnabled()) {
                    log.debug((Object)"local service is not valid");
                }
                if (this.containsOperation(AdminStep.VALIDATE)) {
                    ValidatorsMap validators;
                    if (StringUtils.isEmpty((String)this.getValidateModel().getContextName())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation context name");
                        }
                        return false;
                    }
                    if (this.getValidateModel().getScopes().isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation scopes");
                        }
                        return false;
                    }
                    if (this.getValidateModel().getModelMode() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validation model mode");
                        }
                        return false;
                    }
                    if (this.getValidateModel().isGenerateReport()) {
                        File file = this.getValidateModel().getReportFile();
                        if (file.exists()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"report file already exists");
                            }
                            return false;
                        }
                        File parentFile = file.getParentFile();
                        if (parentFile == null || !parentFile.exists()) {
                            return false;
                        }
                    }
                    if ((validators = this.getValidateModel().getValidators()).isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"no validators detected");
                        }
                        return false;
                    }
                    DataSource source = this.getSafeLocalSource(true);
                    DataSelectionModel selectValidateDataModel = this.getValidateModel().getSelectValidateDataModel();
                    if (!(!selectValidateDataModel.isUseData() || source.canReadData() && source.canWriteData())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"can not read and write data");
                        }
                        return false;
                    }
                    if (!(!selectValidateDataModel.isUseReferentiel() || source.canReadReferentiel() && source.canWriteReferentiel())) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"can not read and write referentiel");
                        }
                        return false;
                    }
                }
                if (this.containsOperation(AdminStep.SYNCHRONIZE)) {
                    validate &= this.centralSourceModel.isValid();
                }
                if (this.containsOperation(AdminStep.EXPORT_DATA)) {
                    validate &= this.centralSourceModel.isValid() && this.centralSourceModel.getPgConfig().isCanWriteData();
                }
                if (this.containsOperation(AdminStep.IMPORT_GPS)) {
                    File importGPSFile = this.getImportGPSModel().getImportGPSFile();
                    validate &= importGPSFile != null && importGPSFile.exists();
                }
                if (!this.containsOperation(AdminStep.REPORT)) break;
                File reportFile = this.getReportModel().getReportFile();
                validate &= reportFile != null && reportFile.exists();
                break;
            }
            case SELECT_VALIDATE_DATA: {
                DataSelectionModel selectValidateDataModel = this.getValidateModel().getSelectValidateDataModel();
                if (!(validate &= this.validate(AdminStep.CONFIG))) break;
                boolean empty = selectValidateDataModel.isEmpty();
                validate &= !empty;
                break;
            }
            case SELECT_EXPORT_DATA: {
                if (!(validate &= this.validate(AdminStep.CONFIG))) break;
                boolean empty = this.getExportModel().getSelectExportModel().isDataEmpty();
                validate &= !empty;
                break;
            }
            case SELECT_REPORT_DATA: {
                if (!(validate &= this.validate(AdminStep.CONFIG))) break;
                DataSelectionModel selectReportDataModel = this.getReportModel().getSelectReportDataModel();
                boolean empty = selectReportDataModel.isDataEmpty();
                validate &= !empty && selectReportDataModel.getSelectedData().size() == 1;
                break;
            }
            case VALIDATE: {
                validate &= this.validate(AdminStep.SELECT_VALIDATE_DATA) && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case EXPORT_DATA: {
                validate &= this.validate(AdminStep.SELECT_EXPORT_DATA) && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case SYNCHRONIZE: 
            case IMPORT_GPS: {
                validate &= this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case SAVE_LOCAL: {
                validate &= this.getSaveLocalModel().isCanSaveLocal() && this.getStepState(s) == WizardState.SUCCESSED;
                break;
            }
            case SHOW_RESUME: {
                validate = true;
            }
        }
        return validate;
    }

    protected AdminStep[] updateStepUniverse() {
        ArrayList<AdminStep> universe = new ArrayList<AdminStep>();
        universe.add(AdminStep.CONFIG);
        if (!this.operations.isEmpty()) {
            if (this.containsOperation(AdminStep.EXPORT_DATA)) {
                universe.add(AdminStep.SELECT_EXPORT_DATA);
            }
            if (this.containsOperation(AdminStep.REPORT)) {
                universe.add(AdminStep.SELECT_REPORT_DATA);
                universe.add(AdminStep.REPORT);
            }
            if (this.containsOperation(AdminStep.SYNCHRONIZE)) {
                universe.add(AdminStep.SYNCHRONIZE);
            }
            if (this.containsOperation(AdminStep.VALIDATE)) {
                universe.add(AdminStep.SELECT_VALIDATE_DATA);
                universe.add(AdminStep.VALIDATE);
            }
            if (this.containsOperation(AdminStep.IMPORT_GPS)) {
                universe.add(AdminStep.IMPORT_GPS);
            }
            this.updateSaveLocalOperation();
            if (this.containsOperation(AdminStep.SAVE_LOCAL)) {
                universe.add(AdminStep.SAVE_LOCAL);
            }
            if (this.containsOperation(AdminStep.EXPORT_DATA)) {
                universe.add(AdminStep.EXPORT_DATA);
            }
            universe.add(AdminStep.SHOW_RESUME);
        }
        return universe.toArray(new AdminStep[universe.size()]);
    }

    public void removeLocalSource() {
        if (this.localSource != null) {
            this.doCloseSource(this.localSource, false);
            this.localSource = null;
        }
    }

    public void removeCentralSource() {
        if (this.centralSource != null) {
            this.doCloseSource(this.centralSource, false);
            this.centralSource = null;
        }
    }

    public void removeTmpSource() {
        if (this.tmpSource != null) {
            this.doCloseSource(this.tmpSource, false);
            this.tmpSource = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeExistingMaress(DataSource source) {
        String txName = "computeExistingMaress";
        try {
            TopiaContext tx = source.beginTransaction(txName);
            try {
                List ids = ObserveDAOHelper.getMareeDAO((TopiaContext)tx).findAllIds();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found " + ids.size() + "existing maree(s)"));
                }
                this.getExportModel().setExistingMareeIds(ids);
            }
            finally {
                source.closeTransaction(tx, txName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Can not have existing maree...", (Throwable)e);
        }
    }

    protected void updateSaveLocalOperation() {
        boolean shouldAdd = false;
        for (AdminStep s : this.operations) {
            if (!s.isNeedSave()) continue;
            shouldAdd = true;
        }
        if (shouldAdd) {
            this.operations.add(AdminStep.SAVE_LOCAL);
        } else {
            this.operations.remove((Object)AdminStep.SAVE_LOCAL);
        }
    }

    protected String getLocalStorageLabel(StorageUIModel model) {
        String txt = I18n.n_((String)"observe.storage.label.synchro.local");
        if (this.containsOperation(AdminStep.VALIDATE)) {
            txt = I18n.n_((String)"observe.storage.label.validate.source");
        } else if (this.containsOperation(AdminStep.REPORT)) {
            txt = I18n.n_((String)"observe.storage.label.report.source");
        }
        String params = model.getDbMode() == DbMode.USE_REMOTE ? I18n._((String)"observe.storage.remote.db") + " " + model.getRemoteUrl() : I18n._((String)"observe.storage.locale.db") + " " + model.getH2Config().getDataDirectory().getAbsolutePath();
        txt = I18n._((String)txt, (Object[])new Object[]{params});
        return txt;
    }

    protected String getReferentielStorageLabel(StorageUIModel model) {
        String txt = I18n.n_((String)"observe.storage.label.synchro.referentiel");
        String params = model.getDbMode() == DbMode.CREATE_LOCAL ? model.getH2Config().getDataDirectory().getAbsolutePath() : model.getRemoteUrl();
        txt = I18n._((String)txt, (Object[])new Object[]{params});
        return txt;
    }

    protected DataSource createService(StorageUIModel model) {
        try {
            DataSource service = this.storageHandler.newServiceFromModel(model, false, I18n.n_((String)"observe.storage.label.local"), I18n.n_((String)"observe.storage.label.remote"));
            return service;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create service for " + (Object)((Object)model), e);
        }
    }

    protected void doOpenSource(DataSource source) {
        if (source == null || source.isOpen()) {
            return;
        }
        try {
            source.doOpen();
        }
        catch (DataSourceException e) {
            throw new IllegalStateException("Could not open " + source, e);
        }
    }

    protected void doCloseSource(DataSource source, boolean destroy) {
        if (source == null || !source.isOpen() || source.wasClosed()) {
            return;
        }
        try {
            source.doClose(destroy);
        }
        catch (DataSourceException e) {
            throw new IllegalStateException("Could not close " + source, e);
        }
    }
}

