/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.referentiel.SystemeObserve;
import fr.ird.observe.services.storage.StorageServiceException;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.SystemObserveUI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;

public class SystemObserveHandler
extends ObserveContentHandler<Void, Activite, SystemObserveUI> {
    private static Log log = LogFactory.getLog(SystemObserveHandler.class);

    public SystemObserveHandler() {
        super(Void.class, Activite.class, "systemeObserve", "commentaire", "distanceSystemeObserve");
    }

    @Override
    public void openUI(SystemObserveUI context) throws Exception {
        super.openUI(context);
        Activite activite = context.getContextValue(Activite.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        this.loador.load((Object)activite, (Object)context.getEditBean(), true, new String[0]);
        context.setMode(mode);
        if (mode == ObserveContentMode.UPDATE) {
            context.startEdit(activite);
        }
    }

    @Override
    protected ObserveContentMode getObserveContentMode(SystemObserveUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            Activite activite = context.getContextValue(Activite.class);
            if (activite.isOpen()) {
                mode = ObserveContentMode.UPDATE;
            } else {
                mode = ObserveContentMode.READ;
                SystemObserveHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
            }
        }
        return mode;
    }

    @Override
    public void startEditUI(SystemObserveUI context, Activite o, Activite editBean, String ... binding) {
        SystemObserveHandler.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.updating.activite"));
        super.startEditUI(context, o, editBean, binding);
    }

    @Override
    public void saveUI(SystemObserveUI context, boolean refresh) {
        try {
            Activite bean = context.getContextValue(Activite.class);
            SystemObserveHandler.getStorageService((JAXXContext)context).update((TopiaEntity)bean, (TopiaEntity)context.getEditBean(), this.loador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        context.setModified(false);
    }

    public void selectSystemeObserve(SystemObserveUI context, Activite bean, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeSystemeObserve();
        if (!update && selected.length > 0) {
            List list = bean.getSystemeObserve();
            for (Object o : selected) {
                if (list.contains(o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            ListSelectionModel selectionModel = context.getSystemeObserve().getSelectionModel();
            selectionModel.setValueIsAdjusting(true);
            ArrayList<SystemeObserve> newList = new ArrayList<SystemeObserve>(selected.length);
            for (Object o : selected) {
                newList.add((SystemeObserve)o);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update operations " + newList.size()));
            }
            bean.setSystemeObserve(newList);
            selectionModel.setValueIsAdjusting(false);
        }
    }
}

