/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveAction;
import fr.ird.observe.storage.CommonStorageConfigParam;
import fr.ird.observe.storage.CreationMode;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.impl.H2StorageConfig;
import fr.ird.observe.storage.impl.H2StorageConfigParam;
import fr.ird.observe.storage.impl.PGStorageConfig;
import fr.ird.observe.storage.impl.PGStorageConfigParam;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import jaxx.runtime.Util;
import jaxx.runtime.context.DefaultApplicationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;

@DefaultApplicationContext.AutoLoad
public class ObserveConfig
extends ApplicationConfig {
    private static Log log = LogFactory.getLog(ObserveConfig.class);
    public static final String APPLICATION_PROPERTIES = "/observe.properties";
    public static final String USER_DIRECTORY_FILENAME = ".observe";
    public static final String BACKUP_DB_PATTERN = "obstuna-local-%1$tF--%1$tk-%1$tM-%1$tS.sql.gz";
    protected static File observeUserDirectory;
    public static final String PROPERTY_FULL_SCREEN = "fullScreen";
    public static final String PROPERTY_LOCALE = "locale";
    public static final String PROPERTY_ADJUSTING = "adjusting";
    public static final String PROPERTY_SHOW_NUMBER_EDITOR_BUTTON = "showNumberEditorButton";
    public static final String PROPERTY_AUTO_POPUP_NUMBER_EDITOR = "autoPopupNumberEditor";
    public static final String PROPERTY_LOCAL_STORAGE_EXIST = "localStorageExist";
    public static final String PROPERTY_INITIAL_DUMP_EXIST = "initialDumpExist";
    public static final String PROPERTY_MAIN_STORAGE_OPENED = "mainStorageOpened";
    public static final String PROPERTY_DISPLAY_SYNCHRO_RESUME = "displaySynchroResume";
    public static final String PROPERTY_STORE_RESUME_STORAGE = "storeResumeStorage";
    public static final String PROPERTY_DEFAULT_GPS_MAX_DELAY = "defaultGpsMaxDelay";
    public static final String PROPERTY_DEFAULT_GPS_MAX_SPEED = "defaultGpsMaxSpeed";
    public static final String PROPERTY_CHANGE_SYNCHRO_SRC = "changeSynchroSrc";
    public static final String PROPERTY_CAN_GENERATE_EMPTY_DB = "canGenerateEmptyDb";
    public static final String PROPERTY_DEFAULT_DB_MODE = "defaultDbMode";
    public static final String PROPERTY_DEFAULT_CREATION_MODE = "defaultCreationMode";
    private boolean displayMainUI = true;
    private boolean localStorageExist;
    private boolean initialDumpExist;
    private boolean mainStorageOpened;
    private Boolean mainStorageOpenedLocal;
    private boolean canUseUI = true;
    protected boolean adjusting;
    protected final PropertyChangeListener saveAction = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ObserveConfig.this.adjusting) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Skip save while adjusting");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving configuration at " + new Date()));
            }
            ObserveConfig.this.saveForUser();
        }
    };
    public static final String[] DEFAULT_JAXX_PCS;

    public static File getObserveUserDirectory() {
        if (observeUserDirectory == null) {
            observeUserDirectory = new File(new File(ObserveConfig.getUserHome()), USER_DIRECTORY_FILENAME);
        }
        return observeUserDirectory;
    }

    public ObserveConfig() {
        this.setConfigFileName(Option.CONFIG_FILE.defaultValue);
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(APPLICATION_PROPERTIES);
        Properties p = new Properties();
        try {
            p.load(stream);
            for (Object k : p.keySet()) {
                String key = k + "";
                Object value = p.get(k);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("install properties " + k + " : " + value));
                }
                this.setDefaultOption(key, "" + value);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        for (Option o : Option.values()) {
            this.setDefaultOption(o.key, o.defaultValue);
        }
        String sVersion = VersionUtil.removeSnapshot((String)this.getOption("application.version"));
        Version version = VersionUtil.valueOf((String)sVersion);
        this.setDefaultOption("version", version.getVersion());
        Version dbVersion = version.hasClassifier() ? VersionUtil.removeClassifier((Version)version) : VersionUtil.valueOf((String)version.toString());
        this.setDefaultOption("db.version", dbVersion.getVersion());
        FileUtil.setCurrentDirectory((File)ObserveConfig.getObserveUserDirectory());
        ObserveConfig.getObserveUserDirectory().mkdirs();
        this.getInitialDbDump();
        this.getLocalDBDirectory();
        this.getBackupDirectory();
        FileUtil.deleteRecursively((File)this.getTmpDirectory());
        this.initActions();
        this.adjusting = true;
        this.addPropertyChangeListener(PROPERTY_FULL_SCREEN, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_LOCALE, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_AUTO_POPUP_NUMBER_EDITOR, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_SHOW_NUMBER_EDITOR_BUTTON, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_CHANGE_SYNCHRO_SRC, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_DISPLAY_SYNCHRO_RESUME, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_STORE_RESUME_STORAGE, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_DEFAULT_DB_MODE, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_DEFAULT_CREATION_MODE, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_CAN_GENERATE_EMPTY_DB, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_DEFAULT_GPS_MAX_DELAY, this.saveAction);
        this.addPropertyChangeListener(PROPERTY_DEFAULT_GPS_MAX_SPEED, this.saveAction);
        this.adjusting = false;
    }

    public void setOption(String key, String value) {
        if (key.equals(PROPERTY_ADJUSTING)) {
            this.setAdjusting(Boolean.valueOf(value));
            return;
        }
        super.setOption(key, value);
    }

    public void initActions() {
        for (Action a : Action.values()) {
            for (String alias : a.aliases) {
                this.addActionAlias(alias, a.action);
            }
        }
    }

    public String getCopyrightText() {
        return "Version " + this.getVersion() + " IRD @ 2008-2010";
    }

    public Version getVersion() {
        Version option = (Version)this.getOption(Version.class, "version");
        return option;
    }

    public Version getDbVersion() {
        Version option = (Version)this.getOption(Version.class, "db.version");
        return option;
    }

    public boolean isAutoPopupNumberEditor() {
        Boolean result = this.getOptionAsBoolean(Option.AUTO_POPUP_NUMBER_EDITOR.key);
        return result != null && result != false;
    }

    public boolean isShowNumberEditorButton() {
        Boolean result = this.getOptionAsBoolean(Option.SHOW_NUMBER_EDITOR_BUTTON.key);
        return result != null && result != false;
    }

    public boolean isFullScreen() {
        Boolean result = this.getOptionAsBoolean(Option.FULL_SCREEN.key);
        return result != null && result != false;
    }

    public File getLocalDBDirectory() {
        File result = this.getOptionAsFile(Option.DB_DIRECTORY.key);
        if (!result.getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        return result;
    }

    public File getInitialDbDump() {
        File result = this.getOptionAsFile(Option.INITIAL_DB_DUMP.key);
        if (!result.getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        return result;
    }

    public File getBackupDirectory() {
        File result = this.getOptionAsFile(Option.BACKUP_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getTmpDirectory() {
        File result = this.getOptionAsFile(Option.TMP_DIRECTORY.key);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public String getH2Login() {
        String result = this.getOption(Option.H2_LOGIN.key);
        return result;
    }

    public char[] getH2Password() {
        String result = this.getOption(Option.H2_PASSWORD.key);
        char[] r = result.toCharArray();
        result = null;
        return r;
    }

    public String getObstunaUrl() {
        String result = this.getOption(Option.OBSTUNA_URL.key);
        return result;
    }

    public String getObstunaLogin() {
        String result = this.getOption(Option.OBSTUNA_LOGIN.key);
        return result;
    }

    public char[] getObstunaPassword() {
        String result = this.getOption(Option.OBSTUNA_PASSWORD.key);
        char[] r = result.toCharArray();
        result = null;
        return r;
    }

    public boolean isObstunaUseSsl() {
        Boolean result = this.getOptionAsBoolean(Option.OBSTUNA_USE_SSL_CERT.key);
        return result != null && result != false;
    }

    public File getObstunaSslCert() {
        File result = this.getOptionAsFile(Option.OBSTUNA_SSL_CERTIFICAT_FILE.key);
        return result;
    }

    public boolean isDisplayMainUI() {
        return this.displayMainUI;
    }

    public boolean isCanUseUI() {
        return this.canUseUI;
    }

    public boolean isLocalStorageExist() {
        return this.localStorageExist;
    }

    public boolean isInitialDumpExist() {
        return this.initialDumpExist;
    }

    public boolean isMainStorageOpened() {
        return this.mainStorageOpened;
    }

    public Boolean getMainStorageOpenedLocal() {
        return this.mainStorageOpenedLocal;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public DbMode getDefaultDbMode() {
        DbMode result = (DbMode)this.getOption(DbMode.class, Option.DEFAULT_DB_MODE.key);
        return result;
    }

    public CreationMode getDefaultCreationMode() {
        CreationMode result = (CreationMode)this.getOption(CreationMode.class, Option.DEFAULT_CREATION_MODE.key);
        return result;
    }

    public int getDefaultGpsMaxDelay() {
        Integer i = this.getOptionAsInt(Option.DEFAULT_GPS_MAX_DELAY.key);
        return i;
    }

    public float getDefaultGpsMaxSpeed() {
        double i = this.getOptionAsDouble(Option.DEFAULT_GPS_MAX_SPEED.key);
        return (float)i;
    }

    public boolean isChangeSynchroSrc() {
        boolean result = this.getOptionAsBoolean(Option.CHANGE_SYNCHRO_SRC.key);
        return result;
    }

    public boolean isDisplaySynchroResume() {
        boolean result = this.getOptionAsBoolean(Option.DISPLAY_SYNCHRO_RESUME.key);
        return result;
    }

    public boolean isStoreRemoteStorage() {
        boolean result = this.getOptionAsBoolean(Option.STORE_REMOTE_STORAGE.key);
        return result;
    }

    public boolean isCanGenerateEmptyDb() {
        boolean result = this.getOptionAsBoolean(Option.CAN_GENERATE_EMPTY_DB.key);
        return result;
    }

    public boolean isCanMigrateObstuna() {
        Boolean result = this.getOptionAsBoolean(Option.OBSTUNA_CAN_MIGRATE.key);
        return result != null && result != false;
    }

    public boolean isCanMigrateH2() {
        Boolean result = this.getOptionAsBoolean(Option.H2_CAN_MIGRATE.key);
        return result != null && result != false;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, Option.LOCALE.key);
        return result;
    }

    public void setAutoPopupNumberEditor(boolean autoPopupNumberEditor) {
        boolean oldValue = this.isAutoPopupNumberEditor();
        this.setOption(Option.AUTO_POPUP_NUMBER_EDITOR.key, autoPopupNumberEditor + "");
        this.firePropertyChange(PROPERTY_AUTO_POPUP_NUMBER_EDITOR, oldValue, autoPopupNumberEditor);
    }

    public void setShowNumberEditorButton(boolean showNumberEditorButton) {
        boolean oldValue = this.isShowNumberEditorButton();
        this.setOption(Option.AUTO_POPUP_NUMBER_EDITOR.key, showNumberEditorButton + "");
        this.firePropertyChange(PROPERTY_SHOW_NUMBER_EDITOR_BUTTON, oldValue, showNumberEditorButton);
    }

    public void setFullScreen(boolean fullScreen) {
        boolean oldValue = this.isFullScreen();
        this.setOption(Option.FULL_SCREEN.key, fullScreen + "");
        this.firePropertyChange(PROPERTY_FULL_SCREEN, oldValue, fullScreen);
    }

    public void setChangeSynchroSrc(boolean newvalue) {
        boolean oldValue = this.isChangeSynchroSrc();
        this.setOption(Option.CHANGE_SYNCHRO_SRC.key, newvalue + "");
        this.firePropertyChange(PROPERTY_CHANGE_SYNCHRO_SRC, oldValue, newvalue);
    }

    public void setDisplaySynchroResume(boolean newvalue) {
        boolean oldValue = this.isDisplaySynchroResume();
        this.setOption(Option.DISPLAY_SYNCHRO_RESUME.key, newvalue + "");
        this.firePropertyChange(PROPERTY_DISPLAY_SYNCHRO_RESUME, oldValue, newvalue);
    }

    public void setStoreRemoteStorage(boolean newvalue) {
        boolean oldValue = this.isStoreRemoteStorage();
        this.setOption(Option.STORE_REMOTE_STORAGE.key, newvalue + "");
        this.firePropertyChange(PROPERTY_STORE_RESUME_STORAGE, oldValue, newvalue);
    }

    public void setDefaultDbMode(DbMode mode) {
        DbMode oldValue = this.getDefaultDbMode();
        this.setOption(Option.DEFAULT_DB_MODE.key, mode.name());
        this.firePropertyChange(PROPERTY_DEFAULT_DB_MODE, oldValue, mode);
    }

    public void setDefaultCreationMode(CreationMode mode) {
        CreationMode oldValue = this.getDefaultCreationMode();
        this.setOption(Option.DEFAULT_CREATION_MODE.key, mode.name());
        this.firePropertyChange(PROPERTY_DEFAULT_CREATION_MODE, oldValue, mode);
    }

    public void setCanGenerateEmptyDb(boolean newvalue) {
        boolean oldValue = this.isCanGenerateEmptyDb();
        this.setOption(Option.CAN_GENERATE_EMPTY_DB.key, newvalue + "");
        this.firePropertyChange(PROPERTY_CAN_GENERATE_EMPTY_DB, oldValue, newvalue);
    }

    public void setDefaultGpsMaxDelay(int defaultGpsMaxDelay) {
        int oldValue = this.getDefaultGpsMaxDelay();
        this.setOption(Option.DEFAULT_GPS_MAX_DELAY.key, defaultGpsMaxDelay + "");
        this.firePropertyChange(PROPERTY_DEFAULT_GPS_MAX_DELAY, oldValue, defaultGpsMaxDelay);
    }

    public void setDefaultGpsMaxSpeed(float defaultGpsMaxSpeed) {
        float oldValue = this.getDefaultGpsMaxSpeed();
        this.setOption(Option.DEFAULT_GPS_MAX_SPEED.key, defaultGpsMaxSpeed + "");
        this.firePropertyChange(PROPERTY_DEFAULT_GPS_MAX_SPEED, Float.valueOf(oldValue), Float.valueOf(defaultGpsMaxSpeed));
    }

    public void setLocale(Locale newLocale) {
        Locale oldValue = this.getLocale();
        this.setOption(Option.LOCALE.key, newLocale.toString());
        this.firePropertyChange(PROPERTY_LOCALE, oldValue, newLocale);
    }

    public void setLocalStorageExist(boolean localStorageExist) {
        this.localStorageExist = localStorageExist;
        this.firePropertyChange(PROPERTY_LOCAL_STORAGE_EXIST, null, localStorageExist);
    }

    public void setInitialDumpExist(boolean initialDumpExist) {
        this.initialDumpExist = initialDumpExist;
        this.firePropertyChange(PROPERTY_INITIAL_DUMP_EXIST, null, initialDumpExist);
    }

    public void setMainStorageOpened(boolean mainStorageOpened) {
        this.mainStorageOpened = mainStorageOpened;
        if (!mainStorageOpened) {
            this.setMainStorageOpenedLocal(null);
        }
        this.firePropertyChange(PROPERTY_MAIN_STORAGE_OPENED, null, mainStorageOpened);
    }

    public void setAdjusting(boolean adjusting) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("changing adjusting to " + adjusting));
        }
        boolean oldValue = this.adjusting;
        this.adjusting = adjusting;
        this.firePropertyChange(PROPERTY_ADJUSTING, oldValue, adjusting);
    }

    public void setMainStorageOpenedLocal(Boolean mainStorageOpenedLocal) {
        this.mainStorageOpenedLocal = mainStorageOpenedLocal;
        this.firePropertyChange("mainStorageOpenedLocal", null, mainStorageOpenedLocal);
    }

    public void setDisplayMainUI(boolean b) {
        this.displayMainUI = b;
    }

    public void setCanUseUI(boolean canUseUI) {
        this.canUseUI = canUseUI;
        if (!canUseUI) {
            this.setDisplayMainUI(false);
        }
    }

    public void setCanMigrateObstuna(Boolean newValue) {
        this.setOption(Option.OBSTUNA_CAN_MIGRATE.key, newValue.toString());
    }

    public void setCanMigrateH2(Boolean newValue) {
        this.setOption(Option.H2_CAN_MIGRATE.key, newValue.toString());
    }

    public void saveForUser() {
        super.saveForUser(new String[]{Option.OBSTUNA_PASSWORD.key, Option.H2_PASSWORD.key, Option.OBSTUNA_CAN_MIGRATE.key, Option.H2_CAN_MIGRATE.key});
    }

    public void fromStorageConfig(H2StorageConfig config) {
    }

    public void fromStorageConfig(PGStorageConfig config) {
        this.setOption(Option.OBSTUNA_URL.key, config.getUrl());
        this.setOption(Option.OBSTUNA_LOGIN.key, config.getLogin());
        this.setOption(Option.OBSTUNA_PASSWORD.key, new String(config.getPassword()));
        boolean useSsl = config.isUseSsl();
        this.setOption(Option.OBSTUNA_USE_SSL_CERT.key, useSsl + "");
        if (useSsl) {
            this.setOption(Option.OBSTUNA_SSL_CERTIFICAT_FILE.key, config.getSslCertificatFile().getAbsolutePath());
        } else {
            this.setOption(Option.OBSTUNA_SSL_CERTIFICAT_FILE.key, "");
        }
        this.saveForUser();
    }

    public H2StorageConfig toH2StorageConfig(String label) {
        H2StorageConfig result = StorageServiceFactory.newH2Config((String)label, (Object[])new Object[]{CommonStorageConfigParam.LOGIN, this.getH2Login(), CommonStorageConfigParam.PASSWORD, this.getH2Password(), H2StorageConfigParam.DIRECTORY, this.getLocalDBDirectory(), CommonStorageConfigParam.CAN_MIGRATE, this.isCanMigrateH2()});
        return result;
    }

    public PGStorageConfig toPostgresStorageConfig(String label) {
        PGStorageConfig result = StorageServiceFactory.newPGConfig((String)label, (Object[])new Object[]{PGStorageConfigParam.URL, this.getObstunaUrl(), CommonStorageConfigParam.LOGIN, this.getObstunaLogin(), CommonStorageConfigParam.PASSWORD, this.getObstunaPassword(), PGStorageConfigParam.USE_SSL, this.isObstunaUseSsl(), PGStorageConfigParam.SSL_CERTIFICAT_FILE, this.getObstunaSslCert(), CommonStorageConfigParam.CAN_MIGRATE, this.isCanMigrateObstuna()});
        return result;
    }

    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = Util.findJaxxPropertyChangeListener((String[])DEFAULT_JAXX_PCS, (PropertyChangeListener[])this.getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("before remove : " + this.getPropertyChangeListeners().length));
            log.debug((Object)("toRemove : " + toRemove.length));
        }
        for (PropertyChangeListener listener : toRemove) {
            this.removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("after remove : " + this.getPropertyChangeListeners().length));
        }
    }

    static {
        DEFAULT_JAXX_PCS = new String[]{PROPERTY_SHOW_NUMBER_EDITOR_BUTTON, PROPERTY_AUTO_POPUP_NUMBER_EDITOR, PROPERTY_FULL_SCREEN, PROPERTY_LOCALE};
    }

    public static enum Action {
        HELP(I18n._((String)"observe.action.commandline.help"), ObserveAction.class.getName() + "#help", "-h", "--help"),
        HELP_UI(I18n._((String)"observe.action.commandline.help.ui"), ObserveAction.class.getName() + "#helpUI", "--help-ui"),
        NO_MAIN_UI(I18n._((String)"observe.action.commandline.disable.main.ui"), ObserveAction.class.getName() + "#disableMainUI", "-n", "--no-main"),
        CONFIGURE_UI(I18n._((String)"observe.action.commandline.configure.ui"), ObserveAction.class.getName() + "#configure", "--configure"),
        SYNCHRO_UI(I18n._((String)"observe.action.commandline.launch.synchro"), ObserveAction.class.getName() + "#launchSynchroUI", "-s", "--synchro-ui"),
        VALIDATE_DATA_UI(I18n._((String)"observe.action.commandline.launch.validation"), ObserveAction.class.getName() + "#launchValidationUI", "-v", "--validation-ui"),
        CHANGE_STORAGE_UI(I18n._((String)"observe.action.commandline.change.storage"), ObserveAction.class.getName() + "#launchStorageUI", "-c", "--change-storage-ui"),
        CREATE_PG(I18n._((String)"observe.action.commandline.create.pg"), ObserveAction.class.getName() + "#launchCreatePG", "--create-pg"),
        UPDATE_PG(I18n._((String)"observe.action.commandline.update.pg"), ObserveAction.class.getName() + "#launchUpdatePG", "--update-pg"),
        UPDATE_PG_UI(I18n._((String)"observe.action.commandline.update.pg.ui"), ObserveAction.class.getName() + "#launchUpdatePGWithUI", "--update-pg-ui");

        public String description;
        public String action;
        public String[] aliases;

        private Action(String description, String action, String ... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }
    }

    public static enum Step {
        AfterInit,
        BeforeExit;

    }

    public static enum Option implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"observe.config.configFileName.description"), "observe-config", String.class, true, true),
        DB_DIRECTORY("db.directory", I18n._((String)"observe.config.defaultLocalDbDirectory.description"), ObserveConfig.getObserveUserDirectory() + File.separator + "db", File.class, false, false),
        INITIAL_DB_DUMP("initial.db.dump", I18n._((String)"observe.config.defaultInitialDbDump.description"), ObserveConfig.getObserveUserDirectory() + File.separator + "initial-database.sql.gz", File.class, false, false),
        BACKUP_DIRECTORY("backup.directory", I18n._((String)"observe.config.defaultBackupDirectory.description"), ObserveConfig.getObserveUserDirectory() + File.separator + "backup", File.class, false, false),
        TMP_DIRECTORY("tmp.directory", I18n._((String)"observe.config.defaultTmpDirectory.description"), ObserveConfig.getObserveUserDirectory() + File.separator + "tmp", File.class, false, false),
        H2_LOGIN("h2.username", I18n._((String)"observe.config.h2.login.description"), "sa", String.class, true, true),
        H2_PASSWORD("h2.password", I18n._((String)"observe.config.h2.password.description"), "sa", String.class, true, true),
        H2_CAN_MIGRATE("h2.canMigrate", I18n._((String)"observe.config.h2.can.migrate.description"), "true", Boolean.class, false, false),
        OBSTUNA_URL("obstuna.url", I18n._((String)"observe.config.obstuna.url.description"), "jdbc:postgresql:///obstuna", String.class, false, false),
        OBSTUNA_LOGIN("obstuna.username", I18n._((String)"observe.config.obstuna.login.description"), "utilisateur", String.class, false, false),
        OBSTUNA_PASSWORD("obstuna.password", I18n._((String)"observe.config.obstuna.password.description"), "", String.class, true, false),
        OBSTUNA_USE_SSL_CERT("obstuna.useSsl", I18n._((String)"observe.config.obstuna.useSssl.description"), Boolean.FALSE + "", Boolean.class, false, false),
        OBSTUNA_SSL_CERTIFICAT_FILE("obstuna.sslCertificatFile", I18n._((String)"observe.config.obstuna.sslCertificatFile.description"), ObserveConfig.getObserveUserDirectory() + File.separator + "cacert.jks", File.class, false, false),
        OBSTUNA_CAN_MIGRATE("pg.canMigrate", I18n._((String)"observe.config.pg.can.migrate.description"), "false", Boolean.class, false, false),
        DEFAULT_DB_MODE("defaultDbMode", I18n._((String)"observe.config.defaultDbMode"), DbMode.LOCAL.name(), DbMode.class, false, false),
        DEFAULT_CREATION_MODE("defaultCreationMode", I18n._((String)"observe.config.defaultCreationMode"), CreationMode.IMPORT_INTERNAL_DUMP.name(), CreationMode.class, false, false),
        CAN_GENERATE_EMPTY_DB("ui.canGenerateEmptyDb", I18n._((String)"observe.config.ui.canGenerateEmtpyDb"), "false", Boolean.class, false, false),
        STORE_REMOTE_STORAGE("ui.storeRemoteStorage", I18n._((String)"observe.config.ui.storeRemoteStorage"), "true", Boolean.class, false, false),
        DEFAULT_GPS_MAX_DELAY("defaultGpsMaxDelay", I18n._((String)"observe.config.defaultGpsMaxDelay"), "60", Integer.class, false, false),
        DEFAULT_GPS_MAX_SPEED("defaultGpsMaxSpeed", I18n._((String)"observe.config.defaultGpsMaxSpeed"), "25.0f", Float.class, false, false),
        CHANGE_SYNCHRO_SRC("ui.changeSynchroSrc", I18n._((String)"observe.config.ui.changeSynchroSrc"), "false", Boolean.class, false, false),
        DISPLAY_SYNCHRO_RESUME("ui.displaySynchroResume", I18n._((String)"observe.config.ui.displaySynchroResume"), "true", Boolean.class, false, false),
        SHOW_NUMBER_EDITOR_BUTTON("ui.showNumberEditorButton", I18n._((String)"observe.config.ui.showNumberEditorButton"), "true", Boolean.class, false, false),
        AUTO_POPUP_NUMBER_EDITOR("ui.autoPopupNumberEditor", I18n._((String)"observe.config.ui.autoPopupNumberEditor"), "false", Boolean.class, false, false),
        FULL_SCREEN("ui.fullScreen", I18n._((String)"observe.config.ui.fullscreen"), "false", Boolean.class, false, false),
        LOCALE("ui.locale", I18n._((String)"observe.config.ui.locale"), Locale.FRANCE.toString(), Locale.class, false, false);

        public final String key;
        public final String description;
        public final String defaultValue;
        public final Class<?> type;
        public final boolean _transient;
        public final boolean _final;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean _transient, boolean _final) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this._final = _final;
            this._transient = _transient;
        }

        public boolean isFinal() {
            return this._final;
        }

        public boolean isTransient() {
            return this._transient;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

