/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.converter;

import com.google.gson.Gson;
import fr.ird.observe.services.dto.ObserveDto;
import org.apache.commons.beanutils.converters.AbstractConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveDtoConverter
extends AbstractConverter {
    private static final Log log = LogFactory.getLog(ObserveDtoConverter.class);
    protected final Gson gson;

    public ObserveDtoConverter(Gson gson) {
        this.gson = gson;
    }

    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        Object observeDto;
        if (ObserveDto.class.isAssignableFrom(type)) {
            String gsonContent = value.toString();
            observeDto = this.gson.fromJson(gsonContent, type);
            if (log.isInfoEnabled()) {
                log.info((Object)("convert observeDto: " + observeDto));
            }
        } else {
            throw this.conversionException(type, value);
        }
        return (T)observeDto;
    }

    protected Class<?> getDefaultType() {
        return ObserveDto.class;
    }
}

