/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.controller.v1;

import com.google.common.base.Preconditions;
import fr.ird.observe.application.web.controller.v1.ObserveServiceControllerSupport;
import fr.ird.observe.application.web.request.ObserveWebRequestContext;
import fr.ird.observe.application.web.security.ObserveWebSecurityApplicationContext;
import fr.ird.observe.services.configuration.ObserveDataSourceConfiguration;
import fr.ird.observe.services.configuration.ObserveDataSourceConfigurationAndConnection;
import fr.ird.observe.services.configuration.ObserveDataSourceConnection;
import fr.ird.observe.services.configuration.ObserveDataSourceInformation;
import fr.ird.observe.services.configuration.rest.ObserveDataSourceConfigurationRest;
import fr.ird.observe.services.configuration.rest.ObserveDataSourceConnectionRest;
import fr.ird.observe.services.dto.DataSourceCreateConfigurationDto;
import fr.ird.observe.services.dto.DataSourceCreateWithNoReferentialImportException;
import fr.ird.observe.services.dto.IncompatibleDataSourceCreateConfigurationException;
import fr.ird.observe.services.dto.ObserveDbUserDto;
import fr.ird.observe.services.dto.referential.ReferentialDto;
import fr.ird.observe.services.service.BabModelVersionException;
import fr.ird.observe.services.service.DataSourceService;
import fr.ird.observe.services.service.DatabaseConnexionNotAuthorizedException;
import fr.ird.observe.services.service.DatabaseDestroyNotAuthorizedException;
import fr.ird.observe.services.service.DatabaseNotFoundException;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceServiceController
extends ObserveServiceControllerSupport<DataSourceService>
implements DataSourceService {
    private static final Log log = LogFactory.getLog(DataSourceServiceController.class);

    public DataSourceServiceController() {
        super(DataSourceService.class);
    }

    public ObserveDataSourceInformation checkCanConnect(ObserveDataSourceConfiguration dataSourceConfiguration) throws DatabaseConnexionNotAuthorizedException, DatabaseNotFoundException {
        ObserveDataSourceConfiguration dataSourceConfigurationTopia = this.getTopiaDataSourceConfiguration(dataSourceConfiguration);
        return ((DataSourceService)this.getAnonymousService(dataSourceConfigurationTopia)).checkCanConnect(dataSourceConfigurationTopia);
    }

    public ObserveDataSourceConnectionRest create(ObserveDataSourceConfiguration dataSourceConfiguration, DataSourceCreateConfigurationDto dataSourceCreateConfiguration) throws IncompatibleDataSourceCreateConfigurationException, DataSourceCreateWithNoReferentialImportException, DatabaseNotFoundException, DatabaseConnexionNotAuthorizedException, BabModelVersionException {
        ObserveDataSourceConfiguration dataSourceConfigurationTopia = this.getTopiaDataSourceConfiguration(dataSourceConfiguration);
        ObserveDataSourceConnection observeDataSourceConnection = ((DataSourceService)this.getAnonymousService(dataSourceConfigurationTopia)).create(dataSourceConfigurationTopia, dataSourceCreateConfiguration);
        String authenticationToken = this.registerDataSourceConfiguration(dataSourceConfigurationTopia, observeDataSourceConnection);
        return this.createDataSourceConnection(observeDataSourceConnection, authenticationToken);
    }

    public ObserveDataSourceConnectionRest open(ObserveDataSourceConfiguration dataSourceConfiguration) throws DatabaseNotFoundException, DatabaseConnexionNotAuthorizedException, BabModelVersionException {
        ObserveDataSourceConfiguration dataSourceConfigurationTopia = this.getTopiaDataSourceConfiguration(dataSourceConfiguration);
        ObserveDataSourceConnection observeDataSourceConnection = ((DataSourceService)this.getAnonymousService(dataSourceConfigurationTopia)).open(dataSourceConfigurationTopia);
        String authenticationToken = this.registerDataSourceConfiguration(dataSourceConfigurationTopia, observeDataSourceConnection);
        return this.createDataSourceConnection(observeDataSourceConnection, authenticationToken);
    }

    public void close() {
        ((DataSourceService)this.getAuthenticatedService()).close();
        ObserveWebRequestContext requestContext = this.getRequestContext();
        String authenticationToken = requestContext.getAuthenticationToken();
        this.getSecurityApplicationContext().invalidateAuthenticationToken(authenticationToken);
        if (log.isInfoEnabled()) {
            log.info((Object)("Invalidate authenticationToken: " + authenticationToken));
        }
    }

    public void destroy() throws DatabaseDestroyNotAuthorizedException {
        ((DataSourceService)this.getAuthenticatedService()).destroy();
    }

    public void backup(File backupFile) {
    }

    public Set<ObserveDbUserDto> getUsers(ObserveDataSourceConfiguration dataSourceConfiguration) {
        ObserveDataSourceConfiguration dataSourceConfigurationTopia = this.getTopiaDataSourceConfiguration(dataSourceConfiguration);
        return ((DataSourceService)this.getAnonymousService(dataSourceConfigurationTopia)).getUsers(dataSourceConfigurationTopia);
    }

    public void applySecurity(ObserveDataSourceConfiguration dataSourceConfiguration, Set<ObserveDbUserDto> users) {
        ObserveDataSourceConfiguration dataSourceConfigurationTopia = this.getTopiaDataSourceConfiguration(dataSourceConfiguration);
        ((DataSourceService)this.getAnonymousService(dataSourceConfigurationTopia)).applySecurity(dataSourceConfigurationTopia, users);
    }

    public void migrateData(ObserveDataSourceConfiguration dataSourceConfiguration) {
        ObserveDataSourceConfiguration dataSourceConfigurationTopia = this.getTopiaDataSourceConfiguration(dataSourceConfiguration);
        ((DataSourceService)this.getAnonymousService(dataSourceConfigurationTopia)).migrateData(dataSourceConfiguration);
    }

    public Set<Class<? extends ReferentialDto>> getReferentialTypesInShell() {
        return ((DataSourceService)this.getAuthenticatedService()).getReferentialTypesInShell();
    }

    protected ObserveDataSourceConfiguration getTopiaDataSourceConfiguration(ObserveDataSourceConfiguration dataSourceConfigurationFromRequest) {
        Preconditions.checkArgument((boolean)(dataSourceConfigurationFromRequest instanceof ObserveDataSourceConfigurationRest));
        ObserveDataSourceConfigurationRest dataSourceConfigurationRest = (ObserveDataSourceConfigurationRest)dataSourceConfigurationFromRequest;
        String login = dataSourceConfigurationRest.getLogin();
        String password = new String(dataSourceConfigurationRest.getPassword());
        Optional optionalDatabaseName = dataSourceConfigurationRest.getOptionalDatabaseName();
        ObserveWebSecurityApplicationContext securityApplicationContext = this.getSecurityApplicationContext();
        return securityApplicationContext.getDataSourceConfiguration(login, password, optionalDatabaseName);
    }

    protected String registerDataSourceConfiguration(ObserveDataSourceConfiguration dataSourceConfiguration, ObserveDataSourceConnection dataSourceConnection) {
        ObserveDataSourceConfigurationAndConnection configurationAndConnection = new ObserveDataSourceConfigurationAndConnection(dataSourceConfiguration, dataSourceConnection);
        return this.getSecurityApplicationContext().registerDataSourceConfiguration(configurationAndConnection);
    }

    protected ObserveDataSourceConnectionRest createDataSourceConnection(ObserveDataSourceConnection observeDataSourceConnection, String authenticationToken) {
        return new ObserveDataSourceConnectionRest(this.getApplicationConfiguration().getApiUrl(), authenticationToken, observeDataSourceConnection.canReadReferential(), observeDataSourceConnection.canWriteReferential(), observeDataSourceConnection.canReadData(), observeDataSourceConnection.canWriteData(), observeDataSourceConnection.getVersion());
    }
}

