/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.msaccess.importer;

import fr.ird.msaccess.importer.AbstractAccessEntityMeta;
import fr.ird.msaccess.importer.AccessEntity;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public abstract class AccessEntityVisitor<T extends TopiaEntityEnum, M extends AbstractAccessEntityMeta<T>, E extends AccessEntity<T>>
implements EntityVisitor {
    private static final Log log = LogFactory.getLog(AccessEntityVisitor.class);
    protected boolean strictCheck;

    public abstract void onStart(E var1, M var2);

    public abstract void onEnd(E var1, M var2);

    public abstract void onVisitSimpleProperty(String var1, Class<?> var2, E var3, M var4);

    public abstract void onVisitComposition(String var1, Class<?> var2, E var3, M var4);

    public abstract void onVisitReverseAssociation(String var1, E var2, M var3);

    public abstract void onVisitAssociation(String var1, Class<?> var2, E var3, M var4);

    public boolean isStrictCheck() {
        return this.strictCheck;
    }

    public void setStrictCheck(boolean strictCheck) {
        this.strictCheck = strictCheck;
    }

    public final void start(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)entity);
        }
        AccessEntity e = (AccessEntity)entity;
        AbstractAccessEntityMeta meta = e.getMeta();
        this.onStart(e, meta);
    }

    public final void end(TopiaEntity entity) {
        if (log.isDebugEnabled()) {
            log.debug((Object)entity);
        }
        AccessEntity e = (AccessEntity)entity;
        AbstractAccessEntityMeta meta = e.getMeta();
        this.onEnd(e, meta);
    }

    public final void visit(TopiaEntity entity, String propertyName, Class<?> type, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)entity);
        }
        AccessEntity current = (AccessEntity)entity;
        AbstractAccessEntityMeta meta = current.getMeta();
        if (TopiaEntity.class.isAssignableFrom(type)) {
            if (meta.containsReverseAssociation(propertyName)) {
                this.onVisitReverseAssociation(propertyName, current, meta);
            } else {
                boolean safe = this.checkComposition(propertyName, meta);
                if (safe) {
                    this.onVisitComposition(propertyName, type, current, meta);
                }
            }
        } else {
            boolean safe = this.checkSimpleProperty(propertyName, meta);
            if (safe) {
                this.onVisitSimpleProperty(propertyName, type, current, meta);
            }
        }
    }

    public final void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
        AccessEntity current;
        AbstractAccessEntityMeta meta;
        boolean safe;
        if (!TopiaEntity.class.isAssignableFrom(type)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)entity);
        }
        if (safe = this.checkAssociation(propertyName, meta = (current = (AccessEntity)entity).getMeta())) {
            this.onVisitAssociation(propertyName, type, current, meta);
        }
    }

    public final void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
    }

    public Serializable getProperty(String propertyName, M meta, Map<String, Object> row) {
        String colName = ((AbstractAccessEntityMeta)meta).getPropertyColumnName(propertyName);
        Serializable newValue = this.getProperty(colName, row);
        return newValue;
    }

    public Serializable getProperty(String colName, Map<String, Object> row) {
        Serializable newValue = (Serializable)row.get(colName);
        if (newValue == null) {
            return null;
        }
        if (newValue instanceof Short) {
            newValue = Integer.valueOf(newValue + "");
        }
        return newValue;
    }

    protected final <C extends TopiaEntity> C getEntityForPKey(Object[] pkey, Collection<C> entities) {
        if (entities == null) {
            return null;
        }
        TopiaEntity result = null;
        for (TopiaEntity entity : entities) {
            AccessEntity accessEntity = (AccessEntity)entity;
            Object[] entityPKey = accessEntity.getPkey();
            if (!Arrays.equals(entityPKey, pkey)) continue;
            result = entity;
            break;
        }
        return (C)result;
    }

    protected boolean checkSimpleProperty(String propertyName, M meta) {
        if (!((AbstractAccessEntityMeta)meta).containsProperty(propertyName)) {
            String message = "Skip simpleProperty [" + ((AbstractAccessEntityMeta)meta).getType() + " - " + propertyName + "], not supported (should not be visited...)";
            if (this.strictCheck) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return false;
        }
        return true;
    }

    protected boolean checkComposition(String propertyName, M meta) {
        if (!((AbstractAccessEntityMeta)meta).containsProperty(propertyName)) {
            String message = "Skip composition [" + ((AbstractAccessEntityMeta)meta).getType() + " - " + propertyName + "], not supported (should not be visited...)";
            if (this.strictCheck) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return false;
        }
        return true;
    }

    protected boolean checkReverseAssociation(String propertyName, M meta) {
        if (!((AbstractAccessEntityMeta)meta).containsReverseAssociation(propertyName)) {
            String message = "Skip reverse association [" + ((AbstractAccessEntityMeta)meta).getType() + " - " + propertyName + "], not supported (should not be visited...)";
            if (this.strictCheck) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return false;
        }
        return true;
    }

    protected boolean checkAssociation(String propertyName, M meta) {
        if (!((AbstractAccessEntityMeta)meta).containsAssociation(propertyName)) {
            String message = "Skip association [" + ((AbstractAccessEntityMeta)meta).getType() + " - " + propertyName + "], not supported (should not be visited...)";
            if (this.strictCheck) {
                throw new IllegalStateException(message);
            }
            log.warn((Object)message);
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }
}

