/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.msaccess.importer;

import fr.ird.msaccess.importer.AbstractAccessEntityMeta;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperator;

public abstract class AbstractAccessEntityProxyHandler<T extends TopiaEntityEnum>
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(AbstractAccessEntityProxyHandler.class);
    protected AbstractAccessEntityMeta<T> meta;
    protected int rowId;
    protected Object[] pkey;
    protected final TopiaEntity entity;
    protected final EntityOperator<TopiaEntity> operator;

    public AbstractAccessEntityProxyHandler(AbstractAccessEntityMeta<T> meta, int rowId, Object[] pkey) throws Exception {
        this.meta = meta;
        this.rowId = rowId;
        this.pkey = pkey;
        T type = meta.getType();
        this.operator = this.getOperator((TopiaEntityEnum)type);
        this.entity = (TopiaEntity)type.getImplementation().newInstance();
    }

    protected abstract EntityOperator<TopiaEntity> getOperator(TopiaEntityEnum var1);

    protected abstract Object getPropertyValue(Class<?> var1, String var2, Object var3);

    protected abstract Object getPropertyValueFromMetaType(TopiaEntityEnum var1, String var2, Object var3);

    public TopiaEntity getEntity() {
        return this.entity;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("getPkey".equals(methodName) && args == null) {
            return this.pkey;
        }
        if ("getRowId".equals(methodName) && args == null) {
            return this.rowId;
        }
        if ("getMeta".equals(methodName) && args == null) {
            return this.meta;
        }
        if ("getTopiaEntity".equals(methodName) && args == null) {
            return this.entity;
        }
        if ("setProperty".equals(methodName) && args != null && args.length == 2) {
            String propertyName = (String)args[0];
            Object value = args[1];
            this.setProperty(propertyName, value);
            return null;
        }
        if ("getProperty".equals(methodName) && args != null && args.length == 1) {
            String propertyName = (String)args[0];
            return this.getProperty(propertyName);
        }
        if ("addAssociationProperty".equals(methodName) && args != null && args.length == 2) {
            String propertyName = (String)args[0];
            Object value = args[1];
            this.addListProperty(propertyName, value);
            return null;
        }
        if ("setAssociationProperty".equals(methodName) && args != null && args.length == 2) {
            String propertyName = (String)args[0];
            Collection value = (Collection)args[1];
            this.setListProperty(propertyName, value);
            return null;
        }
        if ("accept".equals(methodName) && args != null && args.length == 1 && args[0] instanceof EntityVisitor) {
            EntityVisitor visitor = (EntityVisitor)args[0];
            this.accept((TopiaEntity)proxy, visitor);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will invoke on entity " + method));
        }
        return method.invoke((Object)this.entity, args);
    }

    public void setProperty(String propertyName, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (!(value instanceof TopiaEntity)) {
                AbstractAccessEntityMeta.PropertyMapping mapping = this.meta.getPropertyMapping(propertyName);
                Class<?> type = mapping.getType();
                value = this.getPropertyValue(type, propertyName, value);
                T entityType = this.meta.getType();
                value = this.getPropertyValueFromMetaType((TopiaEntityEnum)entityType, propertyName, value);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Will set [" + propertyName + ":" + value + "] to " + this.entity));
            }
            this.operator.set(propertyName, this.entity, value);
        }
        catch (RuntimeException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Could not set [" + propertyName + ":" + value + "] on " + this.entity), (Throwable)e);
            }
            throw e;
        }
    }

    public Object getProperty(String propertyName) {
        Object o = this.operator.get(propertyName, this.entity);
        return o;
    }

    public void addListProperty(String name, Object value) {
        if (this.entity == null) {
            throw new IllegalStateException("Can not add any association while entity [" + this + "] is not created...");
        }
        this.operator.addChild(name, this.entity, value);
    }

    public void setListProperty(String name, Collection<?> value) {
        if (this.entity == null) {
            throw new IllegalStateException("Can not add any association while entity [" + this + "] is not created...");
        }
        this.operator.set(name, this.entity, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(TopiaEntity entity, EntityVisitor visitor) throws TopiaException {
        visitor.start(entity);
        try {
            for (AbstractAccessEntityMeta.PropertyMapping propertyMapping : this.meta.getPropertyMapping()) {
                visitor.visit(entity, propertyMapping.getProperty(), propertyMapping.getType(), null);
            }
            for (Serializable serializable : this.meta.getReverseAssociationMapping()) {
                visitor.visit(entity, ((AbstractAccessEntityMeta.AssociationMapping)serializable).getProperty(), ((AbstractAccessEntityMeta.AssociationMapping)serializable).getType(), null);
            }
            for (Serializable serializable : this.meta.getAssocationMapping()) {
                visitor.visit(entity, ((AbstractAccessEntityMeta.AssociationMapping)serializable).getProperty(), Collection.class, ((AbstractAccessEntityMeta.AssociationMapping)serializable).getType(), null);
            }
        }
        finally {
            visitor.end(entity);
        }
    }
}

