/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompServiceAction.java 270 2012-03-19 15:30:20Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompServiceAction.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.entities.WikittyGroup;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserImpl;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.query.WikittyQueryResult;
import org.nuiton.wikitty.services.WikittySecurityUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * User: couteau
 * Date: 01/02/11
 */
public class RefcompServiceAction {

    /**
     * log.
     */
    private static final Log log = LogFactory.getLog(RefcompServiceAction.class);

    /**
     * Reload solr index.
     */
    public static void reIndexSolr() {

        if (log.isInfoEnabled()) {
            log.info("Starting reIndex solr");
        }

        long startingTime = System.nanoTime();

        WikittyService service = ServiceFactory.getWikittyService();

        RefcompConfiguration config = ServiceFactory.getConfig();

        StorageService storageService = new StorageServiceImpl(new WikittyClient(config.applicationConfig), config);
        storageService.adminCreationIfDoNotExist();

        String token = service.login(config.getAdminLogin(),config.getAdminPassword());

        service.syncSearchEngine(token);

        if (log.isInfoEnabled()) {
            log.info("ReIndex solr is finished in " +
                    StringUtil.convertTime(startingTime, System.nanoTime()));
        }
        System.exit(0);
    }

    /**
     * Clean admin and keep only admin data from configuration.
     */
    public static void cleanAdmin() {

        if (log.isInfoEnabled()) {
            log.info("Starting cleaning admin data");
        }

        long startingTime = System.nanoTime();

        //Get WikittyProxy without security
        RefcompConfiguration config = ServiceFactory.getConfig();
        config.applicationConfig.setOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.key,
                "org.nuiton.wikitty.services.WikittyServiceStorage");
        //WikittyService service =  WikittyServiceFactory.buildWikittyService(config.applicationConfig);
        WikittyClient wikittyClient = new WikittyClient(config.applicationConfig);

        //Get all the app admin groups
        WikittyQuery search = new WikittyQueryMaker()
                .eq(WikittyGroup.FQ_FIELD_WIKITTYGROUP_NAME,
                    WikittySecurityUtil.WIKITTY_APPADMIN_GROUP_NAME)
                .end();
        WikittyQueryResult<WikittyGroup> adminGroupsResult =
                wikittyClient.findAllByQuery(WikittyGroup.class, search);
        List<WikittyGroup> adminGroups = adminGroupsResult.getAll();

        //Store all the app admin groups members
        List<String> adminGroupsMembers = new ArrayList<String>();
        for (WikittyGroup adminGroup : adminGroups) {
            adminGroupsMembers.addAll(adminGroup.getMembers());
        }

        //Get all the admins (that got the login in config....)
        WikittyQuery adminSearch = new WikittyQueryMaker()
                .eq(WikittyUser.FQ_FIELD_WIKITTYUSER_LOGIN,
                        config.getAdminLogin())
                .end();
        WikittyQueryResult<WikittyUser> adminResult =
                wikittyClient.findAllByQuery(WikittyUser.class, adminSearch);
        List<WikittyUser> admins = adminResult.getAll();

        //Remove the admins from app admin groups members
        adminGroupsMembers.removeAll(admins);

        //Create the new admin
        WikittyUser admin = new WikittyUserImpl();
        admin.setLogin(config.getAdminLogin());
        admin.setPassword(config.getAdminPassword());

        //Create app admin group and add the new admin to it
        WikittyGroup adminGroup = WikittySecurityUtil.createAppAdminGroup(admin);

        //Add old admins to the app admin group
        //adminGroup.addAllMembers(new HashSet<String>(adminGroupsMembers));

        //Get Private group
        WikittyQuery privateSearch = new WikittyQueryMaker()
                .eq(WikittyGroup.FQ_FIELD_WIKITTYGROUP_NAME,
                        WikittySecurityUtil.WIKITTY_APPADMIN_GROUP_NAME)
                .end();
        WikittyGroup privateGroup =
                wikittyClient.findByQuery(WikittyGroup.class, privateSearch);

        //Remove old admins from private group
        for (WikittyUser adminUser : admins) {
            privateGroup.removeMembers(adminUser.getWikittyId());
        }

        //Add new admin to private group
        privateGroup.addMembers(admin.getWikittyId());

        //Store the admin and the groups (admin and private)
        wikittyClient.store(admin, adminGroup, privateGroup);

        //Delete all the app admin groups
        wikittyClient.delete(adminGroups);

        //Delete the admins
        wikittyClient.delete(admins);

        //Finished
        if (log.isInfoEnabled()) {
            log.info("Cleaning finished in " +
                    StringUtil.convertTime(startingTime, System.nanoTime()));
        }
        System.exit(0);

    }
}
