/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.FieldFacetStats;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StatsValuesFactory;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.UnInvertedField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleStats {
    protected DocSet docs;
    protected SolrParams params;
    protected SolrIndexSearcher searcher;
    protected SolrQueryRequest req;

    public SimpleStats(SolrQueryRequest req, DocSet docs, SolrParams params) {
        this.req = req;
        this.searcher = req.getSearcher();
        this.docs = docs;
        this.params = params;
    }

    public NamedList<Object> getStatsCounts() throws IOException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        res.add("stats_fields", (Object)this.getStatsFields());
        return res;
    }

    public NamedList getStatsFields() throws IOException {
        SimpleOrderedMap res = new SimpleOrderedMap();
        String[] statsFs = this.params.getParams("stats.field");
        boolean isShard = this.params.getBool("isShard", false);
        if (null != statsFs) {
            for (String f : statsFs) {
                NamedList<?> stv;
                String[] facets = this.params.getFieldParams(f, "stats.facet");
                if (facets == null) {
                    facets = new String[]{};
                }
                SchemaField sf = this.searcher.getSchema().getField(f);
                FieldType ft = sf.getType();
                String prefix = TrieField.getMainValuePrefix(ft);
                if (sf.multiValued() || ft.multiValuedFieldCache() || prefix != null) {
                    UnInvertedField uif = UnInvertedField.getUnInvertedField(f, this.searcher);
                    stv = uif.getStats(this.searcher, this.docs, facets).getStatsValues();
                } else {
                    stv = this.getFieldCacheStats(f, facets);
                }
                if (isShard || (Long)stv.get("count") > 0L) {
                    res.add(f, stv);
                    continue;
                }
                res.add(f, null);
            }
        }
        return res;
    }

    public NamedList getFieldCacheStats(String fieldName, String[] facet) {
        FieldCache.StringIndex si;
        FieldType ft = this.searcher.getSchema().getFieldType(fieldName);
        try {
            si = FieldCache.DEFAULT.getStringIndex((IndexReader)this.searcher.getReader(), fieldName);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to open field cache for: " + fieldName, e);
        }
        StatsValues allstats = StatsValuesFactory.createStatsValues(ft);
        int nTerms = si.lookup.length - 1;
        if (nTerms <= 0 || this.docs.size() <= 0) {
            return allstats.getStatsValues();
        }
        ArrayList<FieldFacetStats> facetStats = new ArrayList<FieldFacetStats>();
        for (String facetField : facet) {
            FieldCache.StringIndex facetTermsIndex;
            FieldType facetFieldType = this.searcher.getSchema().getFieldType(facetField);
            if (facetFieldType.isTokenized() || facetFieldType.isMultiValued()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Stats can only facet on single-valued fields, not: " + facetField + "[" + facetFieldType + "]");
            }
            try {
                facetTermsIndex = FieldCache.DEFAULT.getStringIndex((IndexReader)this.searcher.getReader(), facetField);
            }
            catch (IOException e) {
                throw new RuntimeException("failed to open field cache for: " + facetField, e);
            }
            facetStats.add(new FieldFacetStats(facetField, facetTermsIndex, facetFieldType, nTerms, ft));
        }
        DocIterator iter = this.docs.iterator();
        while (iter.hasNext()) {
            String v;
            int docID = iter.nextDoc();
            String raw = si.lookup[si.order[docID]];
            if (raw != null) {
                v = ft.indexedToReadable(raw);
                allstats.accumulate(v);
            } else {
                v = null;
                allstats.missing();
            }
            for (FieldFacetStats f : facetStats) {
                f.facet(docID, v);
            }
        }
        for (FieldFacetStats f : facetStats) {
            allstats.addFacet(f.name, f.facetStatsValues);
        }
        return allstats.getStatsValues();
    }
}

