/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.beans;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;

public class Binder<I, O>
implements Serializable {
    private static final Log log = LogFactory.getLog(Binder.class);
    private static final long serialVersionUID = 1L;
    protected BinderModel<I, O> model;

    public Class<I> getSourceType() {
        return this.getModel().getSourceType();
    }

    public Class<O> getTargetType() {
        return this.getModel().getTargetType();
    }

    public Map<String, Object> obtainProperties(I source, String ... propertyNames) {
        if (source == null) {
            return Collections.emptyMap();
        }
        propertyNames = this.getProperties(propertyNames);
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (String sourceProperty : propertyNames) {
            try {
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                Object read = readMethod.invoke(source, new Object[0]);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                if (readMethod.getReturnType().isPrimitive() && ObjectUtil.getNullValue(readMethod.getReturnType()).equals(read)) {
                    read = null;
                }
                if (read == null) continue;
                if (this.model.containsBinderProperty(sourceProperty)) {
                    read = this.model.containsCollectionProperty(sourceProperty) ? this.bindCollection(sourceProperty, read) : this.bindProperty(sourceProperty, read);
                } else if (this.model.containsCollectionProperty(sourceProperty)) {
                    read = this.getCollectionValue(sourceProperty, read);
                }
                result.put(sourceProperty, read);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public void copy(I source, O target, String ... propertyNames) {
        this.copy(source, target, false, propertyNames);
    }

    public void copyExcluding(I source, O target, String ... propertyNames) {
        this.copy(source, target, true, propertyNames);
    }

    protected void copy(I source, O target, boolean excludeProperties, String ... propertyNames) throws RuntimeException {
        if (target == null) {
            throw new NullPointerException("parameter 'target' can no be null");
        }
        for (String sourceProperty : propertyNames = excludeProperties ? this.getAllPropertiesExclude(propertyNames) : this.getProperties(propertyNames)) {
            String targetProperty = this.model.getTargetProperty(sourceProperty);
            try {
                Object read = null;
                Method readMethod = this.model.getSourceReadMethod(sourceProperty);
                if (source != null) {
                    read = readMethod.invoke(source, new Object[0]);
                }
                if (read == null) {
                    read = ObjectUtil.getNullValue(readMethod.getReturnType());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("property " + sourceProperty + ", type : " + readMethod.getReturnType() + ", value = " + read));
                }
                if (this.model.containsBinderProperty(sourceProperty)) {
                    read = this.model.containsCollectionProperty(sourceProperty) ? this.bindCollection(sourceProperty, read) : this.bindProperty(sourceProperty, read);
                } else if (this.model.containsCollectionProperty(sourceProperty)) {
                    read = this.getCollectionValue(sourceProperty, read);
                }
                this.model.getTargetWriteMethod(targetProperty).invoke(target, read);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not bind property [" + source.getClass().getName() + ":" + sourceProperty + "] to [" + target.getClass().getName() + ":" + targetProperty + "]", e);
            }
        }
    }

    protected BinderModel<I, O> getModel() {
        return this.model;
    }

    protected void setModel(BinderModel<I, O> model) {
        this.model = model;
    }

    protected String[] getProperties(String ... propertyNames) {
        if (propertyNames.length == 0) {
            propertyNames = this.model.getSourceDescriptors();
        } else {
            for (String propertyName : propertyNames) {
                if (this.model.containsSourceProperty(propertyName)) continue;
                throw new IllegalArgumentException("property '" + propertyName + "' is not known by binder");
            }
        }
        return propertyNames;
    }

    protected String[] getAllPropertiesExclude(String ... propertyNameExcludes) {
        List<String> excludes = Arrays.asList(propertyNameExcludes);
        ArrayList<String> results = new ArrayList<String>();
        for (String propertyName : this.model.getSourceDescriptors()) {
            if (excludes.contains(propertyName)) continue;
            results.add(propertyName);
        }
        return results.toArray(new String[results.size()]);
    }

    protected Object getCollectionValue(String sourceProperty, Object readValue) {
        CollectionStrategy strategy = this.model.getCollectionStrategy(sourceProperty);
        Object result = strategy.copy(readValue);
        return result;
    }

    protected Object bindProperty(String sourceProperty, Object read) throws IllegalAccessException, InstantiationException {
        Binder<?, ?> binder = this.model.getBinder(sourceProperty);
        Object result = this.bind(binder, read);
        return result;
    }

    protected Object bindCollection(String sourceProperty, Object read) throws IllegalAccessException, InstantiationException {
        if (read == null) {
            return null;
        }
        Binder<?, ?> binder = this.model.getBinder(sourceProperty);
        AbstractCollection result = read instanceof Set ? new HashSet() : new ArrayList();
        Collection collection = (Collection)read;
        for (Object o : collection) {
            Object r = this.bind(binder, o);
            result.add(r);
        }
        return result;
    }

    protected Object bind(Binder binder, Object read) throws IllegalAccessException, InstantiationException {
        Object result = read.getClass().newInstance();
        binder.copy(read, result, new String[0]);
        return result;
    }

    public static class BinderModel<S, T>
    implements Serializable {
        protected final Class<S> sourceType;
        protected final Class<T> targetType;
        protected final Map<String, PropertyDescriptor> sourceDescriptors;
        protected final Map<String, PropertyDescriptor> targetDescriptors;
        protected final Map<String, String> propertiesMapping;
        protected Map<String, CollectionStrategy> collectionStrategies;
        protected Map<String, Binder<?, ?>> binders;
        private static final long serialVersionUID = 2L;

        public BinderModel(Class<S> sourceType, Class<T> targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
            this.sourceDescriptors = new TreeMap<String, PropertyDescriptor>();
            this.targetDescriptors = new TreeMap<String, PropertyDescriptor>();
            this.propertiesMapping = new TreeMap<String, String>();
            this.collectionStrategies = new TreeMap<String, CollectionStrategy>();
            this.binders = new TreeMap();
        }

        public Class<S> getSourceType() {
            return this.sourceType;
        }

        public Class<T> getTargetType() {
            return this.targetType;
        }

        public String[] getSourceDescriptors() {
            Set<String> universe = this.sourceDescriptors.keySet();
            return universe.toArray(new String[this.sourceDescriptors.size()]);
        }

        public CollectionStrategy getCollectionStrategy(String property) {
            return this.collectionStrategies.get(property);
        }

        public String[] getTargetDescriptors() {
            Set<String> universe = this.targetDescriptors.keySet();
            return universe.toArray(new String[this.targetDescriptors.size()]);
        }

        public String getTargetProperty(String sourceProperty) {
            if (!this.containsSourceProperty(sourceProperty)) {
                return null;
            }
            String dstProperty = this.propertiesMapping.get(sourceProperty);
            return dstProperty;
        }

        public PropertyDescriptor getSourceDescriptor(String sourceProperty) {
            if (!this.containsSourceProperty(sourceProperty)) {
                return null;
            }
            PropertyDescriptor descriptor = this.sourceDescriptors.get(sourceProperty);
            return descriptor;
        }

        public Method getSourceReadMethod(String srcProperty) {
            PropertyDescriptor descriptor = this.getSourceDescriptor(srcProperty);
            Method readMethod = null;
            if (descriptor != null) {
                readMethod = descriptor.getReadMethod();
            }
            return readMethod;
        }

        public Method getSourceWriteMethod(String sourceProperty) {
            PropertyDescriptor descriptor = this.getSourceDescriptor(sourceProperty);
            Method writeMethod = null;
            if (descriptor != null) {
                writeMethod = descriptor.getWriteMethod();
            }
            return writeMethod;
        }

        public PropertyDescriptor getTargetDescriptor(String targetProperty) {
            if (!this.containsTargetProperty(targetProperty)) {
                return null;
            }
            PropertyDescriptor descriptor = this.targetDescriptors.get(targetProperty);
            return descriptor;
        }

        public Method getTargetReadMethod(String targetProperty) {
            PropertyDescriptor descriptor = this.getTargetDescriptor(targetProperty);
            Method readMethod = null;
            if (descriptor != null) {
                readMethod = descriptor.getReadMethod();
            }
            return readMethod;
        }

        public Method getTargetWriteMethod(String targetProperty) {
            PropertyDescriptor descriptor = this.getTargetDescriptor(targetProperty);
            Method writeMethod = null;
            if (descriptor != null) {
                writeMethod = descriptor.getWriteMethod();
            }
            return writeMethod;
        }

        public Class<?> getCollectionType(String sourceProperty) {
            Method method = this.getSourceReadMethod(sourceProperty);
            Class<?> type = method.getReturnType();
            if (Collection.class.isAssignableFrom(type)) {
                return type;
            }
            return null;
        }

        public void addCollectionStrategy(String propertyName, CollectionStrategy strategy) {
            this.collectionStrategies.put(propertyName, strategy);
        }

        public void addBinder(String propertyName, Binder<?, ?> binder) {
            this.binders.put(propertyName, binder);
        }

        protected boolean containsSourceProperty(String sourceProperty) {
            return this.propertiesMapping.containsKey(sourceProperty);
        }

        protected boolean containsTargetProperty(String targetProperty) {
            return this.propertiesMapping.containsValue(targetProperty);
        }

        protected boolean containsCollectionProperty(String propertyName) {
            return this.collectionStrategies.containsKey(propertyName);
        }

        protected boolean containsBinderProperty(String propertyName) {
            return this.binders.containsKey(propertyName);
        }

        protected void addBinding(PropertyDescriptor sourceDescriptor, PropertyDescriptor targetDescriptor) {
            String sourceProperty = sourceDescriptor.getName();
            String targetProperty = targetDescriptor.getName();
            this.sourceDescriptors.put(sourceProperty, sourceDescriptor);
            this.targetDescriptors.put(targetProperty, targetDescriptor);
            this.propertiesMapping.put(sourceProperty, targetProperty);
        }

        protected void removeBinding(String source) {
            String target = this.propertiesMapping.get(source);
            this.sourceDescriptors.remove(source);
            this.targetDescriptors.remove(target);
            this.propertiesMapping.remove(source);
            if (this.containsBinderProperty(source)) {
                this.binders.remove(source);
            }
            if (this.containsCollectionProperty(source)) {
                this.collectionStrategies.remove(source);
            }
        }

        protected Map<String, String> getPropertiesMapping() {
            return this.propertiesMapping;
        }

        public Binder<?, ?> getBinder(String sourceProperty) {
            return this.binders.get(sourceProperty);
        }
    }

    public static enum CollectionStrategy {
        copy{

            @Override
            public Object copy(Object readValue) {
                return readValue;
            }
        }
        ,
        duplicate{

            @Override
            public Object copy(Object readValue) {
                if (readValue instanceof Set) {
                    return new HashSet((Set)readValue);
                }
                if (readValue instanceof Collection) {
                    return new ArrayList((Collection)readValue);
                }
                return readValue;
            }
        };


        public abstract Object copy(Object var1);
    }
}

