/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.BusinessEntityImpl;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeImpl;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.entities.WikittyUserImpl;


public  class AgentSkillHelper {

    /**
     * AgentSkillHelper :
     * utility class all provided methods are accessible the static way
     */

    private AgentSkillHelper() {// empty
}

    /**
     * getComment :
     * @param wikitty 
     * @return String 
     */

    public static String getComment(Wikitty wikitty) {
        String value = wikitty.getFieldAsString(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_COMMENT);
        return value;
}

    /**
     * setComment :
     * @param wikitty 
     * @param comment 
     * @return String 
     */

    public static String setComment(Wikitty wikitty, String comment) {
        String oldValue = getComment(wikitty);
        wikitty.setField(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_COMMENT, comment);
        return oldValue;
}

    /**
     * getNature :
     * @param wikitty 
     * @return String 
     */

    public static String getNature(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_NATURE);
        return value;
}

    /**
     * setNature :
     * @param wikitty 
     * @param nature 
     * @return String 
     */

    public static String setNature(Wikitty wikitty, String nature) {
        String oldValue = getNature(wikitty);
        wikitty.setField(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_NATURE, nature);
        return oldValue;
}

    /**
     * getTechnicalSkill :
     * @param wikitty 
     * @return String 
     */

    public static String getTechnicalSkill(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_TECHNICALSKILL);
        return value;
}

    /**
     * setTechnicalSkill :
     * @param wikitty 
     * @param technicalSkill 
     * @return String 
     */

    public static String setTechnicalSkill(Wikitty wikitty, String technicalSkill) {
        String oldValue = getTechnicalSkill(wikitty);
        wikitty.setField(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_TECHNICALSKILL, technicalSkill);
        return oldValue;
}

    /**
     * getDomainSkill :
     * @param wikitty 
     * @return String 
     */

    public static String getDomainSkill(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_DOMAINSKILL);
        return value;
}

    /**
     * setDomainSkill :
     * @param wikitty 
     * @param domainSkill 
     * @return String 
     */

    public static String setDomainSkill(Wikitty wikitty, String domainSkill) {
        String oldValue = getDomainSkill(wikitty);
        wikitty.setField(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_DOMAINSKILL, domainSkill);
        return oldValue;
}

    /**
     * getFrequency :
     * @param wikitty 
     * @return String 
     */

    public static String getFrequency(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_FREQUENCY);
        return value;
}

    /**
     * setFrequency :
     * @param wikitty 
     * @param frequency 
     * @return String 
     */

    public static String setFrequency(Wikitty wikitty, String frequency) {
        String oldValue = getFrequency(wikitty);
        wikitty.setField(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_FREQUENCY, frequency);
        return oldValue;
}

    /**
     * getAgent :
     * @param wikitty 
     * @return String 
     */

    public static String getAgent(Wikitty wikitty) {
        String value = wikitty.getFieldAsWikitty(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_AGENT);
        return value;
}

    /**
     * setAgent :
     * @param wikitty 
     * @param agent 
     * @return String 
     */

    public static String setAgent(Wikitty wikitty, String agent) {
        String oldValue = getAgent(wikitty);
        wikitty.setField(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_AGENT, agent);
        return oldValue;
}

    /**
     * equals :
     * @param w1 
     * @param w2 
     * @return boolean 
     */

    public static boolean equals(Wikitty w1, Wikitty w2) {
    boolean result = true;

        if (result) {
            Object f1 = w1.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_COMMENT);
            Object f2 = w2.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_COMMENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_NATURE);
            Object f2 = w2.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_NATURE);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_TECHNICALSKILL);
            Object f2 = w2.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_TECHNICALSKILL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_DOMAINSKILL);
            Object f2 = w2.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_DOMAINSKILL);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_FREQUENCY);
            Object f2 = w2.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_FREQUENCY);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

        if (result) {
            Object f1 = w1.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_AGENT);
            Object f2 = w2.getFieldAsObject(AgentSkill.EXT_AGENTSKILL, AgentSkill.FIELD_AGENTSKILL_AGENT);
            result = f1 == f2 || (f1 != null && f1.equals(f2));
        };

    return result;
}

    /**
     * isExtension :
     * @deprecated renamed to keep consistency, use hasExtension instead
     * @param wikitty 
     * @return boolean 
     */

    @Deprecated
    public static boolean isExtension(Wikitty wikitty) {
        return hasExtension(wikitty);
}

    /**
     * hasExtension :
     * check if wikitty has current extension
     * @param wikitty 
     * @return boolean 
     */

    public static boolean hasExtension(Wikitty wikitty) {
        return wikitty.hasExtension(AgentSkill.EXT_AGENTSKILL);
}

    /**
     * addExtension :
     * ajout les extensions static de cette classe au wikitty en argument
     * @param wikitty 
     */

    public static void addExtension(Wikitty wikitty) {
        for (WikittyExtension ext : AgentSkillAbstract.extensions) {
            wikitty.addExtension(ext);
        }
}


} //AgentSkillHelper
