/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryGearService;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporaryActionSupport;
import java.io.File;
import org.nuiton.i18n.I18n;

public class ImportTemporaryGearAction
extends ImportTemporaryActionSupport<Gear> {
    public ImportTemporaryGearAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler);
    }

    @Override
    protected File chooseImportFile() {
        return this.chooseFile(I18n.t((String)"tutti.manageTemporaryReferential.title.choose.importTemporaryGearFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
    }

    @Override
    protected ReferentialImportResult<Gear> doImport(File file) {
        ReferentialTemporaryGearService service = this.getContext().getReferentialTemporaryGearService();
        return service.importTemporaryGear(file);
    }

    @Override
    protected void postSuccessAction(File file, ReferentialImportResult<Gear> result) {
        int nbRef = ((ManageTemporaryReferentialUIModel)this.getModel()).getNbTemporaryGears();
        ((ManageTemporaryReferentialUIModel)this.getModel()).setNbTemporaryGears(nbRef + result.getNbRefAdded() - result.getNbRefDeleted());
        this.getDataContext().resetGears();
        this.reloadCruise();
        this.reloadFishingOperation();
        ((ManageTemporaryReferentialUIHandler)this.getHandler()).resetComboBoxAction(((ManageTemporaryReferentialUI)this.getUI()).getGearActionComboBox());
        String title = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import.dialog.title", (Object[])new Object[0]);
        String message = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import.dialog.message", (Object[])new Object[]{result.getNbRefAdded(), result.getNbRefUpdated(), result.getNbRefDeleted()});
        this.displayInfoMessage(title, message);
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialGearFile.import.success", (Object[])new Object[]{file}));
    }
}

