/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveObservationAction
extends SimpleActionSupport<SpeciesFrequencyUI> {
    public RemoveObservationAction(SpeciesFrequencyUI speciesFrequencyUI) {
        super(speciesFrequencyUI, false);
    }

    @Override
    protected void onActionPerformed(SpeciesFrequencyUI ui) {
        JXTable obsTable = ui.getObsTable();
        IndividualObservationBatchTableModel obsTableModel = (IndividualObservationBatchTableModel)((Object)obsTable.getModel());
        int[] selectedRowIndexes = obsTable.getSelectedRows();
        HashSet<IndividualObservationBatchRowModel> rowsToDelete = new HashSet<IndividualObservationBatchRowModel>();
        for (int selectedRowIndex : selectedRowIndexes) {
            rowsToDelete.add((IndividualObservationBatchRowModel)obsTableModel.getRows().get(selectedRowIndex));
        }
        String message = rowsToDelete.size() == 1 ? I18n.t((String)"tutti.editSpeciesFrequencies.action.removeObservation.confirm.message", (Object[])new Object[0]) : I18n.t((String)"tutti.editSpeciesFrequencies.action.removeObservations.confirm.message", (Object[])new Object[]{rowsToDelete.size()});
        int answer = JOptionPane.showConfirmDialog(ui, message, I18n.t((String)"tutti.editSpeciesFrequencies.action.removeObservations.confirm.title", (Object[])new Object[0]), 0);
        if (answer == 0) {
            SpeciesFrequencyUIModel model = ui.getModel();
            SpeciesFrequencyUIHandler handler = ui.getHandler();
            SpeciesFrequencyTableModel frequencyTableModel = handler.getTableModel();
            rowsToDelete.stream().filter(IndividualObservationBatchRowModel::withSize).forEach(row -> {
                boolean removeSize;
                boolean removeWeight = model.isCopyIndividualObservationAll() && row.withWeight();
                boolean bl = removeSize = removeWeight || model.isCopyIndividualObservationSize();
                if (removeWeight) {
                    float weightToRemove = frequencyTableModel.convertWeightFromIndividualObservation(row.getWeight().floatValue()).floatValue();
                    frequencyTableModel.removeWeightToFrequencyRow(row.getSize().floatValue(), weightToRemove);
                }
                if (removeSize) {
                    frequencyTableModel.decrementFrequencyRowsNumbers(row.getSize().floatValue());
                }
            });
            model.getIndividualObservationModel().removeIndividualObservations(rowsToDelete);
            model.setModify(true);
        }
    }
}

