/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.action;

import java.awt.event.ActionEvent;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationActionException;
import org.nuiton.jaxx.application.swing.action.ApplicationActionSwingWorker;
import org.nuiton.util.TimeLog;

public class ApplicationUIAction<A extends AbstractApplicationAction>
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ApplicationUIAction.class);
    private static final TimeLog TIME_LOG = new TimeLog(ApplicationUIAction.class);
    public static final ExecutorService waitingThread = Executors.newSingleThreadExecutor();
    private static final String LOGIC_ACTION = "logicAction";
    private final Object lock = new Object();
    private boolean wait;
    private long t0;

    public ApplicationUIAction(AbstractButton button, A action) {
        this.putValue(LOGIC_ACTION, action);
        this.setActionKey(action.getClass().getName());
        if (button != null) {
            this.setActionIcon(button.getIcon());
            this.setActionName(button.getText());
            this.setActionDescription(button.getToolTipText());
            this.setActionMnemonic(button.getMnemonic());
        }
    }

    public void launchActionAndWait() {
        this.wait = true;
        this.actionPerformed(null);
        this.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void actionPerformed(ActionEvent event) {
        boolean doAction;
        this.t0 = TimeLog.getTime();
        if (log.isInfoEnabled()) {
            log.info((Object)("Task [" + this.getLogicAction().getClass().getSimpleName() + "] starting"));
        }
        A action = this.getLogicAction();
        ((AbstractApplicationAction)((Object)action)).sendMessage("");
        try {
            doAction = ((AbstractApplicationAction)((Object)action)).prepareAction();
        }
        catch (Exception e) {
            ((AbstractApplicationAction)((Object)action)).releaseAction();
            throw ApplicationActionException.propagateError(action, e);
        }
        if (doAction) {
            final ApplicationActionSwingWorker<A> worker = new ApplicationActionSwingWorker<A>(action);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    worker.updateBusyState(true);
                }
            });
            if (log.isDebugEnabled()) {
                log.debug((Object)("Before execute of action " + action));
            }
            worker.execute();
            waitingThread.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object action = ApplicationUIAction.this.getLogicAction();
                    try {
                        try {
                            worker.get();
                        }
                        catch (ExecutionException e) {
                        }
                        catch (CancellationException e) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("After execute of action " + action + " (worker done? " + worker.isDone() + ")"));
                        }
                        if (worker.isFailed()) {
                            throw ApplicationActionException.propagateError(action, worker.getError());
                        }
                    }
                    finally {
                        ApplicationUIAction.this.unlock();
                    }
                }
            });
        } else {
            try {
                ((AbstractApplicationAction)((Object)action)).releaseAction();
            }
            finally {
                this.unlock();
            }
        }
    }

    public void setActionIcon(Icon actionIcon) {
        this.putValue("SmallIcon", actionIcon);
        this.putValue("SwingLargeIconKey", actionIcon);
    }

    public void setActionKey(String actionKey) {
        this.putValue("ActionCommandKey", actionKey);
    }

    public void setActionName(String actionName) {
        this.putValue("Name", actionName);
    }

    public void setActionDescription(String actionDescription) {
        this.putValue("ShortDescription", actionDescription);
        ((AbstractApplicationAction)((Object)this.getLogicAction())).setActionDescription(actionDescription);
    }

    public void setActionMnemonic(int key) {
        this.putValue("MnemonicKey", key);
    }

    public A getLogicAction() {
        return (A)((Object)((AbstractApplicationAction)((Object)this.getValue(LOGIC_ACTION))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lock() {
        if (this.wait) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw ApplicationActionException.propagateError(this.getLogicAction(), e);
                }
                finally {
                    this.wait = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlock() {
        TIME_LOG.log(this.t0, "Task [" + this.getLogicAction().getClass().getSimpleName() + "] End");
        if (this.wait) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }
}

