
package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractTuttiTabContainerUIHandler.java 1564 2014-01-31 10:56:26Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.4.3/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/AbstractTuttiTabContainerUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.jaxx.application.swing.tab.DelegateTabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;

/**
 * UI containing a tab panel.
 *
 * @param <M> type of the ui model
 * @author kmorin <kmorin@codelutin.com>
 * @since 0.3
 */
public abstract class AbstractTuttiTabContainerUIHandler<M, UI extends TuttiUI<M, ?>> extends AbstractTuttiUIHandler<M, UI> implements TabContainerHandler {

    DelegateTabContainerHandler delegateTabHandler;

    /**
     * Returns the tab handler of the tab i.
     *
     * @param index the index of the tab
     * @return the tab handler of the index i if the handler implements
     * the {@link TabHandler} interface,
     * <code>null</code> otherwise
     */
    @Override
    public TabHandler getTabHandler(int index) {
        TabHandler tabHandler = delegateTabHandler.getTabHandler(index);
        return tabHandler;
    }

    @Override
    public void setCustomTab(int index, TabContentModel model) {
        delegateTabHandler.setCustomTab(index, model);
    }

    @Override
    protected void initUI(UI ui) {
        super.initUI(ui);
        delegateTabHandler = new DelegateTabContainerHandler(getTabPanel());
        delegateTabHandler.init();
    }

    @Override
    public void init() {
        delegateTabHandler.init();
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        return delegateTabHandler.onTabChanged(currentIndex, newIndex);
    }
}
