/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;

public final class FileUtil {
    private static final int BUFFER_SIZE = 1024;

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(FileObject file) throws IOException {
        FileContent content = file.getContent();
        int size = (int)content.getSize();
        byte[] buf = new byte[size];
        InputStream in = content.getInputStream();
        try {
            int read = 0;
            for (int pos = 0; pos < size && read >= 0; pos += read) {
                read = in.read(buf, pos, size - pos);
            }
        }
        finally {
            in.close();
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContent(FileObject file, OutputStream outstr) throws IOException {
        InputStream instr = file.getContent().getInputStream();
        try {
            int nread;
            byte[] buffer = new byte[1024];
            while ((nread = instr.read(buffer)) >= 0) {
                outstr.write(buffer, 0, nread);
            }
        }
        finally {
            instr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContent(FileObject srcFile, FileObject destFile) throws IOException {
        OutputStream outstr = destFile.getContent().getOutputStream();
        try {
            FileUtil.writeContent(srcFile, outstr);
        }
        finally {
            outstr.close();
        }
    }
}

