/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.action.CloseApplicationAction;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.update.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.update.Updates;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;

public class UpdateApplicationAction
extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {
    private static final Log log = LogFactory.getLog(UpdateApplicationAction.class);
    protected UpdateModule[] modulesToUpdate;
    protected boolean reload;

    public UpdateApplicationAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n.t((String)"tutti.main.action.updateApplication.tip", (Object[])new Object[0]));
        this.modulesToUpdate = Updates.getApplicationModules();
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            TuttiUIContext context = this.getContext();
            doAction = context.checkUpdateApplicationReachable(true);
        }
        return doAction;
    }

    public void releaseAction() {
        super.releaseAction();
        this.modulesToUpdate = Updates.getApplicationModules();
    }

    @Override
    public void doAction() throws Exception {
        this.reload = false;
        TuttiUIContext context = this.getContext();
        TuttiConfiguration config = this.getConfig();
        File current = config.getBasedir();
        if (current == null || !current.exists()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"No application base directory defined, skip updates.");
            }
        } else {
            String url = config.getUpdateApplicationUrl();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Try to update jre, i18N, help or tutti (current application location: %s), using update url: %s", current, url));
            }
            ProgressionModel progressionModel = new ProgressionModel();
            context.getActionUI().getModel().setProgressionModel((ApplicationProgressionModel)progressionModel);
            progressionModel.setMessage(I18n.t((String)"tutti.updateApplication.checkUpdates", (Object[])new Object[0]));
            TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(url, this, progressionModel);
            callback.setModulesToUpdate(this.modulesToUpdate);
            Updates.doUpdate(config, callback, current);
            if (callback.isApplicationUpdated()) {
                this.reload = true;
            } else {
                this.sendMessage(I18n.t((String)"tutti.updateApplication.noUpdate", (Object[])new Object[0]));
            }
        }
    }

    public void setModulesToUpdate(UpdateModule ... modulesToUpdate) {
        this.modulesToUpdate = modulesToUpdate;
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.reload) {
            block3: {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)"Could not wait 1 second...", (Throwable)e);
                }
            }
            ((MainUIHandler)this.getHandler()).showSuccessMessage(I18n.t((String)"tutti.updateApplication.title.success", (Object[])new Object[0]), I18n.t((String)"tutti.updateApplication.message.success", (Object[])new Object[0]));
            CloseApplicationAction action = (CloseApplicationAction)this.getContext().getActionFactory().createLogicAction(this.getHandler(), CloseApplicationAction.class);
            action.setExitCode(88);
            this.getActionEngine().runAction((AbstractApplicationAction)action);
        }
    }

    public boolean isReload() {
        return this.reload;
    }
}

