/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.update.module;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroContext;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroResult;
import fr.ifremer.adagio.core.type.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.referential.TuttiReferentialSynchronizeService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.update.module.ModuleUpdaterSupport;
import fr.ifremer.tutti.ui.swing.updater.UpdateModule;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;

public class DbModuleUpdater
extends ModuleUpdaterSupport {
    private static final Log log = LogFactory.getLog(DbModuleUpdater.class);
    protected boolean dbInstalled;
    protected boolean dbUpdated;

    public DbModuleUpdater() {
        super(UpdateModule.db);
    }

    public boolean isDbInstalled() {
        return this.dbInstalled;
    }

    public boolean isDbUpdated() {
        return this.dbUpdated;
    }

    @Override
    protected void onUpdateToDo(TuttiUIContext context, ApplicationInfo info) {
        if (info == null) {
            this.dbInstalled = false;
            this.dbUpdated = false;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Find a updatable module : " + this.updateModule));
            }
            if (context.isDbExist()) {
                this.dbUpdated = true;
            } else {
                this.dbInstalled = true;
            }
        }
    }

    @Override
    public void onUpdateDone(TuttiUIContext context, ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("A db update was downloaded (oldVersion: %s, newVersion: %s), will restart application to use it", info.oldVersion, info.newVersion));
        }
        if (this.dbInstalled) {
            this.prepareFirstDatabase(context, info);
        } else if (this.dbUpdated) {
            this.synchronizetDatabase(context, info);
        }
    }

    @Override
    public String getLabel() {
        return I18n.t((String)"tutti.update.db", (Object[])new Object[0]);
    }

    protected void prepareFirstDatabase(TuttiUIContext context, ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)("First time database was downloaded at version: " + info.newVersion));
        }
        File source = this.getDbDirectory(info);
        File target = context.getConfig().getDbDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Copy from " + source + " to " + target));
        }
        try {
            FileUtils.copyDirectory((File)source, (File)target);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.prepareFirstDB.copyDirectory.error", (Object[])new Object[]{source, target}), (Throwable)e);
        }
        try {
            FileUtils.deleteDirectory((File)source.getParentFile());
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.prepareFirstDB.deleteDirectory.error", (Object[])new Object[]{target}), (Throwable)e);
        }
    }

    protected void synchronizetDatabase(TuttiUIContext context, ApplicationInfo info) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("A database update was downloaded (oldVersion: %s, newVersion: %s), will launch a referential synchronize operation ", info.oldVersion, info.newVersion));
        }
        TuttiReferentialSynchronizeService service = context.getTuttiReferentialSynchronizeService();
        File dbDirectory = this.getDbDirectory(info);
        ReferentialSynchroContext synchroContext = service.createSynchroContext(dbDirectory);
        ReferentialSynchroResult result = synchroContext.getResult();
        ApplicationActionUI actionUI = context.getActionUI();
        actionUI.getModel().setProgressionModel((ApplicationProgressionModel)new DelegateProgressionModel(result.getProgressionModel()));
        service.prepare(synchroContext);
        if (!result.isSuccess()) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.synchroDB.prepare.error", (Object[])new Object[0]), (Throwable)result.getError());
        }
        service.synchronize(synchroContext);
        if (!result.isSuccess()) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.synchroDB.synchro.error", (Object[])new Object[0]), (Throwable)result.getError());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Reset all caches.");
        }
        PersistenceService persistence = context.getPersistenceService();
        persistence.clearAllCaches();
        if (log.isInfoEnabled()) {
            log.info((Object)"Clean data context.");
        }
        SampleCategoryModel sampleCategoryModel = context.getDataContext().getSampleCategoryModel();
        context.getDataContext().clearContext();
        context.getDataContext().loadSampleCategoryModel(sampleCategoryModel);
        File target = context.getConfig().getDbDirectory();
        File versionFile = ApplicationUpdater.getVersionFile((File)target);
        if (log.isInfoEnabled()) {
            log.info((Object)("Replace content of file " + versionFile + " with " + info.newVersion));
        }
        try {
            ApplicationUpdater.storeVersionFile((File)target, (String)info.newVersion);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.applicationUpdater.synchroDB.writeVersion.error", (Object[])new Object[]{versionFile}));
        }
    }

    protected File getDbDirectory(ApplicationInfo info) {
        File[] sources = info.destDir.listFiles();
        Preconditions.checkNotNull((Object)sources, (Object)("Downloaded db must have at least on directory, see " + info.destDir));
        Preconditions.checkState((sources.length == 1 ? 1 : 0) != 0, (Object)("Downloaded db should contains one directory at " + info.destDir));
        File result = sources[0];
        return result;
    }

    private static class DelegateProgressionModel
    extends ApplicationProgressionModel {
        private static final long serialVersionUID = 1L;
        private final ProgressionModel progressionModel;

        public DelegateProgressionModel(ProgressionModel progressionModel) {
            this.progressionModel = progressionModel;
            this.progressionModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DelegateProgressionModel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            });
        }

        public void setMessage(String message) {
            this.progressionModel.setMessage(message);
        }

        public void increments(String message) {
            this.progressionModel.increments(message);
        }

        public String getMessage() {
            return this.progressionModel.getMessage();
        }

        public void setRate(float rate) {
            this.progressionModel.setRate(rate);
        }

        public float getRate() {
            return this.progressionModel.getRate();
        }

        public void increments(int nb) {
            this.progressionModel.increments(nb);
        }

        public void setCurrent(int current) {
            this.progressionModel.setCurrent(current);
        }

        public int getCurrent() {
            return this.progressionModel.getCurrent();
        }

        public void adaptTotal(int total) {
            this.progressionModel.adaptTotal(total);
        }

        public void setTotal(int total) {
            this.progressionModel.setTotal(total);
        }

        public int getTotal() {
            return this.progressionModel.getTotal();
        }
    }
}

