/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.configuration;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.configuration.ConfigurationException;
import org.andromda.core.configuration.Filters;
import org.andromda.core.configuration.Location;
import org.andromda.core.configuration.Repository;
import org.andromda.core.configuration.Transformation;

public class Model
implements Serializable {
    private boolean lastModifiedCheck = false;
    private Filters packages = new Filters();
    private Filters constraints = new Filters();
    private List uris = new ArrayList();
    private String[] urisAsStrings = null;
    private final Collection transformations = new ArrayList();
    private final Collection moduleSearchLocations = new ArrayList();
    private String type;
    private String[] moduleSearchLocationPaths = null;
    private URL[] moduleSearchLocationResources = null;
    private static final Map modelModifiedTimes = new HashMap();
    private String key = null;
    private Repository repository;

    public boolean isLastModifiedCheck() {
        return this.lastModifiedCheck;
    }

    public void setLastModifiedCheck(boolean lastModifiedCheck) {
        this.lastModifiedCheck = lastModifiedCheck;
    }

    public void setProcessAllPackages(boolean processAllPackages) {
        this.packages.setApplyAll(processAllPackages);
    }

    public Filters getPackages() {
        return this.packages;
    }

    public void setPackages(Filters packages) {
        this.packages = packages;
    }

    public void setEnforceAllConstraints(boolean enforceAllConstraints) {
        this.constraints.setApplyAll(enforceAllConstraints);
    }

    public Filters getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Filters constraints) {
        this.constraints = constraints;
    }

    public String[] getUris() {
        if (this.urisAsStrings == null) {
            int uriNumber = this.uris.size();
            this.urisAsStrings = new String[uriNumber];
            for (int ctr = 0; ctr < uriNumber; ++ctr) {
                this.urisAsStrings[ctr] = this.uris.get(ctr).toString();
            }
        }
        return this.urisAsStrings;
    }

    public void addUri(String uri) {
        try {
            URL url = ResourceUtils.toURL(uri);
            if (url == null) {
                throw new ConfigurationException("Model could not be loaded from invalid path --> '" + uri + "'");
            }
            try {
                url.openConnection().setDefaultUseCaches(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.uris.add(url);
        }
        catch (Throwable throwable) {
            throw new ConfigurationException(throwable);
        }
    }

    public void addTransformation(Transformation transformation) {
        this.transformations.add(transformation);
    }

    public Transformation[] getTransformations() {
        return this.transformations.toArray(new Transformation[0]);
    }

    public void addModuleSearchLocation(Location location) {
        this.moduleSearchLocations.add(location);
    }

    public void addModuleSearchLocation(String path) {
        if (path != null) {
            Location location = new Location();
            location.setPath(path);
            this.moduleSearchLocations.add(location);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Location[] getModuleSearchLocations() {
        return this.moduleSearchLocations.toArray(new Location[0]);
    }

    public String[] getModuleSearchLocationPaths() {
        if (this.moduleSearchLocationPaths == null) {
            ArrayList<String> paths = new ArrayList<String>();
            Iterator iterator = this.moduleSearchLocations.iterator();
            while (iterator.hasNext()) {
                Location location = (Location)iterator.next();
                URL[] resources = location.getResources();
                int resourceNumber = resources.length;
                for (int ctr = 0; ctr < resourceNumber; ++ctr) {
                    paths.add(resources[ctr].toString());
                }
                paths.add(location.getPath());
            }
            this.moduleSearchLocationPaths = paths.toArray(new String[0]);
        }
        return this.moduleSearchLocationPaths;
    }

    public URL[] getModuleSearchLocationResources() {
        if (this.moduleSearchLocationResources == null) {
            ArrayList<URL> allResources = new ArrayList<URL>();
            Location[] locations = this.getModuleSearchLocations();
            for (int ctr = 0; ctr < locations.length; ++ctr) {
                URL[] resources = locations[ctr].getResources();
                for (int fileCtr = 0; fileCtr < resources.length; ++fileCtr) {
                    allResources.add(resources[fileCtr]);
                }
            }
            this.moduleSearchLocationResources = allResources.toArray(new URL[0]);
        }
        return this.moduleSearchLocationResources;
    }

    public long getLastModified() {
        long lastModifiedTime = 0L;
        Iterator iterator = this.uris.iterator();
        while (iterator.hasNext()) {
            URL url = (URL)iterator.next();
            long modifiedTime = ResourceUtils.getLastModifiedTime(url);
            if (modifiedTime <= lastModifiedTime) continue;
            lastModifiedTime = modifiedTime;
        }
        return lastModifiedTime;
    }

    public String toString() {
        String toString = super.toString();
        String key = this.getKey();
        if (key != null && key.trim().length() > 0) {
            toString = key;
        }
        return toString;
    }

    private String getKey() {
        if (this.key == null || this.key.trim().length() == 0) {
            StringBuffer buffer = new StringBuffer();
            Iterator iterator = this.uris.iterator();
            while (iterator.hasNext()) {
                URL uri = (URL)iterator.next();
                buffer.append(new File(uri.getFile()));
                if (!iterator.hasNext()) continue;
                buffer.append(", ");
            }
            this.key = buffer.toString();
        }
        return this.key;
    }

    public Repository getRepository() {
        return this.repository;
    }

    void setRepository(Repository repository) {
        this.repository = repository;
    }

    public boolean isChanged() {
        boolean changed;
        boolean bl = changed = this.getUris().length > 0;
        if (changed) {
            String modelKey = this.getKey();
            Map lastModifiedTimes = (Map)modelModifiedTimes.get(modelKey);
            if (lastModifiedTimes != null) {
                long modelLastModified = (Long)lastModifiedTimes.get(modelKey);
                boolean bl2 = changed = this.getLastModified() > modelLastModified;
                if (!changed) {
                    URL[] resources = this.getModuleSearchLocationResources();
                    for (int ctr = 0; ctr < resources.length; ++ctr) {
                        URL resource = resources[ctr];
                        Long lastModified = (Long)lastModifiedTimes.get(resource);
                        if (lastModified == null || ResourceUtils.getLastModifiedTime(resource) <= lastModified) continue;
                        changed = true;
                        break;
                    }
                }
            }
            if (changed) {
                this.loadLastModifiedTimes();
            }
        }
        return changed;
    }

    private void loadLastModifiedTimes() {
        String modelKey = this.getKey();
        HashMap<Object, Long> lastModifiedTimes = (HashMap<Object, Long>)modelModifiedTimes.get(modelKey);
        if (lastModifiedTimes == null) {
            lastModifiedTimes = new HashMap<Object, Long>();
        } else {
            lastModifiedTimes.clear();
        }
        URL[] resources = this.getModuleSearchLocationResources();
        for (int ctr = 0; ctr < resources.length; ++ctr) {
            URL resource = resources[ctr];
            lastModifiedTimes.put(resource, new Long(ResourceUtils.getLastModifiedTime(resource)));
        }
        lastModifiedTimes.put(modelKey, new Long(this.getLastModified()));
        modelModifiedTimes.put(modelKey, lastModifiedTimes);
    }

    static void clearLastModifiedTimes() {
        modelModifiedTimes.clear();
    }
}

