package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportMultiPostAction.java 1004 2013-05-24 12:54:22Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.3.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/individualobservation/ImportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractImportMultiPostAction;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ImportMultiPostAction
        extends AbstractImportMultiPostAction<IndividualObservationBatchUIModel, IndividualObservationBatchUI, IndividualObservationBatchUIHandler> {

    public ImportMultiPostAction(IndividualObservationBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiIndividualObservation";
    }

    @Override
    protected String getFileExtensionDescription() {
        return _("tutti.common.file.tuttiIndividualObservation");
    }

    @Override
    protected String getFileChooserTitle() {
        return _("tutti.editIndividualObservationBatch.action.importMultiPost.sourceFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return _("tutti.editIndividualObservationBatch.action.importMultiPost.sourceFile.button");
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        multiPostImportExportService.importIndividualObservation(file, operation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        sendMessage(_("tutti.editIndividualObservationBatch.action.importMultiPost.success", file));
    }
}
