<%@ page import="fr.ifremer.echobase.ui.actions.EditActionEnum" %>
<%--
#%L
  EchoBase :: UI
  $Id: userList.jsp 104 2011-11-21 16:12:09Z sletellier $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/trunk/echobase-ui/src/main/webapp/WEB-INF/jsp/user/userList.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
--%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<title><s:text name="echobase.title.users"/></title>

<s:url id="loadUrl" action="getUsers" namespace="/user" escapeAmp="false"/>

<s:url id="addUrl" action="userForm" namespace="/user" escapeAmp="false" method="input">
  <s:param name="userEditAction"><%=EditActionEnum.CREATE%></s:param>
</s:url>

<s:url id="editUrl" action="userForm" namespace="/user" escapeAmp="false" method="input">
  <s:param name="userEditAction"><%=EditActionEnum.EDIT%></s:param>
</s:url>

<s:url id="delUrl" action="userForm" namespace="/user" escapeAmp="false" method="input">
  <s:param name="userEditAction"><%=EditActionEnum.DELETE%></s:param>
</s:url>

<script type="text/javascript">

  jQuery(document).ready(function () {
    $.addRowSelectTopic('users');
    $.addClearSelectTopic('users');
    $.addAddRowTopic('users', '${addUrl}');
    $.addSingleRowTopic('users', 'Update', '${editUrl}', 'user.id');
    $.addSingleRowTopic('users', 'Delete', '${delUrl}', 'user.id');
  });
</script>

<h2><s:text name="echobase.title.users"/></h2>
<br/>

<sjg:grid id="users" caption="%{getText('echobase.header.user.gridTitle')}"
          dataType="json" href="%{loadUrl}" gridModel="users"
          pager="true" pagerButtons="true" pagerInput="true"
          navigator="true" rownumbers="false" autowidth="true"
          onSelectRowTopics='users-rowSelect'
          onCompleteTopics='users-cleanSelect'
          navigatorEdit="false" navigatorDelete="false"
          navigatorSearch="false" navigatorRefresh="false"
          navigatorAdd="false" viewrecords="true"
          rowList="10,15,20, 50" rowNum="10"
          navigatorExtraButtons="{
                add: { title : 'Ajouter', icon: 'ui-icon-plus', topic: 'users-rowAdd' },
                update: { title : 'Mettre à jour', icon: 'ui-icon-pencil', topic: 'users-rowUpdate' },
                delete : { title : 'Supprimer', icon: 'ui-icon-trash', topic: 'users-rowDelete' }
        }">
  <sjg:gridColumn name="id" title="id" hidden="true"/>
  <sjg:gridColumn name="email" width="600" title='%{getText("echobase.common.email")}'
                  sortable="false"/>
  <sjg:gridColumn name="admin" title='%{getText("echobase.common.admin")}'
                  sortable="false" width="100" formatter="checkbox"/>
</sjg:grid>
