/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.runner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class Monitor
extends Thread {
    private String _key;
    private ServerSocket _serverSocket;

    public Monitor(int port, String key) throws UnknownHostException, IOException {
        if (port <= 0) {
            throw new IllegalStateException("Bad stop port");
        }
        if (key == null) {
            throw new IllegalStateException("Bad stop key");
        }
        this._key = key;
        this.setDaemon(true);
        this.setName("JettyRunnerMonitor");
        this._serverSocket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
        this._serverSocket.setReuseAddress(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this._serverSocket != null) {
            Socket socket = null;
            try {
                socket = this._serverSocket.accept();
                socket.setSoLinger(false, 0);
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String key = reader.readLine();
                if (!this._key.equals(key)) continue;
                String cmd = reader.readLine();
                if ("stop".equals(cmd)) {
                    this.closeSocket(socket);
                    this.closeServerSocket(this._serverSocket);
                    System.err.println("Stopping Jetty");
                    System.exit(0);
                    continue;
                }
                System.err.println("Unsupported monitor operation: " + cmd);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                this.closeSocket(socket);
            }
        }
    }

    private void closeSocket(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            socket = null;
        }
    }

    private void closeServerSocket(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            socket = null;
        }
    }
}

