/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.beans;

import com.google.common.base.Strings;
import fr.ifremer.coselmar.beans.UserBean;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.nuiton.i18n.I18n;

public class UserAccountCreatedMail {
    protected Locale locale;
    protected String to;
    private UserBean user;
    private String coselmarUrl;
    private String password;

    public UserAccountCreatedMail(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String mail) {
        this.to = mail;
    }

    public String getSubject() {
        String fullname = Strings.nullToEmpty((String)this.user.getFirstName()) + " " + Strings.nullToEmpty((String)this.user.getName());
        if (StringUtils.isBlank((CharSequence)fullname)) {
            return I18n.l((Locale)this.locale, (String)"coselmar.service.mail.UserAccountCreatedMail.subject", (Object[])new Object[]{this.user.getMail()});
        }
        return I18n.l((Locale)this.locale, (String)"coselmar.service.mail.UserAccountCreatedMail.subject", (Object[])new Object[]{fullname});
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public boolean isRecipientProvided() {
        boolean isRecipientProvided = StringUtils.isNotBlank((CharSequence)this.to);
        return isRecipientProvided;
    }

    public UserBean getUser() {
        return this.user;
    }

    public void setUser(UserBean user) {
        this.user = user;
    }

    public String getCoselmarUrl() {
        return this.coselmarUrl;
    }

    public void setCoselmarUrl(String coselmarUrl) {
        this.coselmarUrl = coselmarUrl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

