/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.admin.widget;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.widget.AdminListSelectorHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jaxx.runtime.swing.ListSelectorUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyProxy;

public class UserListSelectorHandler
extends AdminListSelectorHandler<User> {
    private static final Log log = LogFactory.getLog(UserListSelectorHandler.class);
    protected Group bean;
    protected VradiEntitiesListener<Group> groupVradiEntitiesListener;

    public UserListSelectorHandler(ListSelectorUI<User> listSelector) {
        super(listSelector);
        VradiContext.get().getVradiNotifier().addVradiListener(User.class, this);
        this.groupVradiEntitiesListener = new VradiEntitiesListener<Group>(){

            @Override
            public void entitiesAdded(Set<Group> added) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[UserListSelectorHandler] group added");
                }
                if (added.contains(UserListSelectorHandler.this.bean)) {
                    UserListSelectorHandler.this.updateAll();
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[UserListSelectorHandler] group removed");
                }
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(Group.class, this.groupVradiEntitiesListener);
    }

    public Group getBean() {
        return this.bean;
    }

    public void setBean(Group bean) {
        this.bean = bean;
    }

    protected void updateAll() {
        String wikittyId = this.bean.getWikittyId();
        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
        this.bean = (Group)wikittyProxy.restore(Group.class, wikittyId);
        List<User> users = this.updateList(wikittyProxy);
        this.updateCombo(users);
    }

    protected List<User> updateList(WikittyProxy wikittyProxy) {
        Set usersIds = this.bean.getUser();
        if (usersIds != null) {
            List users = wikittyProxy.restore(User.class, new ArrayList(usersIds));
            this.setListDatas(users);
            this.idsInList.clear();
            this.idsInList.addAll(VradiHelper.extractIds(users));
            return users;
        }
        return Collections.EMPTY_LIST;
    }

    protected void updateCombo(List<User> userInList) {
        VradiDataService vradiDataService = VradiService.getVradiDataService();
        List allUsers = vradiDataService.findAllUsers();
        allUsers.removeAll(userInList);
        this.setComboDatas(allUsers);
        this.idsInCombo.clear();
        this.idsInCombo.addAll(VradiHelper.extractIds(allUsers));
    }

    @Override
    public void entitiesAdded(Set<User> usersAdded) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"[UserListSelectorHandler] user added");
        }
        if (this.bean == null) {
            return;
        }
        for (User added : usersAdded) {
            String wikittyId = added.getWikittyId();
            if (this.bean.getUser() != null && this.bean.getUser().contains(wikittyId)) {
                if (this.idsInList.contains(wikittyId)) continue;
                this.updateAll();
                continue;
            }
            if (this.idsInList.contains(wikittyId)) {
                this.updateAll();
                continue;
            }
            if (this.idsInCombo.contains(wikittyId)) continue;
            this.idsInCombo.add(wikittyId);
            WikittyProxy proxy = VradiService.getWikittyProxy();
            this.setComboDatas(proxy.restore(User.class, this.idsInCombo));
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        if (log.isDebugEnabled()) {
            log.info((Object)"[UserListSelectorHandler] user removed");
        }
        for (String wikittyId : removed) {
            List users;
            WikittyProxy proxy = VradiService.getWikittyProxy();
            if (this.idsInCombo.contains(wikittyId)) {
                this.idsInCombo.remove(wikittyId);
                users = proxy.restore(User.class, this.idsInCombo);
                this.setComboDatas(users);
            }
            if (!this.idsInList.contains(wikittyId)) continue;
            this.idsInList.remove(wikittyId);
            users = proxy.restore(User.class, this.idsInList);
            this.setListDatas(users);
        }
    }
}

