/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiConfig.java 1820 2010-12-07 17:32:36Z bpoussin $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.1/vradi-swing/src/main/java/com/jurismarches/vradi/VradiConfig.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package com.jurismarches.vradi;

import static org.nuiton.i18n.I18n._;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Locale;

import jaxx.runtime.context.DefaultApplicationContext.AutoLoad;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.Version;
import org.nuiton.util.VersionUtil;
import org.nuiton.wikitty.WikittyConfig;

/**
 * Vradi UI configuration.
 * 
 * Class is auto instanced by Jaxx when getting it from context.
 * 
 * @author chatellier
 * @version $Revision: 1820 $
 * 
 * Last update : $Date: 2010-12-07 18:32:36 +0100 (mar., 07 déc. 2010) $
 * By : $Author: bpoussin $
 */
@AutoLoad
public class VradiConfig extends ApplicationConfig {

    /** to use log facility, just put in your code: log.info(\"...\");*/
    static private Log log = LogFactory.getLog(VradiConfig.class);

    /** Un drapeau pour savoir si on est en mode pleine écran. */
    protected boolean fullscreen;

    /**
     * Constructor.
     * 
     * Init default options and actions.
     */
    public VradiConfig() {

        super();

        // Load default value for wikitty
        loadDefaultOptions(WikittyConfig.WikittyOption.class);

        // init configuration with default options
        loadDefaultOptions(VradiSwingOption.class);

        loadActions(VradiSwingAction.class);

    }

    @Override
    protected void firePropertyChange(String propertyName,
                                      Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }    

    /**
     * Overwrite {@link ApplicationConfig#parse(String[])} to manage version after parsing.
     */
    @Override
    public void parse(String[] args) throws ArgumentsParserException {
        super.parse(args);
        
        // on supprime le stamp de snapshot s'il existe
        String sVersion = VersionUtil.removeSnapshot(getOption("application.version"));
        Version version = VersionUtil.valueOf(sVersion);
        setDefaultOption(VradiSwingOption.VRADI_VERSION.key, version.getVersion());

        // la version de la base est sans classifier (pas de alpha, ou rc,...)
        Version dbVersion;
        if (version.hasClassifier()) {
            dbVersion = VersionUtil.removeClassifier(version);
        } else {
            dbVersion = VersionUtil.valueOf(version.toString());
        }

        setDefaultOption(VradiSwingOption.VRADI_DATABASE_VERSION.key, dbVersion.getVersion());
    }

    protected static final String[] DEFAULT_JAXX_PCS = {
            "showNumberEditorButton", "autoPopupNumberEditor", "fullScreen", "locale"
    };

    /**
     * TODO EC20100519 used by ?
     */
    public void removeJaxxPropertyChangeListener() {
        PropertyChangeListener[] toRemove = jaxx.runtime.SwingUtil.findJaxxPropertyChangeListener(DEFAULT_JAXX_PCS, getPropertyChangeListeners());
        if (toRemove == null || toRemove.length == 0) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("before remove : " + getPropertyChangeListeners().length);
            log.debug("toRemove : " + toRemove.length);
        }
        for (PropertyChangeListener listener : toRemove) {
            removePropertyChangeListener(listener);
        }
        if (log.isDebugEnabled()) {
            log.debug("after remove : " + getPropertyChangeListeners().length);
        }
    }

    /**
     * Vradi option enum.
     */
    public static enum VradiSwingOption implements OptionDef {

        CONFIG_FILE(
                CONFIG_FILE_NAME,
                _("vradi.config.configFileName.description"),
                "vradi.properties", String.class, true, true),

        VRADI_SWING_DEBUG(
                "vradi.swing.debug",
                _("vradi.config.swing.debug"),
                "false" , Boolean.class, true, true),

        SWING_CONFIG_FILE(
                "vradi.swing.config",
                _("vradi.config.swingConfigFileName.description"),
                "${config.file}" + File.separator + "vradi-swing.properties", File.class, true, true),

        VRADI_VERSION(
                "vradi.version",
                _("vradi.config.version.description"),
                null, String.class, true, true),

        VRADI_DATABASE_VERSION(
                "vradi.database.version",
                _("vradi.config.database.version.description"),
                null, String.class, true, true),

        VRADI_LAST_VERSION(
                "vradi.last.version",
                _("vradi.config.last.version.description"),
                null, String.class, true, true),

        // ui config
        FULL_SCREEN(
                "ui.fullscreen",
                _("vradi.config.ui.fullscreen"),
                "false", Boolean.class, false, false),

        LOCALE(
                "ui.locale",
                _("vradi.config.ui.locale"),
                Locale.FRANCE.toString(),
                Locale.class, false, false),

        // login and password
        USERNAME(
                "login",
                _("vradi.config.login"),
                "", String.class, true, true),
        PASSWORD(
                "password",
                _("vradi.config.password"),
                "", String.class, true, true),

        // achitecture client serveur
        REMOTE_ENDPOINT(
                "vradi.remote.endpoint",
                _("vradi.config.remote.endpoint.description"),
                "", String.class, false, false),

        // user datas
        QUERIES(
                "vradi.queries",
                _("vradi.config.queries.description"),
                "", String.class, false, false),

        XML_STREAMS(
                "vradi.xmlStreams",
                _("vradi.config.xmlStreams.description"),
                "", String.class, false, false),

        CRITERIAS(
                "vradi.xmlStreams",
                _("vradi.config.criteria.description"),
                "", String.class, false, false),

        ROOT_CRITERIAS(
                "vradi.root.criteria",
                _("vradi.config.root.criteria.description"),
                "", String.class, false, false),

        THESAURUS(
                "vradi.thesaurus",
                _("vradi.config.thesaurus.description"),
                "", String.class, false, false),

        ROOT_THESAURUS(
                "vradi.rootThesaurus",
                _("vradi.config.rootThesaurus.description"),
                "", String.class, false, false),

        COLUMNS(
                "vradi.columns",
                _("vradi.config.columns.description"),
                "", String.class, false, false),

        THESAURUS_COLORS(
                "vradi.thesaurus.color",
                _("vradi.config.thesaurus.color.description"),
                "", String.class, false, false),

        STATUS_COLOR(
                "vradi.status.color",
                _("vradi.config.status.color.description"),
                "", String.class, false, false),

        THESAURUS_EXPANDED(
                "vradi.thesaurus.expanded",
                _("vradi.config.thesaurus.expanded.description"),
                "", Boolean.class, false, false);
        
        public String key;
        public String description;
        public String defaultValue;
        public Class<?> type;
        public boolean isTransient;
        public boolean isFinal;

        private VradiSwingOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isTransient = isTransient;
            this.isFinal = isFinal;
        }

        @Override
        public boolean isFinal() {
            return isFinal;
        }

        @Override
        public boolean isTransient() {
            return isTransient;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public String getDescription() {
            return description;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public Class<?> getType() {
            return type;
        }

        @Override
        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        @Override                                                           
        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }
    }

    /**
     * Can't be used un @annotation.
     */
    @Deprecated
    public static enum Step {
        AfterInit, BeforeExit
    }

    public static enum VradiSwingAction implements ActionDef {

        HELP(_("vradi.action.commandline.help"), VradiAction.class.getName() + "#help", "-h", "--help"),
        HELP_UI(_("vradi.action.commandline.help.ui"), VradiAction.class.getName() + "#helpUI", "--help-ui"),
        NO_MAIN_UI(_("vradi.action.commandline.disable.main.ui"), VradiAction.class.getName() + "#disableMainUI", "-n", "--no-main"),
        CONFIGURE_UI(_("vradi.action.commandline.configure.ui"), VradiAction.class.getName() + "#configure", "--configure");

        public String description;
        public String action;
        public String[] aliases;

        private VradiSwingAction(String description, String action, String... aliases) {
            this.description = description;
            this.action = action;
            this.aliases = aliases;
        }

        @Override
        public String getAction() {
            return action;
        }

        @Override
        public String[] getAliases() {
            return aliases;
        }
    }
}
