/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: AbstractEmailNodeLoador.java 1807 2010-11-24 15:11:33Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/loadors/AbstractEmailNodeLoador.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.loadors;

import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;
import jaxx.runtime.swing.nav.NavDataProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

import java.util.List;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public abstract class AbstractEmailNodeLoador<B extends BusinessEntity> extends AbstractVradiNodeLoadors<B> {

    static private final Log log = LogFactory.getLog(AbstractEmailNodeLoador.class);

    protected AbstractEmailNodeLoador(Class<B> beanType) {
        super(beanType);
    }

    public List<Sending> getSendingList(NavDataProvider dataProvider, String sessionId) {

        // Get proxy
        WikittyProxy proxy = getProxy(dataProvider);

        // Restore session
        Session session = proxy.restore(Session.class, sessionId);

        // Get all sending ids
        return EmailDataHelper.getAllSending(session);
    }
}
