/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiTreeHelper.java 1800 2010-11-17 20:58:35Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.4.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/tree/helpers/VradiTreeHelper.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.tree.helpers;

import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyServiceEvent;
import org.nuiton.wikitty.WikittyServiceListener;

import javax.swing.*;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Navigation tree helpers.
 *
 * @author sletellier
 * @see jaxx.runtime.swing.nav.tree.NavTreeHelper
 */
public abstract class VradiTreeHelper extends NavTreeHelper<VradiTreeNode> implements WikittyServiceListener {

    /**
     * Logger
     */
    static private final Log log = LogFactory.getLog(VradiTreeHelper.class);

    protected List<String> idsLoaded = new ArrayList<String>();

    @Override
    public void setUI(JTree tree,
                      boolean addExpandTreeListener,
                      boolean addOneClickSelectionListener,
                      TreeSelectionListener listener,
                      TreeWillExpandListener willExpandListener) {

        super.setUI(tree,
                addExpandTreeListener,
                addOneClickSelectionListener,
                listener,
                willExpandListener);

        // Add tree expend listener to keep loaded nodes ids
        tree.addTreeExpansionListener(new TreeExpansionListener(){
            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode) event.getPath().getLastPathComponent();
                registerLoadedIds(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode) event.getPath().getLastPathComponent();
                Enumeration<VradiTreeNode> enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    VradiTreeNode child = enumeration.nextElement();
                    idsLoaded.remove(child.getId());
                }
            }
        });
    }
    
    @Override
    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)dataProvider;
    }

    public List<String> getLoadedIds() {
        return idsLoaded;
    }

    public boolean isLoadedId(String id) {
        return idsLoaded.contains(id);
    }

    public void registerLoadedIds(VradiTreeNode node) {
        idsLoaded.add(node.getId());
        Enumeration<VradiTreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            VradiTreeNode child = enumeration.nextElement();
            idsLoaded.add(child.getId());
        }
    }

    @Override
    public void putWikitty(WikittyServiceEvent event) {

        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put event : " + event);
        }

        // map between id and extensions "name" (not extension ids)
        Map<String, Set<String>> idAndExtensions = event.getIdExtensions();
        for (String wikittyId : event.getIds()) {
            Set<String> wikittyExtensions = idAndExtensions.get(wikittyId);
            putWikitty(wikittyId, wikittyExtensions);
        }
    }

    /**
     * Put single wikitty event.
     *
     * TODO maybe it's not a good idea, it's better to manage single refresh for one event
     *
     * @param wikittyId wikitty id
     * @param wikittyExtensions wikitty extensions
     */
    public void putWikitty(String wikittyId, Set<String> wikittyExtensions) {

    }

    @Override
    public void removeWikitty(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service remove event : " + event);
        }

        for (String wikittyId : event.getIds()) {

            // If wikitty id it's not loaded, the event dont concerne this tree
            if (isLoadedId(wikittyId)) {

                VradiTreeNode node = findNode(getRootNode(), wikittyId);

                idsLoaded.remove(wikittyId);
                if (node != null) {

                    if (log.isDebugEnabled()) {
                        log.debug("Removing node " + wikittyId + " from parent");
                    }

                    VradiTreeNode parent = node.getParent();
                    int index = parent.getIndex(node);
                    node.removeFromParent();
                    getBridge().nodesWereRemoved(parent, new int[] {index}, new VradiTreeNode[]{node});
                }
            }
        }
    }           

    @Override
    public void clearWikitty(WikittyServiceEvent event) {
        // should not happen in vradi
    }

    @Override
    public void putExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service put extension event : " + event);
        }
    }

    @Override
    public void removeExtension(WikittyServiceEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Receive wikitty service remove extension event : " + event);
        }
    }

    @Override
    public void clearExtension(WikittyServiceEvent event) {
        // should not happen in vradi
    }
}
