/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileUtils {
    public static File resolvePath(File base, String path) {
        File r = new File(path);
        return r.isAbsolute() ? r : new File(base, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync(File fullFile) throws IOException {
        if (fullFile == null || !fullFile.exists()) {
            throw new FileNotFoundException("File does not exist " + fullFile);
        }
        boolean success = false;
        int retryCount = 0;
        IOException exc = null;
        while (!success && retryCount < 5) {
            ++retryCount;
            RandomAccessFile file = null;
            try {
                try {
                    file = new RandomAccessFile(fullFile, "rw");
                    file.getFD().sync();
                    success = true;
                }
                finally {
                    if (file == null) continue;
                    file.close();
                }
            }
            catch (IOException ioe) {
                if (exc == null) {
                    exc = ioe;
                }
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (!success) {
            throw exc;
        }
    }
}

