/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.*;
import com.jurismarches.vradi.ui.offer.editors.*;
import com.jurismarches.vradi.ui.offer.thesaurus.ThesaurusUI;
import com.jurismarches.vradi.ui.renderers.ThesaurusHighlighter;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class OfferEditUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_VALIDE = "valide";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COUNTRY_EDITOR_VALUE = "countryEditor.value";
    public static final String BINDING_DATE_PEREMEPTION_EDITOR_VALUE = "datePeremeptionEditor.value";
    public static final String BINDING_DATE_PUB_EDITOR_VALUE = "datePubEditor.value";
    public static final String BINDING_DEPARTMENT_EDITOR_VALUE = "departmentEditor.value";
    public static final String BINDING_DESCRIPTION_EDITOR_VALUE = "descriptionEditor.value";
    public static final String BINDING_ENTITY_EDITOR_VALUE = "entityEditor.value";
    public static final String BINDING_ID_EDITOR_VALUE = "idEditor.value";
    public static final String BINDING_OBJET_EDITOR_VALUE = "objetEditor.value";
    public static final String BINDING_PROPOSITION_LIST_SELECTION_MODEL = "propositionList.selectionModel";
    public static final String BINDING_SOURCE_TEXT_EDITOR_VALUE = "sourceTextEditor.value";
    public static final String BINDING_SOURCE_URLEDITOR_VALUE = "sourceURLEditor.value";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.offer.OfferEditUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table actionPanel;
    protected javax.swing.JButton addAttachment;
    protected javax.swing.JButton addFile;
    protected javax.swing.JButton annuler;
    protected javax.swing.JList attachmentFileList;
    protected javax.swing.DefaultListModel attachmentFileListModel;
    protected java.util.ArrayList< File > attachmentFilesToUpload;
    protected javax.swing.JPanel content;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor countryEditor;
    protected com.jurismarches.vradi.entities.Form data;
    protected com.jurismarches.vradi.ui.offer.editors.DateTimeEditor datePeremeptionEditor;
    protected com.jurismarches.vradi.ui.offer.editors.DateTimeEditor datePubEditor;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor departmentEditor;
    protected com.jurismarches.vradi.ui.offer.editors.TextEditor descriptionEditor;
    protected javax.swing.JList embeddedFileList;
    protected javax.swing.DefaultListModel embeddedFileListModel;
    protected java.util.ArrayList< File > embeddedFilesToUpload;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor entityEditor;
    protected jaxx.runtime.validator.swing.SwingValidatorMessageTableModel errorEditorTable;
    protected javax.swing.JButton findQueriesButton;
    protected jaxx.runtime.swing.Table formContentPane;
    protected javax.swing.JPanel formPane;
    protected javax.swing.JScrollPane formScrollPane;
    protected javax.swing.JSplitPane formSplitPane;
    protected com.jurismarches.vradi.ui.offer.editors.IdEditor idEditor;
    protected jaxx.runtime.swing.HBox lastModified;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor objetEditor;
    protected javax.swing.JSplitPane offerEdit;
    protected OfferEditUI offerEditUI = this;
    protected javax.swing.JList propositionList;
    protected javax.swing.DefaultListModel propositionListModel;
    protected javax.swing.JButton removeAttachment;
    protected javax.swing.JButton removeFile;
    protected com.jurismarches.vradi.ui.offer.editors.StringEditor sourceTextEditor;
    protected com.jurismarches.vradi.ui.offer.editors.UrlEditor sourceURLEditor;
    protected javax.swing.JPanel statusButtonPanel;
    protected javax.swing.JPanel thesaurus;
    protected java.lang.Boolean valide;
    protected javax.swing.JButton viewPDF;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JSplitPane $JSplitPane0;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JPanel $JPanel1;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JScrollPane $JScrollPane1;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JScrollPane $JScrollPane2;
    private javax.swing.JLabel $JLabel3;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditHandler getHandler() {
        return getContextValue(OfferEditHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
        if(data != null && data.getCreationDate() != null) {
            String creationDateText = String.format(_("vradi.entity.creation.date"),
                    data.getCreationDate());
            lastModified.add(new JLabel(creationDateText));
    
            if (data.getExtensionNames().contains(ModificationTag.EXT_MODIFICATIONTAG)) {
                // get modification info
                ModificationTag formTag = VradiService.getWikittyProxy().cast(data, ModificationTag.class);
                Object date = formTag.getLastModified();
                Object user = formTag.getLastModifier();
                if (date != null && user != null) {
                    String lastModifiedText = String.format(_("vradi.entity.lastModified.date.user"), date, user);
                    lastModified.add(new JLabel(lastModifiedText));
                }
            }
        }
        setContextValue(errorEditorTable, "errorEditorTable");
        formScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        formScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        formSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                resize();
            }
        });
    }
    
    public void resize(){
        Dimension dimension = formContentPane.getSize();
        dimension.setSize(formSplitPane.getDividerLocation() - 20, formContentPane.getHeight());
        formContentPane.setPreferredSize(dimension);
        formContentPane.revalidate();
    }
    
    public void updateThesaurusSize(){
        double total = getSize().getWidth();
        Component[] thesPanels = thesaurus.getComponents();
        double width = total / thesPanels.length;
        for (Component c : thesPanels){
            ThesaurusUI thesaurus = (ThesaurusUI)c;
            Dimension d = thesaurus.getSize();
            if (log.isDebugEnabled()){
                log.debug("Resizing total width : " + total + " thesaurus width : " + width);
            }
            d.setSize(width, d.getHeight());
            thesaurus.setPreferredSize(d);
        }
        validate();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public OfferEditUI() {
        $initialize();
    }

    public OfferEditUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addAttachment(java.awt.event.ActionEvent event) {
        getHandler().addAttachmentFile(this);
    }

    public void doActionPerformed__on__addFile(java.awt.event.ActionEvent event) {
        getHandler().addEmbeddedFile(this);
    }

    public void doActionPerformed__on__findQueriesButton(java.awt.event.ActionEvent event) {
        getHandler().findQueries(this);
    }

    public void doActionPerformed__on__removeAttachment(java.awt.event.ActionEvent event) {
        getHandler().removeAttachmentFile(this);
    }

    public void doActionPerformed__on__removeFile(java.awt.event.ActionEvent event) {
        getHandler().removeEmbeddedFile(this);
    }

    public void doActionPerformed__on__viewPDF(java.awt.event.ActionEvent event) {
        getHandler().viewInPDF(this);
    }

    public void doComponentResized__on__formScrollPane(java.awt.event.ComponentEvent event) {
        resize();
    }

    public void doTableChanged__on__errorEditorTable(javax.swing.event.TableModelEvent event) {
        setValide(errorEditorTable.getRowCount()==0);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.Table getActionPanel() {
        return actionPanel;
    }

    public javax.swing.JButton getAddAttachment() {
        return addAttachment;
    }

    public javax.swing.JButton getAddFile() {
        return addFile;
    }

    public javax.swing.JButton getAnnuler() {
        return annuler;
    }

    public javax.swing.JList getAttachmentFileList() {
        return attachmentFileList;
    }

    public javax.swing.DefaultListModel getAttachmentFileListModel() {
        return attachmentFileListModel;
    }

    public java.util.ArrayList< File > getAttachmentFilesToUpload() {
        return attachmentFilesToUpload;
    }

    public javax.swing.JPanel getContent() {
        return content;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getCountryEditor() {
        return countryEditor;
    }

    public com.jurismarches.vradi.entities.Form getData() {
        return data;
    }

    public com.jurismarches.vradi.ui.offer.editors.DateTimeEditor getDatePeremeptionEditor() {
        return datePeremeptionEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.DateTimeEditor getDatePubEditor() {
        return datePubEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getDepartmentEditor() {
        return departmentEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.TextEditor getDescriptionEditor() {
        return descriptionEditor;
    }

    public javax.swing.JList getEmbeddedFileList() {
        return embeddedFileList;
    }

    public javax.swing.DefaultListModel getEmbeddedFileListModel() {
        return embeddedFileListModel;
    }

    public java.util.ArrayList< File > getEmbeddedFilesToUpload() {
        return embeddedFilesToUpload;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getEntityEditor() {
        return entityEditor;
    }

    public jaxx.runtime.validator.swing.SwingValidatorMessageTableModel getErrorEditorTable() {
        return errorEditorTable;
    }

    public javax.swing.JButton getFindQueriesButton() {
        return findQueriesButton;
    }

    public jaxx.runtime.swing.Table getFormContentPane() {
        return formContentPane;
    }

    public javax.swing.JPanel getFormPane() {
        return formPane;
    }

    public javax.swing.JScrollPane getFormScrollPane() {
        return formScrollPane;
    }

    public javax.swing.JSplitPane getFormSplitPane() {
        return formSplitPane;
    }

    public com.jurismarches.vradi.ui.offer.editors.IdEditor getIdEditor() {
        return idEditor;
    }

    public jaxx.runtime.swing.HBox getLastModified() {
        return lastModified;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getObjetEditor() {
        return objetEditor;
    }

    public javax.swing.JSplitPane getOfferEdit() {
        return offerEdit;
    }

    public javax.swing.JList getPropositionList() {
        return propositionList;
    }

    public javax.swing.DefaultListModel getPropositionListModel() {
        return propositionListModel;
    }

    public javax.swing.JButton getRemoveAttachment() {
        return removeAttachment;
    }

    public javax.swing.JButton getRemoveFile() {
        return removeFile;
    }

    public com.jurismarches.vradi.ui.offer.editors.StringEditor getSourceTextEditor() {
        return sourceTextEditor;
    }

    public com.jurismarches.vradi.ui.offer.editors.UrlEditor getSourceURLEditor() {
        return sourceURLEditor;
    }

    public javax.swing.JPanel getStatusButtonPanel() {
        return statusButtonPanel;
    }

    public javax.swing.JPanel getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean getValide() {
        return valide;
    }

    public javax.swing.JButton getViewPDF() {
        return viewPDF;
    }

    public java.lang.Boolean isValide() {
        return valide !=null && valide;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(com.jurismarches.vradi.entities.Form newValue) {
        com.jurismarches.vradi.entities.Form oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    public void setValide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.valide;
        this.valide = newValue;
        firePropertyChange(PROPERTY_VALIDE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(statusButtonPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(lastModified, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        actionPanel.add(annuler, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(findQueriesButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add(viewPDF, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormContentPane() {
        if (!allComponentsCreated) {
            return;
        }
        formContentPane.add(objetEditor, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(idEditor, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(entityEditor, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(countryEditor, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(departmentEditor, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePubEditor, new GridBagConstraints(0, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(datePeremeptionEditor, new GridBagConstraints(1, 3, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceTextEditor, new GridBagConstraints(0, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(sourceURLEditor, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(content, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        formContentPane.add(descriptionEditor, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void addChildrenToFormPane() {
        if (!allComponentsCreated) {
            return;
        }
        formPane.add(formScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToFormScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        formScrollPane.getViewport().add(formContentPane);
    }

    protected void addChildrenToFormSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        formSplitPane.add(formPane, JSplitPane.LEFT);
        formSplitPane.add($JSplitPane0, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEdit() {
        if (!allComponentsCreated) {
            return;
        }
        offerEdit.add(formSplitPane, JSplitPane.LEFT);
        offerEdit.add(thesaurus, JSplitPane.RIGHT);
    }

    protected void addChildrenToOfferEditUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(offerEdit, BorderLayout.CENTER);
        add(actionPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToStatusButtonPanel() {
        if (!allComponentsCreated) {
            return;
        }
        statusButtonPanel.add($JLabel3);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new jaxx.runtime.swing.Table());
        
        actionPanel.setName("actionPanel");
    }

    protected void createAddAttachment() {
        $objectMap.put("addAttachment", addAttachment = new javax.swing.JButton());
        
        addAttachment.setName("addAttachment");
        addAttachment.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addAttachment"));
    }

    protected void createAddFile() {
        $objectMap.put("addFile", addFile = new javax.swing.JButton());
        
        addFile.setName("addFile");
        addFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFile"));
    }

    protected void createAnnuler() {
        $objectMap.put("annuler", annuler = new javax.swing.JButton());
        
        annuler.setName("annuler");
        annuler.setText(_("vradi.action.cancel"));
    }

    protected void createAttachmentFileList() {
        $objectMap.put("attachmentFileList", attachmentFileList = new javax.swing.JList());
        
        attachmentFileList.setName("attachmentFileList");
    }

    protected void createAttachmentFileListModel() {
        $objectMap.put("attachmentFileListModel", attachmentFileListModel = new javax.swing.DefaultListModel());
    }

    protected void createAttachmentFilesToUpload() {
        $objectMap.put("attachmentFilesToUpload", attachmentFilesToUpload = new java.util.ArrayList< File >());
    }

    protected void createContent() {
        $objectMap.put("content", content = new javax.swing.JPanel());
        
        content.setName("content");
        content.setLayout(new BoxLayout(content, BoxLayout.Y_AXIS));
        content.setVisible(false);
    }

    protected void createCountryEditor() {
        $objectMap.put("countryEditor", countryEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        countryEditor.setName("countryEditor");
    }

    protected void createData() {
        $objectMap.put("data", data = getContextValue(Form.class));
    }

    protected void createDatePeremeptionEditor() {
        $objectMap.put("datePeremeptionEditor", datePeremeptionEditor = new com.jurismarches.vradi.ui.offer.editors.DateTimeEditor());
        
        datePeremeptionEditor.setName("datePeremeptionEditor");
    }

    protected void createDatePubEditor() {
        $objectMap.put("datePubEditor", datePubEditor = new com.jurismarches.vradi.ui.offer.editors.DateTimeEditor());
        
        datePubEditor.setName("datePubEditor");
    }

    protected void createDepartmentEditor() {
        $objectMap.put("departmentEditor", departmentEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        departmentEditor.setName("departmentEditor");
    }

    protected void createDescriptionEditor() {
        $objectMap.put("descriptionEditor", descriptionEditor = new com.jurismarches.vradi.ui.offer.editors.TextEditor());
        
        descriptionEditor.setName("descriptionEditor");
    }

    protected void createEmbeddedFileList() {
        $objectMap.put("embeddedFileList", embeddedFileList = new javax.swing.JList());
        
        embeddedFileList.setName("embeddedFileList");
    }

    protected void createEmbeddedFileListModel() {
        $objectMap.put("embeddedFileListModel", embeddedFileListModel = new javax.swing.DefaultListModel());
    }

    protected void createEmbeddedFilesToUpload() {
        $objectMap.put("embeddedFilesToUpload", embeddedFilesToUpload = new java.util.ArrayList< File >());
    }

    protected void createEntityEditor() {
        $objectMap.put("entityEditor", entityEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        entityEditor.setName("entityEditor");
    }

    protected void createErrorEditorTable() {
        $objectMap.put("errorEditorTable", errorEditorTable = new jaxx.runtime.validator.swing.SwingValidatorMessageTableModel());
        
        errorEditorTable.addTableModelListener(JAXXUtil.getEventListener(TableModelListener.class, "tableChanged", this, "doTableChanged__on__errorEditorTable"));
    }

    protected void createFindQueriesButton() {
        $objectMap.put("findQueriesButton", findQueriesButton = new javax.swing.JButton());
        
        findQueriesButton.setName("findQueriesButton");
        findQueriesButton.setText(_("vradi.offerEdit.affectedQueries"));
        findQueriesButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__findQueriesButton"));
    }

    protected void createFormContentPane() {
        $objectMap.put("formContentPane", formContentPane = new jaxx.runtime.swing.Table());
        
        formContentPane.setName("formContentPane");
    }

    protected void createFormPane() {
        $objectMap.put("formPane", formPane = new javax.swing.JPanel());
        
        formPane.setName("formPane");
        formPane.setLayout(new BorderLayout());
    }

    protected void createFormScrollPane() {
        $objectMap.put("formScrollPane", formScrollPane = new javax.swing.JScrollPane());
        
        formScrollPane.setName("formScrollPane");
        formScrollPane.addComponentListener(JAXXUtil.getEventListener(ComponentListener.class, "componentResized", this, "doComponentResized__on__formScrollPane"));
    }

    protected void createFormSplitPane() {
        $objectMap.put("formSplitPane", formSplitPane = new javax.swing.JSplitPane());
        
        formSplitPane.setName("formSplitPane");
        formSplitPane.setContinuousLayout(true);
        formSplitPane.setDividerLocation(750);
        formSplitPane.setOneTouchExpandable(true);
        formSplitPane.setResizeWeight(0.8);
        formSplitPane.setDividerSize(12);
    }

    protected void createIdEditor() {
        $objectMap.put("idEditor", idEditor = new com.jurismarches.vradi.ui.offer.editors.IdEditor());
        
        idEditor.setName("idEditor");
    }

    protected void createLastModified() {
        $objectMap.put("lastModified", lastModified = new jaxx.runtime.swing.HBox());
        
        lastModified.setName("lastModified");
        lastModified.setHorizontalAlignment(4);
    }

    protected void createObjetEditor() {
        $objectMap.put("objetEditor", objetEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        objetEditor.setName("objetEditor");
    }

    protected void createOfferEdit() {
        $objectMap.put("offerEdit", offerEdit = new javax.swing.JSplitPane());
        
        offerEdit.setName("offerEdit");
        offerEdit.setOneTouchExpandable(true);
        offerEdit.setResizeWeight(0.3);
        offerEdit.setContinuousLayout(true);
        offerEdit.setDividerSize(12);
    }

    protected void createPropositionList() {
        $objectMap.put("propositionList", propositionList = new javax.swing.JList());
        
        propositionList.setName("propositionList");
    }

    protected void createPropositionListModel() {
        $objectMap.put("propositionListModel", propositionListModel = new javax.swing.DefaultListModel());
    }

    protected void createRemoveAttachment() {
        $objectMap.put("removeAttachment", removeAttachment = new javax.swing.JButton());
        
        removeAttachment.setName("removeAttachment");
        removeAttachment.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeAttachment"));
    }

    protected void createRemoveFile() {
        $objectMap.put("removeFile", removeFile = new javax.swing.JButton());
        
        removeFile.setName("removeFile");
        removeFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeFile"));
    }

    protected void createSourceTextEditor() {
        $objectMap.put("sourceTextEditor", sourceTextEditor = new com.jurismarches.vradi.ui.offer.editors.StringEditor());
        
        sourceTextEditor.setName("sourceTextEditor");
    }

    protected void createSourceURLEditor() {
        $objectMap.put("sourceURLEditor", sourceURLEditor = new com.jurismarches.vradi.ui.offer.editors.UrlEditor());
        
        sourceURLEditor.setName("sourceURLEditor");
    }

    protected void createStatusButtonPanel() {
        $objectMap.put("statusButtonPanel", statusButtonPanel = new javax.swing.JPanel());
        
        statusButtonPanel.setName("statusButtonPanel");
        statusButtonPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = new javax.swing.JPanel());
        
        thesaurus.setName("thesaurus");
        thesaurus.setLayout(new BoxLayout(thesaurus, BoxLayout.X_AXIS));
    }

    protected void createValide() {
        $objectMap.put("valide", valide = true);
    }

    protected void createViewPDF() {
        $objectMap.put("viewPDF", viewPDF = new javax.swing.JButton());
        
        viewPDF.setName("viewPDF");
        viewPDF.setText(_("vradi.offerEdit.view.pdf"));
        viewPDF.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__viewPDF"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToOfferEditUI();
        addChildrenToOfferEdit();
        addChildrenToFormSplitPane();
        addChildrenToFormPane();
        addChildrenToFormScrollPane();
        addChildrenToFormContentPane();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add($Table0, JSplitPane.LEFT);
        $JSplitPane0.add($Table1, JSplitPane.RIGHT);
        // inline complete setup of $Table0
        $Table0.add($JPanel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($JScrollPane1, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add($JLabel0);
        $JPanel0.add(addFile);
        $JPanel0.add(removeFile);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(embeddedFileList);
        // inline complete setup of $JPanel1
        $JPanel1.add($JLabel1);
        $JPanel1.add(addAttachment);
        $JPanel1.add(removeAttachment);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(attachmentFileList);
        // inline complete setup of $Table1
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane2
        $JScrollPane2.getViewport().add(propositionList);
        addChildrenToActionPanel();
        addChildrenToStatusButtonPanel();
        
        // apply 11 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 62 property setters
        offerEdit.setOrientation(JSplitPane.VERTICAL_SPLIT);
        formPane.setMinimumSize(new Dimension(0,0));
        formPane.setPreferredSize(new Dimension(0,0));
        formScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        formContentPane.setPreferredSize(new Dimension(0,0));
        objetEditor.setExtensionFieldName(Form.FIELD_INFOGENE_OBJET);
        objetEditor.setExtensionName(Form.EXT_INFOGENE);
        objetEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        objetEditor.setFieldName(Form.FIELD_INFOGENE_OBJET);
        idEditor.setExtensionFieldName(Form.FIELD_INFOGENE_ID);
        idEditor.setExtensionName(Form.EXT_INFOGENE);
        idEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        idEditor.setFieldName(Form.FIELD_INFOGENE_ID);
        entityEditor.setExtensionFieldName(Form.FIELD_INFOGENE_ENTITY);
        entityEditor.setExtensionName(Form.EXT_INFOGENE);
        entityEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        entityEditor.setFieldName(Form.FIELD_INFOGENE_ENTITY);
        countryEditor.setExtensionFieldName(Form.FIELD_INFOGENE_COUNTRY);
        countryEditor.setExtensionName(Form.EXT_INFOGENE);
        countryEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        countryEditor.setFieldName(Form.FIELD_INFOGENE_COUNTRY);
        departmentEditor.setExtensionFieldName(Form.FIELD_INFOGENE_DEPARTMENT);
        departmentEditor.setExtensionName(Form.EXT_INFOGENE);
        departmentEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        departmentEditor.setFieldName(Form.FIELD_INFOGENE_DEPARTMENT);
        datePubEditor.setExtensionFieldName(Form.FIELD_FORM_DATEPUB);
        datePubEditor.setExtensionName(Form.EXT_FORM);
        datePubEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePubEditor.setFieldName(Form.FIELD_FORM_DATEPUB);
        datePeremeptionEditor.setExtensionFieldName(Form.FIELD_FORM_DATEPEREMPTION);
        datePeremeptionEditor.setExtensionName(Form.EXT_FORM);
        datePeremeptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.DATE_TIME.getFieldType()));
        datePeremeptionEditor.setFieldName(Form.FIELD_FORM_DATEPEREMPTION);
        sourceTextEditor.setExtensionFieldName(Form.FIELD_INFOGENE_SOURCETEXT);
        sourceTextEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceTextEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.STRING.getFieldType()));
        sourceTextEditor.setFieldName(Form.FIELD_INFOGENE_SOURCETEXT);
        sourceURLEditor.setExtensionFieldName(Form.FIELD_INFOGENE_SOURCEURL);
        sourceURLEditor.setExtensionName(Form.EXT_INFOGENE);
        sourceURLEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.URL.getFieldType()));
        sourceURLEditor.setFieldName(Form.FIELD_INFOGENE_SOURCEURL);
        descriptionEditor.setExtensionFieldName(Form.FIELD_INFOGENE_DESCRIPTION);
        descriptionEditor.setExtensionName(Form.EXT_INFOGENE);
        descriptionEditor.setFieldDescription(VradiHelper.getFieldTypeDescription(FieldTypeEnum.TEXT.getFieldType()));
        descriptionEditor.setFieldName(Form.FIELD_INFOGENE_DESCRIPTION);
        $JSplitPane0.setOrientation(JSplitPane.VERTICAL_SPLIT);
        $Table0.setMinimumSize(new Dimension(0,0));
        addFile.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        removeFile.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("remove"));
        embeddedFileList.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        embeddedFileList.setModel(embeddedFileListModel);
        addAttachment.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        removeAttachment.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("remove"));
        attachmentFileList.setCellRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        attachmentFileList.setModel(attachmentFileListModel);
        propositionList.setCellRenderer(new ThesaurusHighlighter(ThesaurusHighlighter.HighlighterType.PROPOSITION));
        propositionList.setModel(getPropositionListModel());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("offerEditUI", this);
        createData();
        createPropositionListModel();
        createEmbeddedFileListModel();
        createAttachmentFileListModel();
        createEmbeddedFilesToUpload();
        createAttachmentFilesToUpload();
        createValide();
        createErrorEditorTable();
        createOfferEdit();
        createFormSplitPane();
        createFormPane();
        createFormScrollPane();
        createFormContentPane();
        createObjetEditor();
        createIdEditor();
        createEntityEditor();
        createCountryEditor();
        createDepartmentEditor();
        createDatePubEditor();
        createDatePeremeptionEditor();
        createSourceTextEditor();
        createSourceURLEditor();
        createContent();
        createDescriptionEditor();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new javax.swing.JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        $JSplitPane0.setOneTouchExpandable(true);
        $JSplitPane0.setResizeWeight(0.8);
        $JSplitPane0.setContinuousLayout(true);
        $JSplitPane0.setDividerSize(12);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.offerEdit.embeddedfile"));
        createAddFile();
        createRemoveFile();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createEmbeddedFileList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new javax.swing.JPanel());
        
        $JPanel1.setName("$JPanel1");
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.offerEdit.attachmentfile"));
        createAddAttachment();
        createRemoveAttachment();
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createAttachmentFileList();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.edit.proposition"));
        // inline creation of $JScrollPane2
        $objectMap.put("$JScrollPane2", $JScrollPane2 = new javax.swing.JScrollPane());
        
        $JScrollPane2.setName("$JScrollPane2");
        createPropositionList();
        createThesaurus();
        createActionPanel();
        createStatusButtonPanel();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.status.validate"));
        createLastModified();
        createAnnuler();
        createFindQueriesButton();
        createViewPDF();
        // inline creation of offerEditUI
        setName("offerEditUI");
        setLayout(new BorderLayout());
        
        // registers 11 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 11 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJET_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("objet", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    objetEditor.setValue(data.getObjet());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("objet", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ID_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    idEditor.setValue(data.getId());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ENTITY_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("entity", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    entityEditor.setValue(data.getEntity());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("entity", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COUNTRY_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("country", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    countryEditor.setValue(data.getCountry());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("country", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEPARTMENT_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("department", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    departmentEditor.setValue(data.getDepartment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("department", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PUB_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("datePub", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    datePubEditor.setValue(data.getDatePub());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("datePub", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_PEREMEPTION_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("datePeremption", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    datePeremeptionEditor.setValue(data.getDatePeremption());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("datePeremption", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_TEXT_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("sourceText", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    sourceTextEditor.setValue(data.getSourceText());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("sourceText", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SOURCE_URLEDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("sourceURL", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    sourceURLEditor.setValue(data.getSourceURL());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("sourceURL", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_EDITOR_VALUE, true) {
        
            @Override
            public void applyDataBinding() {
                if (data != null) {
                    data.addPropertyChangeListener("description", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (data != null) {
                    descriptionEditor.setValue(data.getDescription());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (data != null) {
                    data.removePropertyChangeListener("description", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROPOSITION_LIST_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (propositionList != null) {
                    propositionList.addPropertyChangeListener("selectionModel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (propositionList != null) {
                    propositionList.setSelectionModel(new OneClicListSelectionModel(propositionList.getSelectionModel(), propositionListModel));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (propositionList != null) {
                    propositionList.removePropertyChangeListener("selectionModel", this);
                }
            }
        });
    }

}