/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.util.Seqno;
import org.jgroups.util.SeqnoComparator;
import org.jgroups.util.SeqnoRange;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=false)
public class SeqnoComparatorTest {
    static final SeqnoComparator comp = new SeqnoComparator();

    public static void testTwoSeqnos() {
        Seqno s1 = new Seqno(10L);
        Seqno s2 = new Seqno(10L);
        assert (comp.compare(s1, s2) == 0);
        s1 = new Seqno(9L);
        assert (comp.compare(s1, s2) == -1);
        s2 = new Seqno(5L);
        assert (comp.compare(s1, s2) == 1);
    }

    public static void compareDummyWithSeqnoRange() {
        Seqno s1 = new Seqno(10L, true);
        SeqnoRange s2 = new SeqnoRange(1L, 100L);
        assert (comp.compare(s1, s2) == 0);
        s1 = new Seqno(1L, true);
        assert (comp.compare(s1, s2) == 0);
        s1 = new Seqno(100L, true);
        assert (comp.compare(s1, s2) == 0);
        s1 = new Seqno(0L, true);
        assert (comp.compare(s1, s2) == -1);
        s1 = new Seqno(101L, true);
        assert (comp.compare(s1, s2) == 1);
    }

    public static void compareDummyWithSeqno() {
        Seqno s1 = new Seqno(10L, true);
        Seqno s2 = new Seqno(10L);
        assert (comp.compare(s1, s2) == 0);
        s1 = new Seqno(9L, true);
        assert (comp.compare(s1, s2) == -1);
        s1 = new Seqno(11L, true);
        assert (comp.compare(s1, s2) == 1);
    }

    public static void compareSeqnoRangeWithDummy() {
        SeqnoRange s1 = new SeqnoRange(1L, 100L);
        Seqno s2 = new Seqno(10L, true);
        assert (comp.compare(s1, s2) == 0);
        s2 = new Seqno(1L, true);
        assert (comp.compare(s1, s2) == 0);
        s2 = new Seqno(100L, true);
        assert (comp.compare(s1, s2) == 0);
        s2 = new Seqno(0L, true);
        assert (comp.compare(s1, s2) == 1);
        s2 = new Seqno(101L, true);
        assert (comp.compare(s1, s2) == -1);
    }

    public static void compareSeqnoWithDummy() {
        Seqno s1 = new Seqno(10L);
        Seqno s2 = new Seqno(10L, true);
        assert (comp.compare(s1, s2) == 0);
        s2 = new Seqno(9L, true);
        assert (comp.compare(s1, s2) == 1);
        s2 = new Seqno(11L, true);
        assert (comp.compare(s1, s2) == -1);
    }
}

