/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class PatternTokenizer
extends Tokenizer {
    private final TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private String str;
    private int index;
    private final Pattern pattern;
    private final int group;
    private final Matcher matcher;

    public PatternTokenizer(Reader input, Pattern pattern, int group) throws IOException {
        super(input);
        this.pattern = pattern;
        this.group = group;
        this.str = IOUtils.toString((Reader)input);
        this.matcher = pattern.matcher(this.str);
        this.index = 0;
    }

    public boolean incrementToken() throws IOException {
        if (this.index >= this.str.length()) {
            return false;
        }
        if (this.group >= 0) {
            while (this.matcher.find()) {
                String match = this.matcher.group(this.group);
                if (match.length() == 0) continue;
                this.termAtt.setTermBuffer(match);
                this.index = this.matcher.start(this.group);
                this.offsetAtt.setOffset(this.correctOffset(this.index), this.correctOffset(this.matcher.end(this.group)));
                return true;
            }
            this.index = Integer.MAX_VALUE;
            return false;
        }
        while (this.matcher.find()) {
            if (this.matcher.start() - this.index > 0) {
                this.termAtt.setTermBuffer(this.str, this.index, this.matcher.start() - this.index);
                this.offsetAtt.setOffset(this.correctOffset(this.index), this.correctOffset(this.matcher.start()));
                this.index = this.matcher.end();
                return true;
            }
            this.index = this.matcher.end();
        }
        if (this.str.length() - this.index == 0) {
            this.index = Integer.MAX_VALUE;
            return false;
        }
        this.termAtt.setTermBuffer(this.str, this.index, this.str.length() - this.index);
        this.offsetAtt.setOffset(this.correctOffset(this.index), this.correctOffset(this.str.length()));
        this.index = Integer.MAX_VALUE;
        return true;
    }

    public void end() throws IOException {
        int ofs = this.correctOffset(this.str.length());
        this.offsetAtt.setOffset(ofs, ofs);
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.str = IOUtils.toString((Reader)input);
        this.matcher.reset(this.str);
        this.index = 0;
    }
}

