/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.QueryMakerViewUI;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.offer.OfferEditHandler;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.VradiTabHeader;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.offer.thesaurus.helpers.ThesaurusSelectionManager;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.WikittyException;

public class OfferListHandler {
    private static final Log log = LogFactory.getLog(OfferListHandler.class);
    public static final int TABPANEL_LABEL_MAX_CHAR_NB = 30;

    public OfferListUI initUI(JAXXContext rootContext) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
        SearchHandler searchHandler = UIHelper.getHandler((JAXXContext)context, SearchHandler.class);
        OfferListTableModel offerListTableModel = new OfferListTableModel();
        OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
        context.add((Object)offerListTableModel);
        context.add((Object)offerListColumnFactory);
        OfferListUI ui = new OfferListUI((JAXXContext)context);
        OfferTable listTable = ui.getListTable();
        listTable.getColumnModel().addColumnModelListener((TableColumnModelListener)this.getOfferListTableColumnModelListener());
        MouseListener offerListTableMouseListener = this.getOfferListTableMouseListener();
        listTable.addMouseListener(offerListTableMouseListener);
        TableModelListener offerListTableModelListener = this.getOfferListTableModelListener(listTable);
        offerListTableModel.addTableModelListener(offerListTableModelListener);
        OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
        listTable.setDefaultRenderer(Boolean.class, renderer);
        listTable.setDefaultRenderer(Date.class, renderer);
        listTable.setDefaultRenderer(Double.class, renderer);
        listTable.setDefaultRenderer(String.class, renderer);
        listTable.setDefaultRenderer(XmlStream.class, renderer);
        listTable.setDefaultRenderer(Status.class, renderer);
        Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
        listTable.addHighlighter(highlighter);
        SearchUI searchUI = searchHandler.initUI(rootContext, offerListTableModel);
        searchUI.setOfferListUI(true);
        ui.setSearchUI(searchUI);
        return ui;
    }

    protected TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    protected TableColumnModelExtListener getOfferListTableColumnModelListener() {
        return new TableColumnModelExtListener(){

            public void columnPropertyChange(PropertyChangeEvent paramPropertyChangeEvent) {
                String propertyName = paramPropertyChangeEvent.getPropertyName();
                if ("visible".equals(propertyName)) {
                    Boolean visible;
                    TableColumnExt column = (TableColumnExt)paramPropertyChangeEvent.getSource();
                    String fqFieldName = (String)column.getClientProperty((Object)"fqFieldName");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("clientprop: " + fqFieldName));
                        log.trace((Object)("identifier: " + column.getIdentifier()));
                    }
                    if ((visible = (Boolean)paramPropertyChangeEvent.getNewValue()).booleanValue()) {
                        VradiHelper.addVradiListColumns(fqFieldName);
                    } else {
                        VradiHelper.removeVradiListColumns(fqFieldName);
                    }
                }
            }

            public void columnAdded(TableColumnModelEvent e) {
            }

            public void columnRemoved(TableColumnModelEvent e) {
            }

            public void columnMoved(TableColumnModelEvent e) {
            }

            public void columnMarginChanged(ChangeEvent e) {
            }

            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        };
    }

    public MouseListener getOfferListTableMouseListener() {
        return new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                JTable listTable = (JTable)e.getSource();
                OfferListUI offerListUI = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    try {
                        offerListUI.setCursor(Cursor.getPredefinedCursor(3));
                        OfferListHandler.this.selectOffer((JAXXContext)offerListUI, listTable);
                    }
                    catch (Exception ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't open offer", (Throwable)ex);
                        }
                        ErrorDialogUI.showError((Exception)ex);
                    }
                    finally {
                        offerListUI.setCursor(null);
                    }
                } else if (e.getButton() == 3) {
                    int[] selectedRows = offerListUI.getListTable().getSelectedRows();
                    int rowClicked = offerListUI.getListTable().rowAtPoint(e.getPoint());
                    boolean rowClickedSelected = false;
                    if (selectedRows == null || selectedRows.length == 0) {
                        offerListUI.getListTable().getSelectionModel().setSelectionInterval(rowClicked, rowClicked);
                        rowClickedSelected = true;
                    } else {
                        int i = 0;
                        while (i < selectedRows.length && !rowClickedSelected) {
                            rowClickedSelected = rowClicked == selectedRows[i++];
                        }
                    }
                    if (rowClickedSelected) {
                        OfferListHandler.this.showOfferListContextMenu(offerListUI, e);
                    }
                }
            }
        };
    }

    protected void showOfferListContextMenu(OfferListUI offerListUI, MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenu changeStatus = new JMenu(I18n._("vradi.offer.status.change"));
        List<Status> statuses = AdminHandler.getAllStatuses();
        for (Status status : statuses) {
            JMenuItem statusItem = new JMenuItem(I18n._(status.getName()));
            statusItem.addActionListener(new StatusActionListener(offerListUI, status));
            changeStatus.add(statusItem);
        }
        menu.add(changeStatus);
        menu.add(new JSeparator());
        JMenu addSending = new JMenu(I18n._("vradi.offer.email.add"));
        JMenuItem addUserSendingItem = new JMenuItem(I18n._("vradi.email.addUser"));
        addUserSendingItem.addActionListener(new UserAddSendingListener(offerListUI));
        JMenuItem addgroupSendingItem = new JMenuItem(I18n._("vradi.email.addGroup"));
        addgroupSendingItem.addActionListener(new GroupAddSendingListener(offerListUI));
        addSending.add(addUserSendingItem);
        addSending.add(addgroupSendingItem);
        menu.add(addSending);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected <E extends BusinessEntity> void addUserAndGroupSending(final QueryMakerViewUI<E> ui, final Class<E> clazz) {
        VradiTask<Void> addUserAndGroupSendingTask = new VradiTask<Void>(ui, false){

            @Override
            public Void doAction() throws Exception {
                try {
                    Form form = ui.getForm();
                    Session session = ui.getSession();
                    EmailHandler handler = ui.getHandler();
                    if (form != null) {
                        if (clazz == User.class) {
                            handler.addAllUserSending(ui, session, form.getWikittyId(), ui.getQueryMakerForm().getListDatas());
                        } else {
                            handler.addAllGroupSending((JAXXContext)ui, session, form.getWikittyId(), ui.getQueryMakerForm().getListDatas());
                        }
                    } else {
                        List<String> formsIds = ui.getFormsIds();
                        if (clazz == User.class) {
                            handler.addAllUserSending(ui, session, formsIds, ui.getQueryMakerForm().getListDatas());
                        } else {
                            handler.addAllGroupSending((JAXXContext)ui, session, formsIds, ui.getQueryMakerForm().getListDatas());
                        }
                    }
                }
                catch (Exception eee) {
                    log.error((Object)"Cant add group or user to session : ", (Throwable)eee);
                    ErrorDialogUI.showError((Exception)eee);
                }
                return null;
            }
        };
        addUserAndGroupSendingTask.execute();
    }

    protected void changeStatus(JAXXContext context, String formId, Status status) {
        block4: {
            try {
                Form form = (Form)VradiService.getWikittyProxy().restore(Form.class, formId);
                String initialStatus = form.getStatus();
                String updateStatus = status.getWikittyId();
                if (initialStatus == null || !updateStatus.equals(initialStatus)) {
                    VradiUser vradiUser = (VradiUser)context.getContextValue(VradiUser.class);
                    String statusModifier = vradiUser != null ? vradiUser.getLogin() : null;
                    ModificationTag formTag = (ModificationTag)VradiService.getWikittyProxy().cast((BusinessEntity)form, ModificationTag.class);
                    formTag.setLastModified(new Date());
                    formTag.setLastModifier(statusModifier);
                    formTag.setLastStatusModifier(statusModifier);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Updating: statusModifier=%s on form: %s", statusModifier, form.getWikittyId()));
                        log.debug((Object)String.format("New Status: %s, Old Status: %s", initialStatus, updateStatus));
                    }
                }
                form.setStatus(updateStatus);
                VradiService.getWikittyProxy().store((BusinessEntity)form);
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't change status", (Throwable)eee);
            }
        }
    }

    public void addEditPane(JAXXContext context, String formId) {
        Form form = (Form)VradiService.getWikittyProxy().restore(Form.class, formId);
        this.addEditPane(context, form);
    }

    public void addEditPane(JAXXContext context, final Form form) {
        OfferListUI ui = this.getUI(context);
        ui.setDividerLocation(0);
        ui.setResizeWeight(0.0);
        ui.setDividerSize(12);
        JTabbedPane contentTabbedPane = ui.getEditTabs();
        String formId = form.getWikittyId();
        if (contentTabbedPane.indexOfTab(formId) < 0) {
            OfferEditUI editUi;
            final OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
            try {
                editUi = handler.initUI(context, form);
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't init UI", (Throwable)eee);
                }
                ErrorDialogUI.showError((Exception)eee);
                return;
            }
            if (editUi == null) {
                return;
            }
            final OfferEditUI editUiFinal = editUi;
            contentTabbedPane.add(formId, editUiFinal);
            final VradiTabHeader panel = new VradiTabHeader();
            if (form.getObjet() != null) {
                String panelLabel = form.getObjet().length() < 30 ? form.getObjet() : form.getObjet().substring(0, 30) + "...";
                panel.getLabel().setText(panelLabel);
            }
            panel.setId(formId);
            contentTabbedPane.setTabComponentAt(contentTabbedPane.indexOfTab(formId), (Component)((Object)panel));
            panel.getCloseTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUiFinal, panel.getId());
                }
            });
            panel.getDetachTab().addMouseListener(new MouseInputAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    OfferListHandler.this.detachPane(e);
                }
            });
            List<Status> statuses = AdminHandler.getAllStatuses();
            ArrayList<Status> orderedStatus = new ArrayList<Status>(statuses);
            Collections.sort(orderedStatus, VradiComparators.STATUSES_COMPARATOR);
            JPanel buttonPanel = editUiFinal.getStatusButtonPanel();
            for (final Status status : orderedStatus) {
                JButton statusButton = new JButton(I18n._(status.getName()));
                statusButton.setToolTipText(status.getDescription());
                if (status.getWikittyId().equals(form.getStatus())) {
                    Color newColor = new Color(110, 150, 200, statusButton.getBackground().getAlpha());
                    statusButton.setBackground(newColor);
                }
                statusButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        OfferListHandler.this.closePane((JAXXContext)editUiFinal, panel.getId());
                        handler.changeStatusAndSave((JAXXContext)editUiFinal, form, status);
                    }
                });
                buttonPanel.add(statusButton);
            }
            editUiFinal.getAnnuler().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OfferListHandler.this.closePane((JAXXContext)editUiFinal, panel.getId());
                }
            });
        }
        contentTabbedPane.setSelectedIndex(contentTabbedPane.indexOfTab(formId));
    }

    protected VradiTabHeader getTabHeader(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        return (VradiTabHeader)((Object)button.getParent());
    }

    protected void closePane(JAXXContext context, String id) {
        ThesaurusSelectionManager selectionManager = (ThesaurusSelectionManager)context.getContextValue(ThesaurusSelectionManager.class);
        selectionManager.unRegisterAllWikittyListener();
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        int index = contentTabbedPane.indexOfTab(id);
        if (index > -1) {
            contentTabbedPane.remove(index);
        }
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected void detachPane(MouseEvent e) {
        VradiTabHeader mytab = this.getTabHeader(e);
        String id = mytab.getId();
        String name = mytab.getLabel().getText();
        OfferListUI ui = mytab.getParentContainer(OfferListUI.class);
        JTabbedPane contentTabbedPane = this.getContentPane(ui);
        OfferEditUI content = this.getOfferEdit(contentTabbedPane, id);
        final JFrame frame = new JFrame(name);
        content.getAnnuler().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OfferListHandler.this.closeDetachedPane(frame);
            }
        });
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                OfferListHandler.this.closeDetachedPane(frame);
            }
        });
        frame.setLayout(new BorderLayout());
        frame.add((Component)content, "Center");
        frame.setVisible(true);
        frame.setSize(new Dimension(800, 800));
        this.allEditPanelRemoved(contentTabbedPane, ui);
    }

    protected OfferEditUI getOfferEdit(JTabbedPane contentTabbedPane, String id) {
        return (OfferEditUI)contentTabbedPane.getComponentAt(contentTabbedPane.indexOfTab(id));
    }

    protected void closeDetachedPane(JFrame f) {
        f.dispose();
    }

    public void addEditPane(JAXXContext context, List<Form> datas) {
        for (Form data : datas) {
            this.addEditPane(context, data.getWikittyId());
        }
    }

    protected void allEditPanelRemoved(JTabbedPane contentTabbedPane, OfferListUI ui) {
        if (contentTabbedPane.getTabCount() == 0) {
            ui.setDividerLocation(Integer.MAX_VALUE);
            ui.setResizeWeight(1.0);
            ui.setDividerSize(0);
        }
    }

    public OfferListUI getUI(JAXXContext context) {
        if (context instanceof OfferListUI) {
            return (OfferListUI)context;
        }
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    protected JTabbedPane getContentPane(JAXXContext context) {
        OfferListUI ui = this.getUI(context);
        return ui.getEditTabs();
    }

    protected JTabbedPane getContentPane(OfferListUI ui) {
        return ui.getEditTabs();
    }

    protected void selectOffer(JAXXContext context, JTable listTable) {
        OfferListTableModel tableModel = (OfferListTableModel)listTable.getModel();
        int selectedRow = listTable.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < tableModel.getRowCount()) {
            selectedRow = listTable.convertRowIndexToModel(selectedRow);
            FormPagedResult formPageDTO = tableModel.getFormPagedResult();
            List formsToShow = formPageDTO.getFormsIdsToShow();
            String formId = (String)formsToShow.get(selectedRow);
            if (formId != null) {
                if (log.isDebugEnabled()) {
                    Form form = (Form)VradiService.getWikittyProxy().restore(Form.class, formId);
                    log.debug((Object)("Show Form: " + form.getObjet()));
                }
                this.addEditPane(context, formId);
            }
        }
    }

    protected class StatusActionListener
    implements ActionListener {
        protected Status status;
        protected OfferListUI offerListUI;

        public StatusActionListener(OfferListUI offerListUI, Status status) {
            this.offerListUI = offerListUI;
            this.status = status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int confirm = JOptionPane.showConfirmDialog(this.offerListUI, I18n._("vradi.offerList.status.change.confirmation.message", I18n._(this.status.getName())), I18n._("vradi.offerList.status.change.confirmation.title"), 0);
            if (confirm == 0) {
                this.offerListUI.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    int[] selectedRows;
                    for (int row : selectedRows = this.offerListUI.getListTable().getSelectedRows()) {
                        OfferTable listTable = this.offerListUI.getListTable();
                        OfferListTableModel tableModel = this.offerListUI.getOfferListTableModel();
                        row = listTable.convertRowIndexToModel(row);
                        FormPagedResult formPageDTO = tableModel.getFormPagedResult();
                        List formsIdsToShow = formPageDTO.getFormsIdsToShow();
                        String formId = (String)formsIdsToShow.get(row);
                        if (formId == null) continue;
                        OfferListHandler.this.changeStatus((JAXXContext)this.offerListUI, formId, this.status);
                    }
                }
                catch (WikittyException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't change offer status", (Throwable)eee);
                    }
                    ErrorDialogUI.showError((Exception)((Object)eee));
                }
                finally {
                    this.offerListUI.setCursor(null);
                }
            }
        }
    }

    protected class UserAddSendingListener
    extends AddSendingListener {
        public UserAddSendingListener(OfferListUI offerListUI) {
            super(offerListUI);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openUI(User.class, "vradi.email.addUser", this.getAdminHandler().getAllUsers());
        }
    }

    protected class GroupAddSendingListener
    extends AddSendingListener {
        public GroupAddSendingListener(OfferListUI offerListUI) {
            super(offerListUI);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openUI(Group.class, "vradi.email.addGroup", this.getAdminHandler().getAllGroups());
        }
    }

    protected abstract class AddSendingListener
    implements ActionListener {
        protected OfferListUI offerListUI;
        protected List<String> formsIdsToUpdate = new ArrayList<String>();

        protected AddSendingListener(OfferListUI offerListUI) {
            int[] selectedRows;
            this.offerListUI = offerListUI;
            for (int row : selectedRows = offerListUI.getListTable().getSelectedRows()) {
                OfferTable listTable = offerListUI.getListTable();
                OfferListTableModel tableModel = offerListUI.getOfferListTableModel();
                row = listTable.convertRowIndexToModel(row);
                FormPagedResult formPage = tableModel.getFormPagedResult();
                List formsIdsToShow = formPage.getFormsIdsToShow();
                String formId = (String)formsIdsToShow.get(row);
                if (formId == null) continue;
                this.formsIdsToUpdate.add(formId);
            }
        }

        protected AdminHandler getAdminHandler() {
            return UIHelper.getHandler((JAXXContext)this.offerListUI, AdminHandler.class);
        }

        protected <E extends BusinessEntity> void openUI(final Class<E> clazz, String title, List<E> all) {
            block6: {
                try {
                    Session currentSession = VradiService.getVradiDataService().getLastOpenSession();
                    if (currentSession == null) {
                        JOptionPane.showMessageDialog(this.offerListUI, I18n._("Can't found any opened mail session, please create a new session in mail management"), I18n._("Error"), 0);
                    } else {
                        for (String formId : this.formsIdsToUpdate) {
                            Status selectionne = VradiHelper.getSelectionneStatus();
                            Form form = (Form)VradiService.getWikittyProxy().restore(Form.class, formId);
                            if (form.getStatus().equals(selectionne.getWikittyId())) continue;
                            int responce = JOptionPane.showConfirmDialog(OfferListHandler.this.getUI((JAXXContext)this.offerListUI), I18n._("vradi.email.confirmSelectionForm", form.getObjet()), I18n._("vradi.email.confirmSelectionForm.title"), 0);
                            if (responce == 0) {
                                OfferListHandler.this.changeStatus((JAXXContext)OfferListHandler.this.getUI((JAXXContext)this.offerListUI), formId, selectionne);
                                continue;
                            }
                            return;
                        }
                        VradiMainUI mainUI = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)this.offerListUI);
                        final JDialog ui = new JDialog((Frame)mainUI, I18n._(title));
                        ui.setLayout(new BorderLayout());
                        final QueryMakerViewUI<E> makerViewUI = new QueryMakerViewUI<E>((JAXXContext)this.offerListUI);
                        makerViewUI.setSession(currentSession);
                        makerViewUI.setFormsIds(this.formsIdsToUpdate);
                        makerViewUI.setClazz(clazz);
                        makerViewUI.init(all, new ArrayList());
                        ui.add(makerViewUI, "Center");
                        JButton validButton = new JButton(I18n._("vradi.action.valid"));
                        validButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                OfferListHandler.this.addUserAndGroupSending(makerViewUI, clazz);
                                ui.setVisible(false);
                                ui.dispose();
                            }
                        });
                        ui.add((Component)validButton, "South");
                        ui.setModal(true);
                        ui.setSize(800, 600);
                        ui.setLocationRelativeTo(mainUI);
                        ui.setVisible(true);
                    }
                }
                catch (VradiException ex) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Can't get current opened session", (Throwable)ex);
                }
            }
        }
    }
}

