/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.content;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.regex.Matcher;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class XmlStreamConfigUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.content.XmlStreamConfigUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected com.jurismarches.vradi.entities.XmlStream bean;
    protected javax.swing.JComboBox hourDays;
    protected javax.swing.JComboBox minuteDays;
    protected XmlStreamConfigUI xmlStreamConfigUI = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected ComboBoxModel minutesModel;
    protected ComboBoxModel hoursModel;
    protected ComboBoxModel daysModel;
    
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    void $afterCompleteSetup() {
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getBean() != null) {
                
    
                    // Parse la valeur ImportTime du bean XmlStream courant et
                    // initialise correctement les differents panel.
                    //
                    // Dans le cas ou le pattern ne match pas, la valeur par defaut
                    // est celle des services (à savoir, tous les 1 jour, à minuit).
                    //
                    String xmlStringImportTime = bean.getImportTime();
    
                    if (xmlStringImportTime != null && !xmlStringImportTime.isEmpty()) {
                        Matcher matcher = VradiConstants.XML_STREAM_IMPORT_TIME.matcher(xmlStringImportTime);
            
                        if (matcher.find()) {
                            // selection des heures
                            hourDays.setSelectedItem(Integer.valueOf(matcher.group(1)));
                            // selection de la minutes
                            minuteDays.setSelectedItem(Integer.valueOf(matcher.group(2)));
                        }
                    }
                } else {
                    // clear UI
                    hourDays.setSelectedItem(0);
                    minuteDays.setSelectedItem(0);;
                }
            }
        });
    }
    
    /**
     * Set import time value into bean.
     */
    protected void setImportTimeValue() {
        if (bean != null) {
            String importTime = null;
            importTime = hourDays.getSelectedItem().toString() + ":" + minuteDays.getSelectedItem().toString();
            bean.setImportTime(importTime);
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public XmlStreamConfigUI() {
        $initialize();
    }

    public XmlStreamConfigUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__hourDays(java.awt.event.ActionEvent event) {
        setImportTimeValue();
    }

    public void doActionPerformed__on__minuteDays(java.awt.event.ActionEvent event) {
        setImportTimeValue();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.entities.XmlStream getBean() {
        return bean;
    }

    public javax.swing.JComboBox getHourDays() {
        return hourDays;
    }

    public javax.swing.JComboBox getMinuteDays() {
        return minuteDays;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(com.jurismarches.vradi.entities.XmlStream newValue) {
        com.jurismarches.vradi.entities.XmlStream oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange(PROPERTY_BEAN, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToXmlStreamConfigUI() {
        if (!allComponentsCreated) {
            return;
        }
        add($JLabel0);
        add(hourDays);
        add($JLabel1);
        add(minuteDays);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createHourDays() {
        $objectMap.put("hourDays", hourDays = new javax.swing.JComboBox());
        
        hourDays.setName("hourDays");
        hourDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hourDays"));
    }

    protected void createMinuteDays() {
        $objectMap.put("minuteDays", minuteDays = new javax.swing.JComboBox());
        
        minuteDays.setName("minuteDays");
        minuteDays.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__minuteDays"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToXmlStreamConfigUI();
        
        // apply 6 property setters
        hourDays.setModel(UIHelper.getHourModel());
        hourDays.setRenderer(UIHelper.get2DigitsRenderer());
        hourDays.setSelectedItem(0);
        minuteDays.setModel(UIHelper.getMinuteModel());
        minuteDays.setRenderer(UIHelper.get2DigitsRenderer());
        minuteDays.setSelectedItem(0);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("xmlStreamConfigUI", this);
        createBean();
        minutesModel = new DefaultComboBoxModel(new Object[]{15, 30, 45});
        hoursModel = UIHelper.getNumberComboBoxModel(1, 24);
        daysModel = UIHelper.getNumberComboBoxModel(1, 31);
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.adminXmlStream.config.load"));
        createHourDays();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.common.timeseparator"));
        createMinuteDays();
        // inline creation of xmlStreamConfigUI
        setName("xmlStreamConfigUI");
        
        $completeSetup();
    }

}