/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.search.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import java.util.Calendar;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.EntityComboBox;
import jaxx.runtime.swing.OneClicListSelectionModel;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import org.nuiton.wikitty.WikittyExtension;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class CriteriaUI extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATE_SELECTION_MODEL = "dateSelectionModel";
    public static final String PROPERTY_FORM_TYPE_SELECTION_MODEL = "formTypeSelectionModel";
    public static final String PROPERTY_STATUS_SELECTION_MODEL = "statusSelectionModel";
    public static final String PROPERTY_XML_STREAMS_SELECTION_MODEL = "xmlStreamsSelectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DATE_TYPE_SELECTION_MODEL = "dateTypeSelection.model";
    public static final String BINDING_STATUS_SELECTION_SELECTION_MODEL = "statusSelection.selectionModel";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWYz28bRRTHJ6ZO4qQlNKFpAy1K2wghitYhKa1QSmjrEBxj0ygOUoQlxNg7jifd3VlmZpM1Qgj+A/4EuHNB4sYJcUDihhAXxL+AEAeuiDfr9a5/bNYrTQ4be997n3nvu/PmbfLtXygvOLp5gn3f4J4jqU2MyqOjoyfNE9KSO0S0OHUl46j3M5VDuQaaN6P7QqLbjaoKL4bhxRKzXeYQZyB6q4rmhOxaRHQIkRLdGI5oCVGsR+Yt3/V4nxollUT9+p+/c1+ZX3yTQ8h3IbtbUMrqpKi4kgtVlKOmRIuw0ikuWtg5hjQ4dY4h30vqXsnCQryPbfIJ+hzNVNG0iznAJLqVveSAEcT7rkTTbWpJwiW602K2ceJxKmzMWx0ijFOOTWp41BBE3TFKnIInxR/suW4AmIZUTSxJnVjwbChzaswkllQln2LfEGeQubFD2tizJGTUZI+ZH7jE8cttxu3DrjvGWBlknBN8zbct0IdgWwyHK/vl2O95IbH0xOgSVwaXqFIhR/Aza4e4aZF1WGjoGfYCApvyLIwGvK6+rqjL1cg0u1ap4iaxALY4uGzvrnJ6IfZtc2bvgK6gJOPHxgns7qeSub0Q36gcKeM+bT0lPCGyzDw+UlylL+CIe5hUkPBLw7Y5hapRx5NBkWvJkRsJkdOSqfzUt5tjFpVcCm8zgTcr2bl5hIpvJCieP4Q0uhItDQnx2JOSOcplM4ZAQ0jwVV/vD5sKylRjjuwkGOeUcXPdxF2RYA1T20zZDHejarcj2+WxhojK3h4DvJEEUB05CRAmdzcluXsRuxx3e9Rw4/DyGOF+AuHSWqXe4syy9rGjOuvq0NOJTcNRCyMNDFUONxE0r3Ldj9dphYeVglnBOmMdXA4bAmrn6MUhBxgARjwA4hN6qoHy3IPbcCY0xmfGAZh60+LayLRQwMD63/LS7z/8+f1uf0TcgbWvJLoOTDg4ul3OXDimqVp6oTcfPEmtYg27Ww1UEIE0wfi7npBYPTRDcrBeIJ6hwo0yFh1A5Gf++PGn5Y9/fQbldmFfM2zuYuW/hwqyw0EFZpm++/bDIKOLZ7NwfU7lBj1t4S6DpkLPPoCNh1eb1DFB3G0fRLieIEKUSbPw879L9e8e9oWYgsRWznWPxch/iKapY1GHBNMyHISJ03HeFcQzWTzwkkbglPo954bH/kfBtZlU6QVJfKhz8UFv9VUsYTQ34VyCWlVQOyhCfeoEzBtZmGZ4UpJkxmoGRt7uj7xzILczQGbhNcIkvDdQNDgXexuRmHuS2FosdTuoyk4mvJyJcJaSwyuZCJ9pE77UJqTp8GomQtpzfU1bSUNbyWyENCWzEdKUXNfWYUNbh2yENB2yEdJ0uKdNeFObsKVNeCvDaTVvU4fanl2nn6adwo+0k5lMgKluY18lc8DOSgxGYAqupL1TsxHSdmo2wi8phHe0Zc1GSNPhXW0dshHSdHhPW4dshN9SCDVtJbMR0pTMRkhT8om2kpMJ8I7TIpZ1MPl96VBb08kEeO8WY//60KAtnFJB4S/DDIeQwv0PJcCGW68TAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.search.CriteriaUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton ToDay;
    protected jaxx.runtime.swing.HBox criteriaPanel;
    protected javax.swing.DefaultComboBoxModel dateSelectionModel;
    protected javax.swing.JComboBox dateTypeSelection;
    protected CriteriaUI filter = this;
    protected javax.swing.JComboBox formTypeSelection;
    protected javax.swing.ComboBoxModel formTypeSelectionModel;
    protected org.jdesktop.swingx.JXDatePicker fromDate;
    protected javax.swing.JComboBox fromHour;
    protected javax.swing.JComboBox fromMinute;
    protected javax.swing.JButton last30days;
    protected javax.swing.JButton lastDay;
    protected javax.swing.JButton lastMonth;
    protected javax.swing.JList statusSelection;
    protected javax.swing.ListModel statusSelectionModel;
    protected org.jdesktop.swingx.JXDatePicker toDate;
    protected javax.swing.JComboBox toHour;
    protected javax.swing.JComboBox toMinute;
    protected javax.swing.JComboBox xmlStreamSelection;
    protected javax.swing.ComboBoxModel xmlStreamsSelectionModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private jaxx.runtime.swing.Table $Table2;
    private jaxx.runtime.swing.Table $Table3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private jaxx.runtime.swing.Table $Table4;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    public SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    void $afterCompleteSetup() {
        updateDateSelectionModel();
    }
    protected void updateDateSelectionModel() {
        setDateSelectionModel(getHandler().updateDateSelectionModel(
                (WikittyExtension)formTypeSelection.getSelectedItem()));
        if (log.isDebugEnabled()) {
            for(int i = 0 ; i < dateSelectionModel.getSize() ; i++) {
                log.debug(dateSelectionModel.getElementAt(i));
            }
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CriteriaUI() {
        $initialize();
    }

    public CriteriaUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__ToDay(java.awt.event.ActionEvent event) {
        fromDate.setDate(new Date()); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                      toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__formTypeSelection(java.awt.event.ActionEvent event) {
        updateDateSelectionModel();
    }

    public void doActionPerformed__on__last30days(java.awt.event.ActionEvent event) {
        fromDate.setDate(DateUtils.addDays(new Date(), -30)); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                      toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__lastDay(java.awt.event.ActionEvent event) {
        fromDate.setDate(DateUtils.truncate(DateUtils.addDays(new Date(), -1), Calendar.DAY_OF_MONTH)); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                      toDate.setDate(DateUtils.truncate(DateUtils.addDays(new Date(), -1), Calendar.DAY_OF_MONTH)); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    public void doActionPerformed__on__lastMonth(java.awt.event.ActionEvent event) {
        fromDate.setDate(DateUtils.truncate(new Date(), Calendar.MONTH)); fromHour.setSelectedItem(0); fromMinute.setSelectedItem(0);                                      toDate.setDate(new Date()); toHour.setSelectedItem(23); toMinute.setSelectedItem(59);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.runtime.swing.HBox getCriteriaPanel() {
        return criteriaPanel;
    }

    public javax.swing.DefaultComboBoxModel getDateSelectionModel() {
        return dateSelectionModel;
    }

    public javax.swing.JComboBox getDateTypeSelection() {
        return dateTypeSelection;
    }

    public javax.swing.JComboBox getFormTypeSelection() {
        return formTypeSelection;
    }

    public javax.swing.ComboBoxModel getFormTypeSelectionModel() {
        return formTypeSelectionModel;
    }

    public org.jdesktop.swingx.JXDatePicker getFromDate() {
        return fromDate;
    }

    public javax.swing.JComboBox getFromHour() {
        return fromHour;
    }

    public javax.swing.JComboBox getFromMinute() {
        return fromMinute;
    }

    public javax.swing.JButton getLast30days() {
        return last30days;
    }

    public javax.swing.JButton getLastDay() {
        return lastDay;
    }

    public javax.swing.JButton getLastMonth() {
        return lastMonth;
    }

    public javax.swing.JList getStatusSelection() {
        return statusSelection;
    }

    public javax.swing.ListModel getStatusSelectionModel() {
        return statusSelectionModel;
    }

    public org.jdesktop.swingx.JXDatePicker getToDate() {
        return toDate;
    }

    public javax.swing.JButton getToDay() {
        return ToDay;
    }

    public javax.swing.JComboBox getToHour() {
        return toHour;
    }

    public javax.swing.JComboBox getToMinute() {
        return toMinute;
    }

    public javax.swing.JComboBox getXmlStreamSelection() {
        return xmlStreamSelection;
    }

    public javax.swing.ComboBoxModel getXmlStreamsSelectionModel() {
        return xmlStreamsSelectionModel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDateSelectionModel(javax.swing.DefaultComboBoxModel newValue) {
        javax.swing.DefaultComboBoxModel oldValue = this.dateSelectionModel;
        this.dateSelectionModel = newValue;
        firePropertyChange(PROPERTY_DATE_SELECTION_MODEL, oldValue, newValue);
    }

    public void setFormTypeSelectionModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.formTypeSelectionModel;
        this.formTypeSelectionModel = newValue;
        firePropertyChange(PROPERTY_FORM_TYPE_SELECTION_MODEL, oldValue, newValue);
    }

    public void setStatusSelectionModel(javax.swing.ListModel newValue) {
        javax.swing.ListModel oldValue = this.statusSelectionModel;
        this.statusSelectionModel = newValue;
        firePropertyChange(PROPERTY_STATUS_SELECTION_MODEL, oldValue, newValue);
    }

    public void setXmlStreamsSelectionModel(javax.swing.ComboBoxModel newValue) {
        javax.swing.ComboBoxModel oldValue = this.xmlStreamsSelectionModel;
        this.xmlStreamsSelectionModel = newValue;
        firePropertyChange(PROPERTY_XML_STREAMS_SELECTION_MODEL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected jaxx.runtime.swing.Table get$Table2() {
        return $Table2;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFilter() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createCriteriaPanel() {
        $objectMap.put("criteriaPanel", criteriaPanel = new jaxx.runtime.swing.HBox());
        
        criteriaPanel.setName("criteriaPanel");
    }

    protected void createDateSelectionModel() {
        $objectMap.put("dateSelectionModel", dateSelectionModel = new DefaultComboBoxModel());
    }

    protected void createDateTypeSelection() {
        $objectMap.put("dateTypeSelection", dateTypeSelection = new javax.swing.JComboBox());
        
        dateTypeSelection.setName("dateTypeSelection");
    }

    protected void createFormTypeSelection() {
        $objectMap.put("formTypeSelection", formTypeSelection = new javax.swing.JComboBox());
        
        formTypeSelection.setName("formTypeSelection");
        formTypeSelection.setMaximumRowCount(30);
        formTypeSelection.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__formTypeSelection"));
    }

    protected void createFormTypeSelectionModel() {
        $objectMap.put("formTypeSelectionModel", formTypeSelectionModel = UIHelper.getFormTypesModel(true));
    }

    protected void createFromDate() {
        $objectMap.put("fromDate", fromDate = new org.jdesktop.swingx.JXDatePicker());
        
        fromDate.setName("fromDate");
    }

    protected void createFromHour() {
        $objectMap.put("fromHour", fromHour = new javax.swing.JComboBox());
        
        fromHour.setName("fromHour");
    }

    protected void createFromMinute() {
        $objectMap.put("fromMinute", fromMinute = new javax.swing.JComboBox());
        
        fromMinute.setName("fromMinute");
    }

    protected void createLast30days() {
        $objectMap.put("last30days", last30days = new javax.swing.JButton());
        
        last30days.setName("last30days");
        last30days.setText(_("vradi.criteria.searchLast30days"));
        last30days.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__last30days"));
    }

    protected void createLastDay() {
        $objectMap.put("lastDay", lastDay = new javax.swing.JButton());
        
        lastDay.setName("lastDay");
        lastDay.setText(_("vradi.criteria.searchLastDay"));
        lastDay.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lastDay"));
    }

    protected void createLastMonth() {
        $objectMap.put("lastMonth", lastMonth = new javax.swing.JButton());
        
        lastMonth.setName("lastMonth");
        lastMonth.setText(_("vradi.criteria.searchThisMonth"));
        lastMonth.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lastMonth"));
    }

    protected void createStatusSelection() {
        $objectMap.put("statusSelection", statusSelection = new javax.swing.JList());
        
        statusSelection.setName("statusSelection");
        statusSelection.setVisibleRowCount(4);
    }

    protected void createStatusSelectionModel() {
        $objectMap.put("statusSelectionModel", statusSelectionModel = UIHelper.getStatusesModel(false));
    }

    protected void createToDate() {
        $objectMap.put("toDate", toDate = new org.jdesktop.swingx.JXDatePicker());
        
        toDate.setName("toDate");
    }

    protected void createToDay() {
        $objectMap.put("ToDay", ToDay = new javax.swing.JButton());
        
        ToDay.setName("ToDay");
        ToDay.setText(_("vradi.criteria.searchToDay"));
        ToDay.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ToDay"));
    }

    protected void createToHour() {
        $objectMap.put("toHour", toHour = new javax.swing.JComboBox());
        
        toHour.setName("toHour");
    }

    protected void createToMinute() {
        $objectMap.put("toMinute", toMinute = new javax.swing.JComboBox());
        
        toMinute.setName("toMinute");
    }

    protected void createXmlStreamSelection() {
        $objectMap.put("xmlStreamSelection", xmlStreamSelection = new javax.swing.JComboBox());
        
        xmlStreamSelection.setName("xmlStreamSelection");
        xmlStreamSelection.setMaximumRowCount(30);
    }

    protected void createXmlStreamsSelectionModel() {
        $objectMap.put("xmlStreamsSelectionModel", xmlStreamsSelectionModel = UIHelper.getXmlStreamsModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToFilter();
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($Table3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add($Table4, new GridBagConstraints(3, 0, 1, 2, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table0.add(criteriaPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(fromDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(fromHour, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel1, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(fromMinute, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(toDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(toHour, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table1.add(toMinute, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table2
        $Table2.add(ToDay, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(lastDay, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(lastMonth, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table2.add(last30days, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table3
        $Table3.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add(formTypeSelection, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add($JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add(dateTypeSelection, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table4
        $Table4.add($JLabel6, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table4.add(xmlStreamSelection, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table4.add($JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table4.add($JScrollPane0, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(statusSelection);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 26 property setters
        fromDate.setDate(new java.util.Date());
        fromHour.setModel(UIHelper.getHourModel());
        fromHour.setRenderer(UIHelper.get2DigitsRenderer());
        fromHour.setSelectedItem(0);
        fromMinute.setModel(UIHelper.getMinuteModel());
        fromMinute.setRenderer(UIHelper.get2DigitsRenderer());
        fromMinute.setSelectedItem(0);
        toDate.setDate(new java.util.Date());
        toHour.setModel(UIHelper.getHourModel());
        toHour.setRenderer(UIHelper.get2DigitsRenderer());
        toHour.setSelectedItem(23);
        toMinute.setModel(UIHelper.getMinuteModel());
        toMinute.setRenderer(UIHelper.get2DigitsRenderer());
        toMinute.setSelectedItem(59);
        $JLabel4.setMinimumSize(new Dimension(0,0));
        formTypeSelection.setModel(formTypeSelectionModel);
        formTypeSelection.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel5.setMinimumSize(new Dimension(0,0));
        dateTypeSelection.setRenderer(getHandler().getDateTypeComboBoxRenderer());
        $JLabel6.setMinimumSize(new Dimension(0,0));
        xmlStreamSelection.setModel(xmlStreamsSelectionModel);
        xmlStreamSelection.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        $JLabel7.setMinimumSize(new Dimension(0,0));
        statusSelection.setCellRenderer(UIHelper.getStatusCellRenderer());
        statusSelection.setModel(statusSelectionModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("filter", this);
        createDateSelectionModel();
        createFormTypeSelectionModel();
        createXmlStreamsSelectionModel();
        createStatusSelectionModel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("vradi.criteria.from"));
        createFromDate();
        createFromHour();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("vradi.common.timeseparator"));
        createFromMinute();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new javax.swing.JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("vradi.criteria.to"));
        createToDate();
        createToHour();
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new javax.swing.JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("vradi.common.timeseparator"));
        createToMinute();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new jaxx.runtime.swing.Table());
        
        $Table2.setName("$Table2");
        createToDay();
        createLastDay();
        createLastMonth();
        createLast30days();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new jaxx.runtime.swing.Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new javax.swing.JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("vradi.criteria.formType"));
        createFormTypeSelection();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new javax.swing.JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("vradi.criteria.typeDate"));
        createDateTypeSelection();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new jaxx.runtime.swing.Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel6
        $objectMap.put("$JLabel6", $JLabel6 = new javax.swing.JLabel());
        
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("vradi.criteria.xmlStream"));
        createXmlStreamSelection();
        // inline creation of $JLabel7
        $objectMap.put("$JLabel7", $JLabel7 = new javax.swing.JLabel());
        
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("vradi.criteria.status"));
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createStatusSelection();
        createCriteriaPanel();
        // inline creation of filter
        setName("filter");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DATE_TYPE_SELECTION_MODEL, true ,"dateSelectionModel") {
        
            @Override
            public void processDataBinding() {
                dateTypeSelection.setModel(getDateSelectionModel());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_SELECTION_SELECTION_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (statusSelection != null) {
                    statusSelection.addPropertyChangeListener("selectionModel", this);
                }
                if (statusSelection != null) {
                    statusSelection.addPropertyChangeListener("model", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (statusSelection != null) {
                    statusSelection.setSelectionModel(new OneClicListSelectionModel(statusSelection.getSelectionModel(),                                                        statusSelection.getModel()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (statusSelection != null) {
                    statusSelection.removePropertyChangeListener("selectionModel", this);
                }
                if (statusSelection != null) {
                    statusSelection.removePropertyChangeListener("model", this);
                }
            }
        });
    }

}