/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: DateEditorModel.java 1443 2010-09-20 08:50:49Z chatellier $
 * $HeadURL: svn+ssh://chatellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.2.0/vradi-swing/src/main/java/com/jurismarches/vradi/ui/offer/editors/DateEditorModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.offer.editors;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * @author morin
 *         Date: 26 nov. 2009
 *         Time: 19:05:06
 */
public class DateEditorModel extends VradiEditorModel<Date> {

    private static final long serialVersionUID = 1L;

    public int getHour() {
        if(value == null) {
            return 0;
        }
        Calendar cal = new GregorianCalendar();
        cal.setTime(value);
        return cal.get(Calendar.HOUR_OF_DAY);
    }

    public int getMinutes() {
        if(value == null) {
            return 0;
        }
        Calendar cal = new GregorianCalendar();
        cal.setTime(value);
        return cal.get(Calendar.MINUTE);
    }

    public void setHour(int hour) {
        if (value != null) {
            Calendar cal = new GregorianCalendar();
            cal.setTime(value);
            cal.set(Calendar.HOUR_OF_DAY, hour);
            setValue(cal.getTime());
        }
    }

    public void setMinute(int minute) {
        if (value != null) {
            Calendar cal = new GregorianCalendar();
            cal.setTime(value);
            cal.set(Calendar.MINUTE, minute);
            setValue(cal.getTime());
        }
    }
}